Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/Layout", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/alert', 'frontend-js-react-web$classnames', 'frontend-js-react-web', 'frontend-js-metal-web$metal-dom', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../prop-types/index', '../config/constants/itemActivationOrigins', '../config/constants/keycodes', '../config/constants/layoutDataItemTypes', '../config/constants/moveItemDirections', '../config/constants/pageTypes', '../config/index', '../store/index', '../thunks/moveItem', './Controls', './fragment-content/EditableProcessorContext', './layout-data-items/FragmentWithControls', './layout-data-items/index'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = Layout;

  var _alert = _interopRequireDefault(require("@frontend-taglib-clay$clayui/alert"));

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _frontendJsReactWeb = require("frontend-js-react-web");

  var _metalDom = require("frontend-js-metal-web$metal-dom");

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _index = require("../../prop-types/index");

  var _itemActivationOrigins = require("../config/constants/itemActivationOrigins");

  var _keycodes = require("../config/constants/keycodes");

  var _layoutDataItemTypes = require("../config/constants/layoutDataItemTypes");

  var _moveItemDirections = require("../config/constants/moveItemDirections");

  var _pageTypes = require("../config/constants/pageTypes");

  var _index2 = require("../config/index");

  var _index3 = require("../store/index");

  var _moveItem = _interopRequireDefault(require("../thunks/moveItem"));

  var _Controls = require("./Controls");

  var _EditableProcessorContext = require("./fragment-content/EditableProcessorContext");

  var _FragmentWithControls = _interopRequireDefault(require("./layout-data-items/FragmentWithControls"));

  var _index4 = require("./layout-data-items/index");

  var _LAYOUT_DATA_ITEMS;

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }return target;
    };return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
      }
    }return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
    }return target;
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var LAYOUT_DATA_ITEMS = (_LAYOUT_DATA_ITEMS = {}, _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection, _index4.CollectionWithControls), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collectionItem, _index4.CollectionItemWithControls), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.column, _index4.ColumnWithControls), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.container, _index4.ContainerWithControls), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.dropZone, _index4.DropZoneWithControls), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment, _FragmentWithControls["default"]), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragmentDropZone, _index4.Root), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.root, _index4.Root), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row, _index4.RowWithControls), _LAYOUT_DATA_ITEMS);

  function Layout(_ref) {
    var mainItemId = _ref.mainItemId;
    var activeItemId = (0, _Controls.useActiveItemId)();
    var dispatch = (0, _index3.useDispatch)();
    var fragmentEntryLinks = (0, _index3.useSelector)(function (state) {
      return state.fragmentEntryLinks;
    });
    var layoutData = (0, _index3.useSelector)(function (state) {
      return state.layoutData;
    });
    var mainItem = layoutData.items[mainItemId];
    var layoutRef = (0, _react.useRef)(null);
    var selectItem = (0, _Controls.useSelectItem)();
    var sidebarOpen = (0, _index3.useSelector)(function (state) {
      return state.sidebar.panelId && state.sidebar.open;
    });
    var store = (0, _index3.useSelector)(function (state) {
      return state;
    });

    var getDirection = function getDirection(keycode) {
      var direction = null;

      if (keycode === _keycodes.ARROW_UP_KEYCODE) {
        direction = _moveItemDirections.MOVE_ITEM_DIRECTIONS.UP;
      } else if (keycode === _keycodes.ARROW_DOWN_KEYCODE) {
        direction = _moveItemDirections.MOVE_ITEM_DIRECTIONS.DOWN;
      }

      return direction;
    };

    var onKeyUp = (0, _react.useCallback)(function (event) {
      event.preventDefault();

      if (!activeItemId) {
        return;
      }

      var item = layoutData.items[activeItemId];

      if (!item) {
        return;
      }

      var itemId = item.itemId,
          parentId = item.parentId;
      var direction = getDirection(event.keyCode);
      var parentItem = layoutData.items[parentId];

      if (direction) {
        var numChildren = parentItem.children.length;
        var currentPosition = parentItem.children.indexOf(itemId);

        if (direction === _moveItemDirections.MOVE_ITEM_DIRECTIONS.UP && currentPosition === 0 || direction === _moveItemDirections.MOVE_ITEM_DIRECTIONS.DOWN && currentPosition === numChildren - 1) {
          return;
        }

        var position;

        if (direction === _moveItemDirections.MOVE_ITEM_DIRECTIONS.UP) {
          position = currentPosition - 1;
        } else if (direction === _moveItemDirections.MOVE_ITEM_DIRECTIONS.DOWN) {
          position = currentPosition + 1;
        }

        dispatch((0, _moveItem["default"])({
          itemId: itemId,
          parentItemId: parentId,
          position: position,
          store: store
        }));
      }
    }, [activeItemId, dispatch, layoutData.items, store]);
    (0, _react.useEffect)(function () {
      var layout = layoutRef.current;

      var preventLinkClick = function preventLinkClick(event) {
        var closestElement = (0, _metalDom.closest)(event.target, '[href]');

        if (closestElement && !closestElement.dataset.lfrPageEditorHrefEnabled) {
          event.preventDefault();
        }
      };

      if (layout) {
        layout.addEventListener('click', preventLinkClick);
      }

      return function () {
        if (layout) {
          layout.removeEventListener('click', preventLinkClick);
        }
      };
    }, [layoutRef]);
    (0, _frontendJsReactWeb.useEventListener)('keyup', onKeyUp, false, document.body);
    var isPageConversion = _index2.config.pageType === _pageTypes.PAGE_TYPES.conversion;
    var hasWarningMessages = isPageConversion && _index2.config.layoutConversionWarningMessages && _index2.config.layoutConversionWarningMessages.length > 0;
    return _react["default"].createElement(_react["default"].Fragment, null, isPageConversion && _react["default"].createElement("div", {
      className: (0, _classnames["default"])('page-editor__conversion-messages', {
        'page-editor__conversion-messages--with-sidebar-open': sidebarOpen
      })
    }, _react["default"].createElement(_alert["default"], {
      displayType: "info",
      title: Liferay.Language.get('page-conversion-description'),
      variant: "stripe"
    }), hasWarningMessages && _react["default"].createElement(_alert["default"], {
      displayType: "warning",
      variant: "stripe"
    }, _index2.config.layoutConversionWarningMessages.map(function (message) {
      return _react["default"].createElement(_react["default"].Fragment, null, message, _react["default"].createElement("br", null));
    }))), _react["default"].createElement("div", {
      className: (0, _classnames["default"])('page-editor'),
      id: "page-editor",
      onClick: function onClick(event) {
        if (event.target === event.currentTarget) {
          selectItem(null);
        }
      },
      ref: layoutRef
    }, _react["default"].createElement(_EditableProcessorContext.EditableProcessorContextProvider, null, _react["default"].createElement(LayoutDataItem, {
      fragmentEntryLinks: fragmentEntryLinks,
      item: mainItem,
      layoutData: layoutData
    }))));
  }

  var LayoutDataItem =
  /*#__PURE__*/
  function (_React$PureComponent) {
    _inherits(LayoutDataItem, _React$PureComponent);

    _createClass(LayoutDataItem, null, [{
      key: "getDerivedStateFromError",
      value: function getDerivedStateFromError(error) {
        return {
          error: error
        };
      }
    }]);

    function LayoutDataItem(props) {
      var _this;

      _classCallCheck(this, LayoutDataItem);

      _this = _possibleConstructorReturn(this, _getPrototypeOf(LayoutDataItem).call(this, props));
      _this.state = {
        error: null
      };
      return _this;
    }

    _createClass(LayoutDataItem, [{
      key: "render",
      value: function render() {
        return this.state.error ? _react["default"].createElement(_alert["default"], {
          displayType: "danger",
          title: Liferay.Language.get('error')
        }, Liferay.Language.get('an-unexpected-error-occurred-while-rendering-this-item')) : _react["default"].createElement(LayoutDataItemContent, this.props);
      }
    }]);

    return LayoutDataItem;
  }(_react["default"].PureComponent);

  function LayoutDataItemContent(_ref2) {
    var fragmentEntryLinks = _ref2.fragmentEntryLinks,
        item = _ref2.item,
        layoutData = _ref2.layoutData,
        otherProps = _objectWithoutProperties(_ref2, ["fragmentEntryLinks", "item", "layoutData"]);

    var Component = LAYOUT_DATA_ITEMS[item.type];
    var activationOrigin = (0, _Controls.useActivationOrigin)();
    var isActive = (0, _Controls.useIsActive)()(item.itemId);
    var isMounted = (0, _frontendJsReactWeb.useIsMounted)();
    var componentRef = (0, _react.useRef)(null);
    (0, _react.useEffect)(function () {
      if (isActive && componentRef.current && isMounted() && activationOrigin === _itemActivationOrigins.ITEM_ACTIVATION_ORIGINS.structureTree) {
        componentRef.current.scrollIntoView({
          behavior: 'smooth',
          block: 'center',
          inline: 'nearest'
        });
      }
    }, [activationOrigin, componentRef, isActive, isMounted]);
    return _react["default"].createElement(Component, {
      item: item,
      layoutData: layoutData,
      ref: componentRef
    }, item.children.map(function (childId) {
      return _react["default"].createElement(LayoutDataItem, _extends({}, otherProps, {
        fragmentEntryLinks: fragmentEntryLinks,
        item: layoutData.items[childId],
        key: childId,
        layoutData: layoutData
      }));
    }));
  }
  //# sourceMappingURL=Layout.js.map
});
//# sourceMappingURL=Layout.js.map