Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/DragPreview", ['module', 'exports', 'require', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dnd', '../config/index', '../store/index'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = DragPreview;

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _reactDnd = require("frontend-js-react-web$react-dnd");

  var _index = require("../config/index");

  var _index2 = require("../store/index");

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var getItemStyles = function getItemStyles(currentOffset, ref, rtl) {
    if (!currentOffset || !ref.current) {
      return {
        display: 'none'
      };
    }

    var rect = ref.current.getBoundingClientRect();
    var x = rtl ? currentOffset.x + rect.width * 0.5 - window.innerWidth : currentOffset.x - rect.width * 0.5;
    var y = currentOffset.y - rect.height * 0.5;
    var transform = "translate(".concat(x, "px, ").concat(y, "px)");
    return {
      WebkitTransform: transform,
      transform: transform
    };
  };

  function DragPreview() {
    var ref = (0, _react.useRef)();
    var languageId = (0, _index2.useSelector)(function (state) {
      return state.languageId;
    });

    var _useDragLayer = (0, _reactDnd.useDragLayer)(function (monitor) {
      return {
        currentOffset: monitor.getClientOffset(),
        isDragging: monitor.isDragging(),
        item: monitor.getItem()
      };
    }),
        currentOffset = _useDragLayer.currentOffset,
        isDragging = _useDragLayer.isDragging,
        item = _useDragLayer.item;

    if (!isDragging) {
      return null;
    }

    return _react["default"].createElement("div", {
      className: "page-editor__drag-preview"
    }, _react["default"].createElement("div", {
      className: "page-editor__drag-preview__content",
      ref: ref,
      style: getItemStyles(currentOffset, ref, _index.config.languageDirection[languageId] === 'rtl')
    }, item && item.name ? item.name : Liferay.Language.get('element')));
  }
  //# sourceMappingURL=DragPreview.js.map
});
//# sourceMappingURL=DragPreview.js.map