Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/Controls", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../config/constants/itemActivationOrigins', '../config/constants/itemTypes', './CollectionItemContext'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.useSelectItem = exports.useIsHovered = exports.useIsActive = exports.useHoverItem = exports.useHoveredItemType = exports.useHoveredItemId = exports.useActiveItemType = exports.useActiveItemId = exports.useActivationOrigin = exports.reducer = exports.ControlsProvider = exports.ControlsConsumer = void 0;

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _itemActivationOrigins = require("../config/constants/itemActivationOrigins");

  var _itemTypes = require("../config/constants/itemTypes");

  var _CollectionItemContext = require("./CollectionItemContext");

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var INITIAL_STATE = {
    activationOrigin: null,
    activeItemId: null,
    activeItemType: null,
    hoveredItemId: null
  };
  var HOVER_ITEM = 'HOVER_ITEM';
  var SELECT_ITEM = 'SELECT_ITEM';

  var ControlsContext = _react["default"].createContext([INITIAL_STATE, function () {}]);

  var ControlsConsumer = ControlsContext.Consumer;
  exports.ControlsConsumer = ControlsConsumer;

  var reducer = function reducer(state, action) {
    var itemId = action.itemId,
        itemType = action.itemType,
        origin = action.origin,
        type = action.type;
    var nextState = state;

    if (type === HOVER_ITEM && itemId !== nextState.hoveredItemId) {
      nextState = _objectSpread({}, nextState, {
        hoveredItemId: itemId,
        hoveredItemType: itemType
      });
    } else if (type === SELECT_ITEM && itemId !== nextState.activeItemId) {
      nextState = _objectSpread({}, nextState, {
        activationOrigin: origin,
        activeItemId: itemId,
        activeItemType: itemType
      });
    }

    return nextState;
  };

  exports.reducer = reducer;

  var ControlsProvider = function ControlsProvider(_ref) {
    var _ref$initialState = _ref.initialState,
        initialState = _ref$initialState === void 0 ? INITIAL_STATE : _ref$initialState,
        children = _ref.children;
    var stateAndDispatch = (0, _react.useReducer)(reducer, initialState);
    return _react["default"].createElement(ControlsContext.Provider, {
      value: stateAndDispatch
    }, children);
  };

  exports.ControlsProvider = ControlsProvider;

  var useActivationOrigin = function useActivationOrigin() {
    var _useContext = (0, _react.useContext)(ControlsContext),
        _useContext2 = _slicedToArray(_useContext, 1),
        state = _useContext2[0];

    return state.activationOrigin;
  };

  exports.useActivationOrigin = useActivationOrigin;

  var useActiveItemId = function useActiveItemId() {
    var _useContext3 = (0, _react.useContext)(ControlsContext),
        _useContext4 = _slicedToArray(_useContext3, 1),
        state = _useContext4[0];

    var fromControlsId = (0, _CollectionItemContext.useFromControlsId)();
    return fromControlsId(state.activeItemId);
  };

  exports.useActiveItemId = useActiveItemId;

  var useActiveItemType = function useActiveItemType() {
    var _useContext5 = (0, _react.useContext)(ControlsContext),
        _useContext6 = _slicedToArray(_useContext5, 1),
        state = _useContext6[0];

    return state.activeItemType;
  };

  exports.useActiveItemType = useActiveItemType;

  var useHoveredItemId = function useHoveredItemId() {
    var _useContext7 = (0, _react.useContext)(ControlsContext),
        _useContext8 = _slicedToArray(_useContext7, 1),
        state = _useContext8[0];

    var fromControlsId = (0, _CollectionItemContext.useFromControlsId)();
    return fromControlsId(state.hoveredItemId);
  };

  exports.useHoveredItemId = useHoveredItemId;

  var useHoveredItemType = function useHoveredItemType() {
    var _useContext9 = (0, _react.useContext)(ControlsContext),
        _useContext10 = _slicedToArray(_useContext9, 1),
        state = _useContext10[0];

    return state.hoveredItemType;
  };

  exports.useHoveredItemType = useHoveredItemType;

  var useHoverItem = function useHoverItem() {
    var _useContext11 = (0, _react.useContext)(ControlsContext),
        _useContext12 = _slicedToArray(_useContext11, 2),
        dispatch = _useContext12[1];

    var toControlsId = (0, _CollectionItemContext.useToControlsId)();
    return (0, _react.useCallback)(function (itemId) {
      var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
        itemType: _itemTypes.ITEM_TYPES.layoutDataItem
      },
          _ref2$itemType = _ref2.itemType,
          itemType = _ref2$itemType === void 0 ? _itemTypes.ITEM_TYPES.layoutDataItem : _ref2$itemType;

      return dispatch({
        itemId: toControlsId(itemId),
        itemType: itemType,
        type: HOVER_ITEM
      });
    }, [dispatch, toControlsId]);
  };

  exports.useHoverItem = useHoverItem;

  var useIsActive = function useIsActive() {
    var _useContext13 = (0, _react.useContext)(ControlsContext),
        _useContext14 = _slicedToArray(_useContext13, 1),
        state = _useContext14[0];

    var toControlsId = (0, _CollectionItemContext.useToControlsId)();
    return (0, _react.useCallback)(function (itemId) {
      return state.activeItemId === toControlsId(itemId);
    }, [state.activeItemId, toControlsId]);
  };

  exports.useIsActive = useIsActive;

  var useIsHovered = function useIsHovered() {
    var _useContext15 = (0, _react.useContext)(ControlsContext),
        _useContext16 = _slicedToArray(_useContext15, 1),
        state = _useContext16[0];

    var toControlsId = (0, _CollectionItemContext.useToControlsId)();
    return (0, _react.useCallback)(function (itemId) {
      return state.hoveredItemId === toControlsId(itemId);
    }, [state.hoveredItemId, toControlsId]);
  };

  exports.useIsHovered = useIsHovered;

  var useSelectItem = function useSelectItem() {
    var _useContext17 = (0, _react.useContext)(ControlsContext),
        _useContext18 = _slicedToArray(_useContext17, 2),
        dispatch = _useContext18[1];

    var toControlsId = (0, _CollectionItemContext.useToControlsId)();
    return (0, _react.useCallback)(function (itemId) {
      var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
        itemType: _itemTypes.ITEM_TYPES.layoutDataItem
      },
          _ref3$itemType = _ref3.itemType,
          itemType = _ref3$itemType === void 0 ? _itemTypes.ITEM_TYPES.layoutDataItem : _ref3$itemType,
          _ref3$origin = _ref3.origin,
          origin = _ref3$origin === void 0 ? _itemActivationOrigins.ITEM_ACTIVATION_ORIGINS.pageEditor : _ref3$origin;

      return dispatch({
        itemId: toControlsId(itemId),
        itemType: itemType,
        origin: origin,
        type: SELECT_ITEM
      });
    }, [dispatch, toControlsId]);
  };

  exports.useSelectItem = useSelectItem;
  //# sourceMappingURL=Controls.js.map
});
//# sourceMappingURL=Controls.js.map