Liferay.Loader.define("layout-content-page-editor-web@2.0.32/page_editor/app/components/CollectionItemContext", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../services/FragmentService', '../services/InfoItemService'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.useGetFieldValue = exports.useToControlsId = exports.useFromControlsId = exports.useCollectionItemIndex = exports.useCollectionFields = exports.useGetContent = exports.useRenderFragmentContent = exports.CollectionItemContextProvider = exports.CollectionItemContext = void 0;

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _FragmentService = _interopRequireDefault(require("../services/FragmentService"));

  var _InfoItemService = _interopRequireDefault(require("../services/InfoItemService"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var defaultFromControlsId = function defaultFromControlsId(itemId) {
    return itemId;
  };

  var defaultToControlsId = function defaultToControlsId(controlId) {
    return controlId;
  };

  var INITIAL_STATE = {
    collectionFields: null,
    collectionItem: null,
    collectionItemIndex: null,
    fromControlsId: defaultFromControlsId,
    setCollectionItemContent: function setCollectionItemContent() {
      return null;
    },
    toControlsId: defaultToControlsId
  };

  var CollectionItemContext = _react["default"].createContext(INITIAL_STATE);

  exports.CollectionItemContext = CollectionItemContext;
  var CollectionItemContextProvider = CollectionItemContext.Provider;
  exports.CollectionItemContextProvider = CollectionItemContextProvider;

  var useFromControlsId = function useFromControlsId() {
    var context = (0, _react.useContext)(CollectionItemContext);
    return context.fromControlsId || defaultFromControlsId;
  };

  exports.useFromControlsId = useFromControlsId;

  var useCollectionItemIndex = function useCollectionItemIndex() {
    var context = (0, _react.useContext)(CollectionItemContext);
    return context.collectionItemIndex;
  };

  exports.useCollectionItemIndex = useCollectionItemIndex;

  var useToControlsId = function useToControlsId() {
    var context = (0, _react.useContext)(CollectionItemContext);
    return context.toControlsId || defaultToControlsId;
  };

  exports.useToControlsId = useToControlsId;

  var useCollectionFields = function useCollectionFields() {
    var context = (0, _react.useContext)(CollectionItemContext);
    return context.collectionFields;
  };

  exports.useCollectionFields = useCollectionFields;

  var useGetContent = function useGetContent() {
    var context = (0, _react.useContext)(CollectionItemContext);
    return (0, _react.useCallback)(function (fragmentEntryLink) {
      if (context.collectionItemIndex != null) {
        var collectionContent = fragmentEntryLink.collectionContent || [];
        return collectionContent[context.collectionItemIndex] || fragmentEntryLink.content;
      }

      return fragmentEntryLink.content;
    }, [context.collectionItemIndex]);
  };

  exports.useGetContent = useGetContent;

  var useGetFieldValue = function useGetFieldValue() {
    var context = (0, _react.useContext)(CollectionItemContext);
    var getFromServer = (0, _react.useCallback)(function (_ref) {
      var classNameId = _ref.classNameId,
          classPK = _ref.classPK,
          fieldId = _ref.fieldId,
          languageId = _ref.languageId;
      return _InfoItemService["default"].getAssetFieldValue({
        classNameId: classNameId,
        classPK: classPK,
        fieldId: fieldId,
        languageId: languageId,
        onNetworkStatus: function onNetworkStatus() {}
      }).then(function (response) {
        var _response$fieldValue = response.fieldValue,
            fieldValue = _response$fieldValue === void 0 ? '' : _response$fieldValue;
        return fieldValue;
      });
    }, []);
    var getFromCollectionItem = (0, _react.useCallback)(function (_ref2) {
      var collectionFieldId = _ref2.collectionFieldId;
      return context.collectionItem[collectionFieldId] !== null && context.collectionItem[collectionFieldId] !== undefined ? Promise.resolve(context.collectionItem[collectionFieldId]) : Promise.reject();
    }, [context.collectionItem]);

    if (context.collectionFields !== null && context.collectionItem !== null) {
      return getFromCollectionItem;
    } else {
      return getFromServer;
    }
  };

  exports.useGetFieldValue = useGetFieldValue;

  var useRenderFragmentContent = function useRenderFragmentContent() {
    var context = (0, _react.useContext)(CollectionItemContext);

    var _ref3 = context.collectionItem || {},
        className = _ref3.className,
        classPK = _ref3.classPK;

    return (0, _react.useCallback)(function (_ref4) {
      var fragmentEntryLinkId = _ref4.fragmentEntryLinkId,
          onNetworkStatus = _ref4.onNetworkStatus,
          segmentsExperienceId = _ref4.segmentsExperienceId;
      return _FragmentService["default"].renderFragmentEntryLinkContent({
        collectionItemClassName: className,
        collectionItemClassPK: classPK,
        fragmentEntryLinkId: fragmentEntryLinkId,
        onNetworkStatus: onNetworkStatus,
        segmentsExperienceId: segmentsExperienceId
      }).then(function (_ref5) {
        var content = _ref5.content;
        return {
          collectionItemIndex: context.collectionItemIndex,
          content: content
        };
      });
    }, [className, classPK, context.collectionItemIndex]);
  };

  exports.useRenderFragmentContent = useRenderFragmentContent;
  //# sourceMappingURL=CollectionItemContext.js.map
});
//# sourceMappingURL=CollectionItemContext.js.map