"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/utils/FragmentsEditorDragDrop.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-aop', 'frontend-js-metal-web$metal-drag-drop', './constants', 'frontend-js-metal-web$metal-position'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.initializeDragDrop = initializeDragDrop;

  var _metalAop = require("frontend-js-metal-web$metal-aop");

  var _metalDragDrop = require("frontend-js-metal-web$metal-drag-drop");

  var _constants = require("./constants");

  var _metalPosition = require("frontend-js-metal-web$metal-position");

  var _getRegionInterceptor = null;
  /**
   * Stops intercepting metal-position getRegion calls
   * @private
   * @review
   * @see {_interceptGetRegion}
   */

  function _stopInterceptGetRegion() {
    if (_getRegionInterceptor) {
      _getRegionInterceptor.detach();

      _getRegionInterceptor = null;
    }
  }
  /**
   * Uses metal-aop to intercept metal-position getRegion calls
   * and take into account bootstrap's negative margins.
   * @private
   * @review
   * @see {_stopInterceptGetRegion}
   */

  function _interceptGetRegion() {
    _getRegionInterceptor = _getRegionInterceptor || _metalAop.AOP.after(function (target) {
      var newReturnVal;

      if (target instanceof HTMLElement && target.classList.contains('col') && target.parentElement && target.parentElement.classList.contains('row')) {
        var currentRetVal = Object.assign({}, _metalAop.AOP.currentRetVal);
        var parentComputedStyle = window.getComputedStyle(target.parentElement);
        var negativeLeftMargin = Math.min(parseInt(parentComputedStyle.marginLeft, 10) || 0, 0);
        var negativeRightMargin = Math.min(parseInt(parentComputedStyle.marginRight, 10) || 0, 0);
        currentRetVal.width = currentRetVal.width + negativeLeftMargin + negativeRightMargin;
        currentRetVal.left -= negativeLeftMargin;
        currentRetVal.right += negativeRightMargin;
        newReturnVal = _metalAop.AOP.alterReturn(currentRetVal);
      }

      return newReturnVal;
    }, _metalPosition.Position, 'getRegion');
  }
  /**
   * @param {object} dragDropOptions
   * @review
   */

  function initializeDragDrop(dragDropOptions) {
    var dragDrop = new _metalDragDrop.DragDrop(Object.assign({
      autoScroll: true,
      draggingClass: _constants.FRAGMENTS_EDITOR_DRAGGING_CLASS,
      dragPlaceholder: _metalDragDrop.Drag.Placeholder.CLONE,
      scrollContainers: '.fragment-entry-link-list-wrapper'
    }, dragDropOptions));
    dragDrop.on('dispose', _stopInterceptGetRegion);
    dragDrop.on(_metalDragDrop.Drag.Events.START, _interceptGetRegion);
    dragDrop.on(_metalDragDrop.DragDrop.Events.END, _stopInterceptGetRegion);
    return dragDrop;
  }
  //# sourceMappingURL=FragmentsEditorDragDrop.es.js.map
});
//# sourceMappingURL=FragmentsEditorDragDrop.es.js.map