"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/utils/FragmentsEditorDialogUtils", ['module', 'exports', 'require', '../actions/actions.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.openAssetBrowser = openAssetBrowser;
  exports.openImageSelector = openImageSelector;
  exports.startListeningWidgetConfigurationChange = startListeningWidgetConfigurationChange;
  exports.stopListeningWidgetConfigurationChange = stopListeningWidgetConfigurationChange;

  var _actions = require("../actions/actions.es");

  /**
   * @private
   * @review
   * @type {null|{detach: Function}}
   */
  var _widgetConfigurationChangeHandler = null;
  /**
   * Possible types that can be returned by the image selector
   */

  var IMAGE_SELECTOR_RETURN_TYPES = {
    downloadUrl: 'com.liferay.item.selector.criteria.DownloadURLItemSelectorReturnType',
    fileEntryItemSelector: 'com.liferay.item.selector.criteria.FileEntryItemSelectorReturnType',
    url: 'URL'
  };
  /**
   * @param {object} options
   * @param {function} options.callback
   * @param {string} options.assetBrowserURL
   * @param {string} options.modalTitle
   * @param {string} options.portletNamespace
   * @param {function} [options.destroyedCallback=null]
   */

  function openAssetBrowser(_ref) {
    var assetBrowserURL = _ref.assetBrowserURL,
        callback = _ref.callback,
        modalTitle = _ref.modalTitle,
        portletNamespace = _ref.portletNamespace,
        _ref$destroyedCallbac = _ref.destroyedCallback,
        destroyedCallback = _ref$destroyedCallbac === void 0 ? null : _ref$destroyedCallbac;
    Liferay.Util.selectEntity({
      dialog: {
        constrain: true,
        destroyOnHide: true,
        modal: true
      },
      eventName: "".concat(portletNamespace, "selectAsset"),
      title: modalTitle,
      uri: assetBrowserURL
    }, function (event) {
      if (event.assetclassnameid) {
        callback({
          classNameId: event.assetclassnameid,
          classPK: event.assetclasspk,
          title: event.assettitle
        });
      } else if (destroyedCallback) {
        destroyedCallback();
      }
    });
  }
  /**
   * @param {object} options
   * @param {function} options.callback
   * @param {string} options.imageSelectorURL
   * @param {string} options.portletNamespace
   * @param {function} [options.destroyedCallback=null]
   */

  function openImageSelector(_ref2) {
    var callback = _ref2.callback,
        imageSelectorURL = _ref2.imageSelectorURL,
        portletNamespace = _ref2.portletNamespace,
        _ref2$destroyedCallba = _ref2.destroyedCallback,
        destroyedCallback = _ref2$destroyedCallba === void 0 ? null : _ref2$destroyedCallba;
    AUI().use('liferay-item-selector-dialog', function (A) {
      var itemSelector = new A.LiferayItemSelectorDialog({
        eventName: "".concat(portletNamespace, "selectImage"),
        on: {
          selectedItemChange: function selectedItemChange(event) {
            var selectedItem = event.newVal || {};
            var returnType = selectedItem.returnType,
                value = selectedItem.value;
            var selectedImageURL = '';

            if (returnType === IMAGE_SELECTOR_RETURN_TYPES.downloadUrl || returnType === IMAGE_SELECTOR_RETURN_TYPES.url) {
              selectedImageURL = value;
            }

            if (returnType === IMAGE_SELECTOR_RETURN_TYPES.fileEntryItemSelector) {
              selectedImageURL = JSON.parse(value).url;
            }

            if (selectedImageURL) {
              callback(selectedImageURL);
            }
          },
          visibleChange: function visibleChange(event) {
            if (event.newVal === false && destroyedCallback) {
              destroyedCallback();
            }
          }
        },
        title: Liferay.Language.get('select'),
        url: imageSelectorURL
      });
      itemSelector.open();
    });
  }
  /**
   * @param {{dispatch: Function}} store
   * @review
   */

  function startListeningWidgetConfigurationChange(store) {
    stopListeningWidgetConfigurationChange();
    var submitFormHandler = null;
    _widgetConfigurationChangeHandler = Liferay.after('popupReady', function (event) {
      if (submitFormHandler) {
        submitFormHandler.detach();
        submitFormHandler = null;
      }

      submitFormHandler = event.win.Liferay.on('submitForm', function () {
        store.dispatch({
          lastSaveDate: new Date(),
          type: _actions.UPDATE_LAST_SAVE_DATE
        });
      });
    });
  }
  /**
   * @review
   */

  function stopListeningWidgetConfigurationChange() {
    if (_widgetConfigurationChangeHandler) {
      _widgetConfigurationChangeHandler.detach();

      _widgetConfigurationChangeHandler = null;
    }
  }
  //# sourceMappingURL=FragmentsEditorDialogUtils.js.map
});
//# sourceMappingURL=FragmentsEditorDialogUtils.js.map