"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/utils/FragmentsEditorComponentUtils.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.shouldUpdateOnChangeProperties = exports.shouldUpdatePureComponent = void 0;

  /**
   * Returns true if any change is different
   * @param {object} changes
   * @return {boolean}
   * @review
   */
  var shouldUpdatePureComponent = function shouldUpdatePureComponent(changes) {
    return Object.values(changes).filter(function (change) {
      return change.key !== 'events';
    }).some(function (change) {
      return change.newVal !== change.prevVal;
    });
  };
  /**
   * Returns true if any of the given properties has changed
   * @param {object} changes
   * @param {string[]} properties
   * @return {boolean}
   */

  exports.shouldUpdatePureComponent = shouldUpdatePureComponent;

  var shouldUpdateOnChangeProperties = function shouldUpdateOnChangeProperties(changes, properties) {
    return Object.values(changes).filter(function (change) {
      return properties.indexOf(change.key) !== -1;
    }).some(function (change) {
      return change.newVal !== change.prevVal;
    });
  };

  exports.shouldUpdateOnChangeProperties = shouldUpdateOnChangeProperties;
  //# sourceMappingURL=FragmentsEditorComponentUtils.es.js.map
});
//# sourceMappingURL=FragmentsEditorComponentUtils.es.js.map