"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/store/ConnectedComponent.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state', './store.es', './state.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.getConnectedComponent = void 0;

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _store = require("./store.es");

  var _state = _interopRequireDefault(require("./state.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * HOC that returns a component that connects automatically
   * to a Store parameter.
   * @param {Component} Component
   * @param {string[]} [properties=[]] List of properties to be fetched from store
   * @return {Component}
   */
  var getConnectedComponent = function getConnectedComponent(Component, properties) {
    /**
     * ConnectedComponent
     */
    var ConnectedComponent =
    /*#__PURE__*/
    function (_Component) {
      _inherits(ConnectedComponent, _Component);

      /**
       * @inheritdoc
       * @param {object} props
       * @param  {...any} ...args
       */
      function ConnectedComponent(props) {
        var _getPrototypeOf2;

        var _this;

        _classCallCheck(this, ConnectedComponent);

        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }

        _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(ConnectedComponent)).call.apply(_getPrototypeOf2, [this, props].concat(args)));

        _this.on('storeChanged', function (change) {
          var newStore = change.newVal;
          var prevStore = change.prevVal;

          if (newStore !== prevStore) {
            (0, _store.disconnect)(_assertThisInitialized(_this));

            if (newStore instanceof _store.Store) {
              (0, _store.connect)(_assertThisInitialized(_this), newStore);
            }
          }
        });

        _this.on('disposed', function () {
          (0, _store.disconnect)(_assertThisInitialized(_this));
        });

        if (props.store instanceof _store.Store) {
          (0, _store.connect)(_assertThisInitialized(_this), props.store);
        }

        return _this;
      }

      return ConnectedComponent;
    }(Component);
    /**
     * Connected component state
     */

    ConnectedComponent.STATE = {
      store: _metalState.Config.instanceOf(_store.Store).value(null)
    };
    properties.forEach(function (property) {
      try {
        ConnectedComponent.STATE[property] = _state.default[property].internal();
      } catch (e) {
        throw new Error("".concat(property, " is not available from ").concat(Component.name));
      }
    });
    return ConnectedComponent;
  };

  exports.getConnectedComponent = getConnectedComponent;
  var _default = getConnectedComponent;
  exports.default = _default;
  //# sourceMappingURL=ConnectedComponent.es.js.map
});
//# sourceMappingURL=ConnectedComponent.es.js.map