"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/reducers/fragments.es", ['module', 'exports', 'require', '../actions/actions.es', '../utils/FragmentsEditorUpdateUtils.es', '../utils/LayoutDataList.es', '../utils/constants', '../utils/FragmentsEditorGetUtils.es', '../utils/FragmentsEditorFetchUtils.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.addFragment = addFragment;
  exports.addFragmentEntryLinkReducer = addFragmentEntryLinkReducer;
  exports.clearFragmentEditorReducer = clearFragmentEditorReducer;
  exports.disableFragmentEditorReducer = disableFragmentEditorReducer;
  exports.enableFragmentEditorReducer = enableFragmentEditorReducer;
  exports.getFragmentEntryLinkContent = getFragmentEntryLinkContent;
  exports.moveFragmentEntryLinkReducer = moveFragmentEntryLinkReducer;
  exports.removeFragmentEntryLinkReducer = removeFragmentEntryLinkReducer;
  exports.updateEditableValueReducer = updateEditableValueReducer;
  exports.updateFragmentEntryLinkConfigReducer = updateFragmentEntryLinkConfigReducer;

  var _actions = require("../actions/actions.es");

  var _FragmentsEditorUpdateUtils = require("../utils/FragmentsEditorUpdateUtils.es");

  var _LayoutDataList = require("../utils/LayoutDataList.es");

  var _constants = require("../utils/constants");

  var _FragmentsEditorGetUtils = require("../utils/FragmentsEditorGetUtils.es");

  var _FragmentsEditorFetchUtils = require("../utils/FragmentsEditorFetchUtils.es");

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  /**
   * Adds a fragment at the corresponding container in the layout
   * @param {string} fragmentEntryLinkId
   * @param {string} dropTargetBorder
   * @param {string} dropTargetItemId
   * @param {string} dropTargetItemType
   * @param {object} layoutData
   * @param {string} fragmentEntryLinkRowType
   * @private
   * @return {object}
   * @review
   */
  function addFragment(fragmentEntryLinkId, dropTargetBorder, dropTargetItemId, dropTargetItemType, layoutData) {
    var fragmentEntryLinkRowType = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : _constants.FRAGMENTS_EDITOR_ROW_TYPES.componentRow;
    var nextData = layoutData;

    if (dropTargetItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.column) {
      var fragmentColumn = (0, _FragmentsEditorGetUtils.getColumn)(layoutData.structure, dropTargetItemId);
      nextData = _addFragmentToColumn(layoutData, fragmentEntryLinkId, dropTargetItemId, fragmentColumn.fragmentEntryLinkIds.length);
    } else if (dropTargetItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment) {
      var _fragmentColumn = (0, _FragmentsEditorGetUtils.getFragmentColumn)(layoutData.structure, dropTargetItemId);

      var position = _getDropFragmentPosition(_fragmentColumn.fragmentEntryLinkIds, dropTargetItemId, dropTargetBorder);

      nextData = _addFragmentToColumn(layoutData, fragmentEntryLinkId, _fragmentColumn.columnId, position);
    } else if (dropTargetItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.row) {
      var _position = (0, _FragmentsEditorGetUtils.getDropRowPosition)(layoutData.structure, dropTargetItemId, dropTargetBorder);

      nextData = _addSingleFragmentRow(layoutData, fragmentEntryLinkId, fragmentEntryLinkRowType, _position);
    } else {
      nextData = _addSingleFragmentRow(layoutData, fragmentEntryLinkId, fragmentEntryLinkRowType, layoutData.structure.length);
    }

    return nextData;
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.type
   * @param {string} action.fragmentEntryKey
   * @param {string} action.fragmentEntryLinkType
   * @param {string} action.fragmentName
   * @return {object}
   * @review
   */

  function addFragmentEntryLinkReducer(state, action) {
    return new Promise(function (resolve) {
      var nextState = state;

      if (action.type === _actions.ADD_FRAGMENT_ENTRY_LINK) {
        var fragmentEntryLink = null;
        var nextData = null;

        _addFragmentEntryLink(nextState.addFragmentEntryLinkURL, action.fragmentEntryKey, action.fragmentName, nextState.classNameId, nextState.classPK, nextState.portletNamespace, nextState.segmentsExperienceId).then(function (response) {
          fragmentEntryLink = response;
          nextData = addFragment(fragmentEntryLink.fragmentEntryLinkId, nextState.dropTargetBorder, nextState.dropTargetItemId, nextState.dropTargetItemType, nextState.layoutData, action.fragmentEntryLinkRowType);
          return (0, _FragmentsEditorFetchUtils.updatePageEditorLayoutData)(nextData, nextState.segmentsExperienceId);
        }).then(function () {
          return getFragmentEntryLinkContent(nextState.renderFragmentEntryURL, fragmentEntryLink, nextState.portletNamespace);
        }).then(function (response) {
          fragmentEntryLink = response;
          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['fragmentEntryLinks', fragmentEntryLink.fragmentEntryLinkId], fragmentEntryLink);
          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutData'], nextData);
          resolve(nextState);
        }).catch(function () {
          resolve(nextState);
        });
      } else {
        resolve(nextState);
      }
    });
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.itemId
   * @param {string} action.type
   * @return {object}
   * @review
   */

  function clearFragmentEditorReducer(state, action) {
    var nextState = state;

    if (action.type === _actions.CLEAR_FRAGMENT_EDITOR) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['fragmentEditorClear'], action.itemId);
    }

    return nextState;
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.type
   * @return {object}
   * @review
   */

  function disableFragmentEditorReducer(state, action) {
    var nextState = state;

    if (action.type === _actions.DISABLE_FRAGMENT_EDITOR) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['fragmentEditorEnabled'], null);
    }

    return nextState;
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.type
   * @param {string} action.itemId
   * @return {object}
   * @review
   */

  function enableFragmentEditorReducer(state, action) {
    var nextState = state;

    if (action.type === _actions.ENABLE_FRAGMENT_EDITOR) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['fragmentEditorEnabled'], action.itemId);
    }

    return nextState;
  }
  /**
   * @param {string} renderFragmentEntryURL
   * @param {{fragmentEntryLinkId: string}} fragmentEntryLink
   * @param {string} portletNamespace
   * @return {Promise<object>}
   * @review
   */

  function getFragmentEntryLinkContent(renderFragmentEntryURL, fragmentEntryLink, portletNamespace) {
    var formData = new FormData();
    formData.append("".concat(portletNamespace, "fragmentEntryLinkId"), fragmentEntryLink.fragmentEntryLinkId);
    return fetch(renderFragmentEntryURL, {
      body: formData,
      credentials: 'include',
      method: 'POST'
    }).then(function (response) {
      return response.json();
    }).then(function (response) {
      if (!response.content) {
        throw new Error();
      }

      fragmentEntryLink = (0, _FragmentsEditorUpdateUtils.setIn)(fragmentEntryLink, ['content'], response.content);
      return (0, _FragmentsEditorUpdateUtils.setIn)(fragmentEntryLink, ['error'], response.error);
    });
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.fragmentEntryLinkId
   * @param {string} action.fragmentEntryLinkType
   * @param {string} action.targetBorder
   * @param {string} action.targetItemId
   * @param {string} action.targetItemType
   * @param {string} action.type
   * @return {object}
   * @review
   */

  function moveFragmentEntryLinkReducer(state, action) {
    return new Promise(function (resolve) {
      var nextState = state;

      if (action.type === _actions.MOVE_FRAGMENT_ENTRY_LINK) {
        var nextData = null;
        nextData = _removeFragment(nextState.layoutData, action.fragmentEntryLinkId, action.fragmentEntryLinkRowType);
        nextData = addFragment(action.fragmentEntryLinkId, action.targetBorder, action.targetItemId, action.targetItemType, nextData, action.fragmentEntryLinkRowType);
        (0, _FragmentsEditorFetchUtils.updatePageEditorLayoutData)(nextData, nextState.segmentsExperienceId).then(function (response) {
          if (response.error) {
            throw response.error;
          }

          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutData'], nextData);
          resolve(nextState);
        }).catch(function () {
          resolve(nextState);
        });
      } else {
        resolve(nextState);
      }
    });
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.fragmentEntryLinkId
   * @param {string} action.fragmentEntryLinkRowType
   * @param {string} action.type
   * @return {Promise<object>}
   * @review
   */

  function removeFragmentEntryLinkReducer(state, action) {
    return new Promise(function (resolve) {
      var nextState = state;

      if (action.type === _actions.REMOVE_FRAGMENT_ENTRY_LINK) {
        var fragmentEntryLinkId = action.fragmentEntryLinkId;
        var fragmentEntryLinkRow = nextState.layoutData.structure[(0, _FragmentsEditorGetUtils.getFragmentRowIndex)(nextState.layoutData.structure, fragmentEntryLinkId)];
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutData'], _removeFragment(nextState.layoutData, fragmentEntryLinkId, fragmentEntryLinkRow.type || _constants.FRAGMENTS_EDITOR_ROW_TYPES.componentRow));
        nextState = (0, _FragmentsEditorUpdateUtils.updateWidgets)(nextState, action.fragmentEntryLinkId);

        var _shouldRemoveFragmentEntryLink = !(0, _LayoutDataList.containsFragmentEntryLinkId)(nextState.layoutDataList, fragmentEntryLinkId, nextState.segmentsExperienceId || nextState.defaultSegmentsExperienceId);

        var updateLayoutDataPromise = (0, _FragmentsEditorFetchUtils.updatePageEditorLayoutData)(nextState.layoutData, nextState.segmentsExperienceId);

        if (_shouldRemoveFragmentEntryLink) {
          nextState = (0, _FragmentsEditorUpdateUtils.updateIn)(nextState, ['fragmentEntryLinks'], function (fragmentEntryLinks) {
            var nextFragmentEntryLinks = Object.assign({}, fragmentEntryLinks);
            delete nextFragmentEntryLinks[fragmentEntryLinkId];
            return nextFragmentEntryLinks;
          }, {});
          updateLayoutDataPromise = updateLayoutDataPromise.then(function () {
            return (0, _FragmentsEditorFetchUtils.removeFragmentEntryLinks)(nextState.layoutData, [fragmentEntryLinkId], nextState.segmentsExperienceId);
          });
        }

        updateLayoutDataPromise.then(function () {
          resolve(nextState);
        }).catch(function () {
          resolve(nextState);
        });
      } else {
        resolve(nextState);
      }
    });
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.type
   * @param {string} action.fragmentEntryLinkId
   * @param {string} action.editableValues
   * @param {Date} action.date
   * @return {object}
   * @review
   */

  function updateEditableValueReducer(state, action) {
    var nextState = state;

    if (action.type === _actions.UPDATE_EDITABLE_VALUE_ERROR || action.type === _actions.UPDATE_EDITABLE_VALUE_LOADING) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['fragmentEntryLinks', action.fragmentEntryLinkId, 'editableValues'], action.editableValues);
    }

    return nextState;
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {object} action.config
   * @param {string} action.editableId
   * @param {string} action.fragmentEntryLinkId
   * @param {string} action.type
   * @return {object}
   * @review
   */

  function updateFragmentEntryLinkConfigReducer(state, action) {
    var nextState = state;
    return new Promise(function (resolve) {
      if (action.type === _actions.UPDATE_CONFIG_ATTRIBUTES) {
        var config = action.config,
            editableId = action.editableId,
            fragmentEntryLinkId = action.fragmentEntryLinkId;
        var editableValues = nextState.fragmentEntryLinks[fragmentEntryLinkId].editableValues;
        Object.entries(config).forEach(function (entry) {
          var _entry = _slicedToArray(entry, 2),
              key = _entry[0],
              value = _entry[1];

          var keysTreeArray = [_constants.EDITABLE_FRAGMENT_ENTRY_PROCESSOR, editableId, 'config', key];
          editableValues = (0, _FragmentsEditorUpdateUtils.setIn)(editableValues, keysTreeArray, value);
        });
        var formData = new FormData();
        formData.append("".concat(nextState.portletNamespace, "fragmentEntryLinkId"), fragmentEntryLinkId);
        formData.append("".concat(nextState.portletNamespace, "editableValues"), JSON.stringify(editableValues));
        fetch(nextState.editFragmentEntryLinkURL, {
          body: formData,
          credentials: 'include',
          method: 'POST'
        }).then(function () {
          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['fragmentEntryLinks', fragmentEntryLinkId, 'editableValues'], editableValues);
          resolve(nextState);
        });
      } else {
        resolve(nextState);
      }
    });
  }
  /**
   * @param {string} addFragmentEntryLinkURL
   * @param {string} fragmentEntryKey
   * @param {string} fragmentName
   * @param {string} classNameId
   * @param {string} classPK
   * @param {string} portletNamespace
   * @return {object}
   * @review
   */

  function _addFragmentEntryLink(addFragmentEntryLinkURL, fragmentEntryKey, fragmentName, classNameId, classPK, portletNamespace, segmentsExperienceId) {
    var formData = new FormData();
    formData.append("".concat(portletNamespace, "fragmentKey"), fragmentEntryKey);
    formData.append("".concat(portletNamespace, "classNameId"), classNameId);
    formData.append("".concat(portletNamespace, "classPK"), classPK);
    formData.append("".concat(portletNamespace, "segmentsExperienceId"), segmentsExperienceId);
    return fetch(addFragmentEntryLinkURL, {
      body: formData,
      credentials: 'include',
      method: 'POST'
    }).then(function (response) {
      return response.json();
    }).then(function (response) {
      if (!response.fragmentEntryLinkId) {
        throw new Error();
      }

      return {
        config: {},
        content: '',
        editableValues: JSON.parse(response.editableValues),
        fragmentEntryKey: fragmentEntryKey,
        fragmentEntryLinkId: response.fragmentEntryLinkId,
        name: fragmentName
      };
    });
  }
  /**
   * Returns a new layoutData with the given fragmentEntryLinkId inserted
   * into a given column at the given position
   *
   * @param {object} layoutData
   * @param {string} fragmentEntryLinkId
   * @param {string} targetColumnId
   * @param {number} position
   * @return {object}
   */

  function _addFragmentToColumn(layoutData, fragmentEntryLinkId, targetColumnId, position) {
    var structure = layoutData.structure;
    var column = (0, _FragmentsEditorGetUtils.getColumn)(structure, targetColumnId);
    var row = structure.find(function (_row) {
      return _row.columns.find(function (_column) {
        return column === _column;
      });
    });
    var columnIndex = row.columns.indexOf(column);
    var rowIndex = structure.indexOf(row);
    return (0, _FragmentsEditorUpdateUtils.updateIn)(layoutData, ['structure', rowIndex, 'columns', columnIndex, 'fragmentEntryLinkIds'], function (fragmentEntryLinkIds) {
      return (0, _FragmentsEditorUpdateUtils.add)(fragmentEntryLinkIds, fragmentEntryLinkId, position);
    });
  }
  /**
   * Returns a new layoutData with the given fragmentEntryLinkId inserted
   * into a single-column new row. The row will be created at the given position.
   *
   * @param {object} layoutData
   * @param {string} fragmentEntryLinkId
   * @param {string} fragmentEntryLinkRowType
   * @param {number} position
   * @return {object}
   */

  function _addSingleFragmentRow(layoutData, fragmentEntryLinkId, fragmentEntryLinkRowType, position) {
    return (0, _FragmentsEditorUpdateUtils.addRow)(['12'], layoutData, position, [fragmentEntryLinkId], fragmentEntryLinkRowType);
  }
  /**
   * @param {string[]} fragmentEntryLinkIds
   * @param {string} targetFragmentEntryLinkId
   * @param {FRAGMENTS_EDITOR_ITEM_BORDERS} targetBorder
   * @return {number}
   * @review
   */

  function _getDropFragmentPosition(fragmentEntryLinkIds, targetFragmentEntryLinkId, targetBorder) {
    var position = fragmentEntryLinkIds.length;
    var targetPosition = fragmentEntryLinkIds.indexOf(targetFragmentEntryLinkId);

    if (targetPosition > -1 && targetBorder) {
      if (targetBorder === _constants.FRAGMENTS_EDITOR_ITEM_BORDERS.top) {
        position = targetPosition;
      } else {
        position = targetPosition + 1;
      }
    }

    return position;
  }
  /**
   * Removes a given fragmentEntryLinkId from a given layoutData.
   * It does not remove it from fragmentEntryLinks array.
   *
   * If the fragmentEntryLinkRowType is "section", it will remove the whole
   * row (and columns) too.
   *
   * @param {object} layoutData
   * @param {string} fragmentEntryLinkId
   * @param {string} [fragmentEntryLinkRowType=FRAGMENTS_EDITOR_ROW_TYPES.componentRow]
   * @return {object} Next layout data
   * @review
   */

  function _removeFragment(layoutData, fragmentEntryLinkId) {
    var fragmentEntryLinkRowType = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _constants.FRAGMENTS_EDITOR_ROW_TYPES.componentRow;
    var structure = layoutData.structure;
    var column = (0, _FragmentsEditorGetUtils.getFragmentColumn)(structure, fragmentEntryLinkId);
    var row = structure.find(function (_row) {
      return _row.columns.find(function (_column) {
        return column === _column;
      });
    });
    var columnIndex = row.columns.indexOf(column);
    var fragmentIndex = column.fragmentEntryLinkIds.indexOf(fragmentEntryLinkId);
    var rowIndex = structure.indexOf(row);
    var nextData = null;

    if (fragmentEntryLinkRowType === _constants.FRAGMENTS_EDITOR_ROW_TYPES.sectionRow) {
      nextData = (0, _FragmentsEditorUpdateUtils.updateIn)(layoutData, ['structure'], function (structure) {
        return (0, _FragmentsEditorUpdateUtils.remove)(structure, rowIndex);
      });
    } else {
      nextData = (0, _FragmentsEditorUpdateUtils.updateIn)(layoutData, ['structure', rowIndex, 'columns', columnIndex, 'fragmentEntryLinkIds'], function (fragmentEntryLinkIds) {
        return (0, _FragmentsEditorUpdateUtils.remove)(fragmentEntryLinkIds, fragmentIndex);
      });
    }

    return nextData;
  }
  //# sourceMappingURL=fragments.es.js.map
});
//# sourceMappingURL=fragments.es.js.map