"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/reducers/changes.es", ['module', 'exports', 'require', '../utils/FragmentsEditorUpdateUtils.es', '../actions/actions.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.saveChangesReducer = saveChangesReducer;

  var _FragmentsEditorUpdateUtils = require("../utils/FragmentsEditorUpdateUtils.es");

  var _actions = require("../actions/actions.es");

  /**
   * @param {!object} state
   * @param {object} action
   * @param {Date} action.lastSaveDate
   * @param {boolean} action.savingChanges
   * @param {string} action.type
   * @return {object}
   * @review
   */
  function saveChangesReducer(state, action) {
    var nextState = state;

    if (action.type === _actions.UPDATE_LAST_SAVE_DATE) {
      var newDate = action.lastSaveDate.toLocaleTimeString(Liferay.ThemeDisplay.getBCP47LanguageId());
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['lastSaveDate'], newDate);
    } else if (action.type === _actions.UPDATE_SAVING_CHANGES_STATUS) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['savingChanges'], Boolean(action.savingChanges));
    }

    return nextState;
  }
  //# sourceMappingURL=changes.es.js.map
});
//# sourceMappingURL=changes.es.js.map