"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/components/toolbar/SegmentsExperienceSelector.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', '../../store/ConnectedComponent.es', './segmentsExperiences/modal.es', './SegmentsExperienceSelector.soy', '../../actions/actions.es', 'frontend-js-web/liferay/compat/modal/Modal.es', '../../utils/FragmentsEditorUpdateUtils.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.ConnectedSegmentsExperienceSelector = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireWildcard(require("frontend-js-metal-web$metal-soy"));

  var _ConnectedComponent = _interopRequireDefault(require("../../store/ConnectedComponent.es"));

  require("./segmentsExperiences/modal.es");

  var _SegmentsExperienceSelector = _interopRequireDefault(require("./SegmentsExperienceSelector.soy"));

  var _actions = require("../../actions/actions.es");

  require("frontend-js-web/liferay/compat/modal/Modal.es");

  var _FragmentsEditorUpdateUtils = require("../../utils/FragmentsEditorUpdateUtils.es");

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj.default = obj;return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var DISMISS_ALERT_ANIMATION_WAIT = 500;
  /**
   * Tells if a priority an `obj2`
   * has higher, equal or lower priority
   * than `obj1`.
   * Return values can be 1, 0, or -1
   * @param {object} obj1
   * @param {object} obj2
   * @returns {number}
   * @review
   */

  function comparePriority(obj1, obj2) {
    var result = 0;

    if (obj1.priority > obj2.priority) {
      result = -1;
    }

    if (obj1.priority < obj2.priority) {
      result = 1;
    }

    return result;
  }
  /**
   * Searchs for a segment based on its Id
   * and returns its label
   * @param {Array} segments
   * @param {string} segmentsEntryId
   * @returns {string|undefined}
   * @review
   */

  function findSegmentsEntryNameById(segments, segmentsEntryId) {
    var mostWantedSegment = segments.find(function (segment) {
      return segment.segmentsEntryId === segmentsEntryId;
    });
    return mostWantedSegment && mostWantedSegment.name;
  }
  /**
   * SegmentsExperienceSelector
   */

  var SegmentsExperienceSelector =
  /*#__PURE__*/
  function (_Component) {
    _inherits(SegmentsExperienceSelector, _Component);

    function SegmentsExperienceSelector() {
      _classCallCheck(this, SegmentsExperienceSelector);

      return _possibleConstructorReturn(this, _getPrototypeOf(SegmentsExperienceSelector).apply(this, arguments));
    }

    _createClass(SegmentsExperienceSelector, [{
      key: "prepareStateForRender",

      /**
       * Transforms `availableSegmentsEntries` and `availableSegmentsExperiences` objects into arrays
       * Adds `activeSegmentsExperienceName` to the component state
       * @inheritDoc
       * @review
       */
      value: function prepareStateForRender(state) {
        var availableSegmentsExperiencesArray = Object.values(state.availableSegmentsExperiences || []).sort(comparePriority).map(function (experience) {
          var name = findSegmentsEntryNameById(Object.values(state.availableSegmentsEntries), experience.segmentsEntryId);
          var updatedExperience = (0, _FragmentsEditorUpdateUtils.setIn)(experience, ['segmentsEntryName'], name);
          return updatedExperience;
        });
        var selectedSegmentsExperienceId = state.segmentsExperienceId || state.defaultSegmentsExperienceId;
        var activeExperience = availableSegmentsExperiencesArray.find(function (experience) {
          return experience.segmentsExperienceId === selectedSegmentsExperienceId;
        });
        var availableSegmentsEntries = Object.values(state.availableSegmentsEntries || []).filter(function (segment) {
          return segment.segmentsEntryId !== state.defaultSegmentsEntryId;
        });
        var innerState = Object.assign({}, state, {
          activeSegmentsExperienceName: activeExperience && activeExperience.name,
          availableSegmentsEntries: availableSegmentsEntries,
          availableSegmentsExperiences: availableSegmentsExperiencesArray,
          segmentsExperienceId: selectedSegmentsExperienceId
        });
        return innerState;
      }
      /**
       * @memberof SegmentsExperienceSelector
       * @private
       * @review
       */

    }, {
      key: "_closeDropdown",
      value: function _closeDropdown() {
        this._experiencesErrorHandler({
          creation: false
        });

        this.openDropdown = false;
      }
      /**
       * @memberof SegmentsExperienceSelector
       * @private
       * @review
       */

    }, {
      key: "_closeCreateModal",
      value: function _closeCreateModal() {
        this._experiencesModalStateHandler({
          creation: false
        });
      }
      /**
       * Dispatches action to create an experience
       * @memberof SegmentsExperienceSelector
       * @param {!string} name
       * @param {!string} segmentsEntryId
       * @private
       * @review
       */

    }, {
      key: "_createSegmentsExperience",
      value: function _createSegmentsExperience(name, segmentsEntryId) {
        var _this = this;

        this.store.dispatch({
          name: name,
          segmentsEntryId: segmentsEntryId,
          type: _actions.CREATE_SEGMENTS_EXPERIENCE
        }).done(function () {
          _this._closeCreateModal();

          Liferay.Util.openToast({
            title: Liferay.Language.get('the-experience-was-created-successfully'),
            type: 'success'
          });
        }).failed(function () {
          _this._experiencesErrorHandler({
            creation: true
          });
        });
      }
      /**
       * Dispatches action to delete an experience
       * @memberof SegmentsExperienceSelector
       * @param {!string} segmentsExperienceId
       * @private
       * @review
       */

    }, {
      key: "_deleteSegmentsExperience",
      value: function _deleteSegmentsExperience(segmentsExperienceId) {
        var _this2 = this;

        this.store.dispatch({
          segmentsExperienceId: segmentsExperienceId,
          type: _actions.DELETE_SEGMENTS_EXPERIENCE
        }).done(function () {
          Liferay.Util.openToast({
            title: Liferay.Language.get('the-experience-was-deleted-successfully'),
            type: 'success'
          });
        }).failed(function () {
          _this2._openDropdown();

          _this2._experiencesErrorHandler({
            deletion: true
          });
        });
      }
      /**
       * Clears the creation error with a `DISMISS_ALERT_ANIMATION_WAIT` miliseconds wait,
       * so the dismissable alert can complete its animation
       * @memberof SegmentsExperienceSelector
       * @private
       * @review
       */

    }, {
      key: "_dismissCreationError",
      value: function _dismissCreationError() {
        var _this3 = this;

        setTimeout(function () {
          _this3._experiencesErrorHandler({
            creation: false
          });
        }, DISMISS_ALERT_ANIMATION_WAIT);
      }
      /**
       * Clears the edition with a `DISMISS_ALERT_ANIMATION_WAIT` miliseconds wait,
       * so the dismissable alert can complete its animation
       * @memberof SegmentsExperienceSelector
       * @private
       * @review
       */

    }, {
      key: "_dismissEditionError",
      value: function _dismissEditionError() {
        var _this4 = this;

        setTimeout(function () {
          _this4._experiencesErrorHandler({
            edition: false
          });
        }, DISMISS_ALERT_ANIMATION_WAIT);
      }
      /**
       * Moves the focus to the create experience button
       * Clears the error with a 500 miliseconds wait,
       * so the dismissable alert can complete its animation
       * @memberof SegmentsExperienceSelector
       * @private
       * @review
       */

    }, {
      key: "_dismissDeletionError",
      value: function _dismissDeletionError() {
        var _this5 = this;

        this.refs.newExperienceBtn.focus();
        setTimeout(function () {
          _this5._experiencesErrorHandler({
            deletion: false
          });
        }, 500);
      }
      /**
       * Updates the error status for the experiences
       *
       * @param {object} objError
       * @param {boolean} [objError.deletion] - True if experience deletion error has ocurred
       * @param {boolean} [objError.creation] - True if experience creation error has ocurred
       * @param {boolean} [objError.edition] - True if experience edition error has ocurred
       * @memberof SegmentsExperienceSelector
       */

    }, {
      key: "_experiencesErrorHandler",
      value: function _experiencesErrorHandler() {
        var _this6 = this;

        var objError = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        requestAnimationFrame(function () {
          _this6._segmentsExperienceErrors = Object.assign(_this6._segmentsExperienceErrors || {}, objError);
        });
      }
      /**
       * @param {!string} segmentsExperienceId
       * @param {!string} name
       * @memberof SegmentsExperienceSelector
       */

    }, {
      key: "_editSegmentsExperience",
      value: function _editSegmentsExperience(_ref) {
        var _this7 = this;

        var segmentsExperienceId = _ref.segmentsExperienceId,
            name = _ref.name,
            segmentsEntryId = _ref.segmentsEntryId;
        this.store.dispatch({
          name: name,
          segmentsEntryId: segmentsEntryId,
          segmentsExperienceId: segmentsExperienceId,
          type: _actions.EDIT_SEGMENTS_EXPERIENCE
        }).done(function () {
          _this7._experiencesModalStateHandler({
            edition: false
          });

          Liferay.Util.openToast({
            title: Liferay.Language.get('the-experience-was-updated-successfully'),
            type: 'success'
          });
        }).failed(function () {
          _this7._experiencesErrorHandler({
            edition: true
          });
        });
      }
      /**
       * Callback that is executed on delete button click
       * @memberof SegmentsExperienceSelector
       * @param {!Event} event
       * @review
       * @private
       */

    }, {
      key: "_handleDeleteButtonClick",
      value: function _handleDeleteButtonClick(event) {
        this._experiencesErrorHandler({
          deletion: false
        });

        var confirmed = confirm(Liferay.Language.get('do-you-want-to-delete-this-experience'));

        if (confirmed) {
          var segmentsExperienceId = event.currentTarget.getAttribute('data-segmentsExperienceId');

          this._deleteSegmentsExperience(segmentsExperienceId);
        }
      }
      /**
       * Callback that is executed on dropdown blur
       * @memberof SegmentsExperienceSelector
       * @private
       * @review
       */

    }, {
      key: "_handleDropdownBlur",
      value: function _handleDropdownBlur() {
        var _this8 = this;

        cancelAnimationFrame(this.willToggleDropdownId);
        this.willToggleDropdownId = requestAnimationFrame(function () {
          _this8._closeDropdown();
        });
      }
      /**
       * Callback that is executed on dropdown button click
       * @memberof SegmentsExperienceSelector
       * @private
       * @review
       */

    }, {
      key: "_handleDropdownButtonClick",
      value: function _handleDropdownButtonClick() {
        this._toggleDropdown();
      }
      /**
       * Callback that is executed on dropdown focus
       * @memberof SegmentsExperienceSelector
       * @private
       * @review
       */

    }, {
      key: "_handleDropdownFocus",
      value: function _handleDropdownFocus() {
        cancelAnimationFrame(this.willToggleDropdownId);
      }
      /**
       * Callback executed on edit button click
       * @memberof SegmentsExperienceSelector
       * @param {Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleEditButtonClick",
      value: function _handleEditButtonClick(event) {
        var name = event.currentTarget.getAttribute('data-name');
        var segmentsEntryId = event.currentTarget.getAttribute('data-segmentsEntryId');
        var segmentsExperienceId = event.currentTarget.getAttribute('data-segmentsExperienceId');

        this._openEditModal({
          name: name,
          segmentsEntryId: segmentsEntryId,
          segmentsExperienceId: segmentsExperienceId
        });
      }
      /**
       * Callback that is executed on experience click
       * @memberof SegmentsExperienceSelector
       * @param {Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleSegmentsExperienceClick",
      value: function _handleSegmentsExperienceClick(event) {
        var segmentsExperienceId = event.delegateTarget.dataset.segmentsExperienceId;

        this._selectSegmentsExperience(segmentsExperienceId);
      }
      /**
       * @memberof SegmentsExperienceSelector
       * @review
       * @param {!string} name
       * @param {!string} segmentsEntryId
       */

    }, {
      key: "_handleEditFormSubmit",
      value: function _handleEditFormSubmit(name, segmentsEntryId) {
        this._editSegmentsExperience({
          name: name,
          segmentsEntryId: segmentsEntryId,
          segmentsExperienceId: this.modalStates.edition.segmentsExperienceId
        });
      }
      /**
       * Triggers update priority store action
       * @param {Event} event
       * @memberof SegmentsExperienceSelector
       * @review
       */

    }, {
      key: "_handleMoveExperienceUpButtonClick",
      value: function _handleMoveExperienceUpButtonClick(event) {
        var priority = event.currentTarget.getAttribute('data-priority');
        var segmentsExperienceId = event.currentTarget.getAttribute('data-segmentsExperienceId');
        var buttonPriorityUp = this.refs["buttonPriorityUp".concat(segmentsExperienceId)];
        var selectExperienceBtnRef = this.refs["selectExperienceButton".concat(segmentsExperienceId)];

        this._updatePriority({
          focusFallbackElement: selectExperienceBtnRef,
          payload: {
            direction: 'up',
            priority: priority,
            segmentsExperienceId: segmentsExperienceId
          },
          priorityButton: buttonPriorityUp.element
        });
      }
      /**
       * Triggers update priority store action
       * @param {Event} event
       * @memberof SegmentsExperienceSelector
       * @review
       */

    }, {
      key: "_handleMoveExperienceDownButtonClick",
      value: function _handleMoveExperienceDownButtonClick(event) {
        var priority = event.currentTarget.getAttribute('data-priority');
        var segmentsExperienceId = event.currentTarget.getAttribute('data-segmentsExperienceId');
        var buttonPriorityDown = this.refs["buttonPriorityDown".concat(segmentsExperienceId)];
        var selectExperienceBtnRef = this.refs["selectExperienceButton".concat(segmentsExperienceId)];

        this._updatePriority({
          focusFallbackElement: selectExperienceBtnRef,
          payload: {
            direction: 'down',
            priority: priority,
            segmentsExperienceId: segmentsExperienceId
          },
          priorityButton: buttonPriorityDown.element
        });
      }
      /**
       * Dispatchs priority update actions
       * and handles focus change when necessary
       *
       * @param {HTMLButtonElement} priorityButton
       * @param {HTMLElement} focusFallbackElement
       * @param {object} payload
       * @param {!('down'|'up')} payload.direction
       * @param {!number} payload.priority
       * @param {!string} payload.segmentsExperienceId
       * @memberof SegmentsExperienceSelector
       */

    }, {
      key: "_updatePriority",
      value: function _updatePriority(_ref2) {
        var focusFallbackElement = _ref2.focusFallbackElement,
            priorityButton = _ref2.priorityButton,
            payload = _ref2.payload;

        var onBlur = function onBlur() {
          focusFallbackElement.focus();
          priorityButton.removeEventListener('blur', onBlur);
        };

        priorityButton.addEventListener('blur', onBlur);

        var removeBlurListener = function removeBlurListener() {
          priorityButton.removeEventListener('blur', onBlur);
        };

        this.store.dispatch(Object.assign({}, payload, {
          type: _actions.UPDATE_SEGMENTS_EXPERIENCE_PRIORITY
        })).done(removeBlurListener).failed(removeBlurListener);
      }
      /**
       * Opens dropdown
       * @memberof SegmentsExperienceSelector
       * @private
       * @review
       */

    }, {
      key: "_openDropdown",
      value: function _openDropdown() {
        this.openDropdown = true;
      }
      /**
       * Opens experience creation modal
       * @memberof SegmentsExperienceSelector
       * @private
       * @review
       */

    }, {
      key: "_openCreateModal",
      value: function _openCreateModal() {
        this._experiencesModalStateHandler({
          creation: true
        });
      }
      /**
       * Opens edit experience modal
       * @memberof SegmentsExperienceSelector
       * @private
       * @review
       */

    }, {
      key: "_openEditModal",
      value: function _openEditModal(_ref3) {
        var _ref3$name = _ref3.name,
            name = _ref3$name === void 0 ? '' : _ref3$name,
            _ref3$segmentsEntryId = _ref3.segmentsEntryId,
            segmentsEntryId = _ref3$segmentsEntryId === void 0 ? null : _ref3$segmentsEntryId,
            _ref3$segmentsExperie = _ref3.segmentsExperienceId,
            segmentsExperienceId = _ref3$segmentsExperie === void 0 ? null : _ref3$segmentsExperie;

        this._experiencesModalStateHandler({
          edition: {
            name: name,
            segmentsEntryId: segmentsEntryId,
            segmentsExperienceId: segmentsExperienceId
          }
        });
      }
      /**
       * @param {object} [newState]
       * @param {boolean} [newState.creation] - The status of the experience creation modal
       * @param {boolean} [newState.editon] - The status of the experience edition modal
       * @memberof SegmentsExperienceSelector
       */

    }, {
      key: "_experiencesModalStateHandler",
      value: function _experiencesModalStateHandler() {
        var newState = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        this.modalStates = newState;
      }
      /**
       * Dispatches action to select an experience
       * @memberof SegmentsExperienceSelector
       * @param {!string} segmentsExperienceId
       * @private
       * @review
       */

    }, {
      key: "_selectSegmentsExperience",
      value: function _selectSegmentsExperience(segmentsExperienceId) {
        this.store.dispatch({
          segmentsExperienceId: segmentsExperienceId,
          type: _actions.SELECT_SEGMENTS_EXPERIENCE
        });
      }
      /**
       * @memberof SegmentsExperienceSelector
       * @private
       * @review
       */

    }, {
      key: "_closeEditModal",
      value: function _closeEditModal() {
        this._experiencesErrorHandler({
          edition: false
        });

        this._experiencesModalStateHandler({
          edition: false
        });
      }
      /**
       * Toggles the modal
       * @memberof SegmentsExperienceSelector
       * @private
       * @review
       */

    }, {
      key: "_toggleEditModal",
      value: function _toggleEditModal() {
        var modalEditAction = this.modalStates.edition ? this._closeEditModal : this._openEditModal;
        modalEditAction.call(this);
      }
      /**
       * Toggles the modal
       * @memberof SegmentsExperienceSelector
       * @private
       * @review
       */

    }, {
      key: "_toggleCreateModal",
      value: function _toggleCreateModal() {
        var modalAction = this.modalStates.creation ? this._closeCreateModal : this._openCreateModal;
        modalAction.call(this);
      }
      /**
       * Toggles the dropdown
       * @memberof SegmentsExperienceSelector
       * @private
       * @review
       */

    }, {
      key: "_toggleDropdown",
      value: function _toggleDropdown() {
        var dropdownAction = this.openDropdown ? this._closeDropdown : this._openDropdown;
        dropdownAction.call(this);
      }
    }]);

    return SegmentsExperienceSelector;
  }(_metalComponent.default);

  SegmentsExperienceSelector.STATE = {
    modalStates: _metalSoy.Config.object().value(null),
    openDropdown: _metalSoy.Config.bool().internal().value(false),
    segmentsEntryId: _metalSoy.Config.string().internal()
  };
  var ConnectedSegmentsExperienceSelector = (0, _ConnectedComponent.default)(SegmentsExperienceSelector, ['classPK', 'availableSegmentsExperiences', 'segmentsExperienceId', 'defaultSegmentsEntryId']);
  exports.ConnectedSegmentsExperienceSelector = ConnectedSegmentsExperienceSelector;

  _metalSoy.default.register(ConnectedSegmentsExperienceSelector, _SegmentsExperienceSelector.default);

  var _default = ConnectedSegmentsExperienceSelector;
  exports.default = _default;
  //# sourceMappingURL=SegmentsExperienceSelector.es.js.map
});
//# sourceMappingURL=SegmentsExperienceSelector.es.js.map