"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/components/sidebar/page_structure/SidebarPageStructurePanel.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal-soy', '../fragments/FragmentsEditorSidebarCard.es', '../../../actions/actions.es', '../../../utils/FragmentsEditorUpdateUtils.es', '../../../utils/constants', '../../../store/ConnectedComponent.es', '../../../utils/FragmentsEditorGetUtils.es', './SidebarPageStructurePanel.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.SidebarPageStructurePanel = exports.ConnectedSidebarPageStructurePanel = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  require("../fragments/FragmentsEditorSidebarCard.es");

  var _actions = require("../../../actions/actions.es");

  var _FragmentsEditorUpdateUtils = require("../../../utils/FragmentsEditorUpdateUtils.es");

  var _constants = require("../../../utils/constants");

  var _ConnectedComponent = require("../../../store/ConnectedComponent.es");

  var _FragmentsEditorGetUtils = require("../../../utils/FragmentsEditorGetUtils.es");

  var _SidebarPageStructurePanel = _interopRequireDefault(require("./SidebarPageStructurePanel.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * SidebarPageStructurePanel
   */
  var SidebarPageStructurePanel =
  /*#__PURE__*/
  function (_Component) {
    _inherits(SidebarPageStructurePanel, _Component);

    function SidebarPageStructurePanel() {
      _classCallCheck(this, SidebarPageStructurePanel);

      return _possibleConstructorReturn(this, _getPrototypeOf(SidebarPageStructurePanel).apply(this, arguments));
    }

    _createClass(SidebarPageStructurePanel, [{
      key: "prepareStateForRender",

      /**
       * @inheritDoc
       * @private
       * @review
       */
      value: function prepareStateForRender(state) {
        return SidebarPageStructurePanel._addStructureToState(state);
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "syncActiveItemId",
      value: function syncActiveItemId() {
        var _this = this;

        if (this.activeItemId && this.activeItemType) {
          (0, _FragmentsEditorGetUtils.getItemPath)(this.activeItemId, this.activeItemType, this.layoutData.structure).filter(function (activeItem) {
            return _this.activeItemId !== activeItem.itemId && _this.activeItemType !== activeItem.itemType;
          }).forEach(function (activeItem) {
            var key = "".concat(activeItem.itemType, "-").concat(activeItem.itemId);

            if (_this._expandedNodes.indexOf(key) === -1) {
              _this._expandedNodes = [].concat(_toConsumableArray(_this._expandedNodes), [key]);
            }
          });
        }
      }
      /**
       * @param {MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleElementClick",
      value: function _handleElementClick(event) {
        var nodeKey = event.delegateTarget.dataset.nodeKey;

        if (nodeKey) {
          var nodeKeyIndex = this._expandedNodes.indexOf(nodeKey);

          if (nodeKeyIndex === -1) {
            this._expandedNodes.push(nodeKey);
          } else {
            this._expandedNodes.splice(nodeKeyIndex, 1);
          }

          this._expandedNodes = this._expandedNodes;
        }
      }
      /**
       * Callback executed when the element remove button is clicked.
       * @param {object} event
       * @private
       * @review
       */

    }, {
      key: "_handleElementRemoveButtonClick",
      value: function _handleElementRemoveButtonClick(event) {
        var itemId = event.delegateTarget.dataset.elementId;
        var itemType = event.delegateTarget.dataset.elementType;
        var removeItemAction = null;
        var removeItemPayload = null;

        if (itemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.row) {
          removeItemAction = _actions.REMOVE_ROW;
          removeItemPayload = {
            rowId: itemId
          };
        } else if (itemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment) {
          removeItemAction = _actions.REMOVE_FRAGMENT_ENTRY_LINK;
          removeItemPayload = {
            fragmentEntryLinkId: itemId
          };
        }

        (0, _FragmentsEditorUpdateUtils.removeItem)(this.store, removeItemAction, removeItemPayload);
      }
    }], [{
      key: "_addStructureToState",

      /**
       * @param {Object} state
       * @private
       * @return {Object}
       * @review
       * @static
       */
      value: function _addStructureToState(state) {
        return (0, _FragmentsEditorUpdateUtils.setIn)(state, ['structure'], SidebarPageStructurePanel._getTreeNode(state, {
          children: state.layoutData.structure.map(function (row) {
            return SidebarPageStructurePanel._getRowTree(state, row);
          }),
          expanded: true,
          key: 'root',
          label: Liferay.Language.get('page')
        }));
      }
      /**
       * @param {object} state
       * @param {object} column
       * @return {Object}
       * @review
       * @static
       */

    }, {
      key: "_getColumnTree",
      value: function _getColumnTree(state, column) {
        return SidebarPageStructurePanel._getTreeNode(state, {
          children: column.fragmentEntryLinkIds.map(function (fragmentEntryLinkId) {
            return state.fragmentEntryLinks[fragmentEntryLinkId];
          }).filter(function (fragmentEntryLink) {
            return fragmentEntryLink;
          }).map(function (fragmentEntryLink) {
            return SidebarPageStructurePanel._getFragmentEntryLinkTree(state, fragmentEntryLink);
          }),
          key: "".concat(_constants.FRAGMENTS_EDITOR_ITEM_TYPES.column, "-").concat(column.columnId),
          label: Liferay.Language.get('column')
        });
      }
      /**
       * @param {object} state
       * @param {object} fragmentEntryLink
       * @return {Object}
       * @review
       * @static
       */

    }, {
      key: "_getFragmentEntryLinkTree",
      value: function _getFragmentEntryLinkTree(state, fragmentEntryLink) {
        return SidebarPageStructurePanel._getTreeNode(state, {
          children: Object.keys(fragmentEntryLink.editableValues[_constants.EDITABLE_FRAGMENT_ENTRY_PROCESSOR]).map(function (editableValueKey) {
            return SidebarPageStructurePanel._getTreeNode(state, {
              elementId: "".concat(fragmentEntryLink.fragmentEntryLinkId, "-").concat(editableValueKey),
              elementType: _constants.FRAGMENTS_EDITOR_ITEM_TYPES.editable,
              key: "".concat(_constants.FRAGMENTS_EDITOR_ITEM_TYPES.editable, "-").concat(fragmentEntryLink.fragmentEntryLinkId, "-").concat(editableValueKey),
              label: editableValueKey
            });
          }),
          elementId: fragmentEntryLink.fragmentEntryLinkId,
          elementType: _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment,
          key: "".concat(_constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment, "-").concat(fragmentEntryLink.fragmentEntryLinkId),
          label: fragmentEntryLink.name,
          removable: true
        });
      }
      /**
       * @param {object} state
       * @param {object} row
       * @return {Object}
       * @review
       * @static
       */

    }, {
      key: "_getRowTree",
      value: function _getRowTree(state, row) {
        var treeNode;

        if (row.type === _constants.FRAGMENTS_EDITOR_ROW_TYPES.sectionRow) {
          var _getRowFragmentEntryL = (0, _FragmentsEditorGetUtils.getRowFragmentEntryLinkIds)(row),
              _getRowFragmentEntryL2 = _slicedToArray(_getRowFragmentEntryL, 1),
              fragmentEntryLinkId = _getRowFragmentEntryL2[0];

          var fragmentEntryLink = state.fragmentEntryLinks[fragmentEntryLinkId];

          if (fragmentEntryLink) {
            treeNode = SidebarPageStructurePanel._getFragmentEntryLinkTree(state, fragmentEntryLink);
          }
        }

        if (!treeNode) {
          treeNode = SidebarPageStructurePanel._getTreeNode(state, {
            children: row.columns.map(function (column) {
              return SidebarPageStructurePanel._getColumnTree(state, column);
            }),
            elementId: row.rowId,
            elementType: _constants.FRAGMENTS_EDITOR_ITEM_TYPES.row,
            key: "".concat(_constants.FRAGMENTS_EDITOR_ITEM_TYPES.row, "-").concat(row.rowId),
            label: Liferay.Language.get('section'),
            removable: true
          });
        }

        return treeNode;
      }
      /**
       * @param {object} state
       * @param {object} data
       * @param {string} data.key
       * @param {string} data.label
       * @param {object[]} [data.children=[]]
       * @param {string} [data.elementId='']
       * @param {string} [data.elementType='']
       * @param {boolean} [data.expanded=false]
       * @param {boolean} [data.removable=false]
       * @private
       * @return {object}
       * @review
       * @static
       */

    }, {
      key: "_getTreeNode",
      value: function _getTreeNode(state, data) {
        return {
          active: state.activeItemId === data.elementId && state.activeItemType === data.elementType,
          children: data.children || [],
          elementId: data.elementId || '',
          elementType: data.elementType || '',
          expanded: data.expanded || state._expandedNodes.indexOf(data.key) !== -1,
          hovered: state.hoveredItemId === data.elementId && state.hoveredItemType === data.elementType,
          key: data.key,
          label: data.label,
          removable: data.removable || false
        };
      }
    }]);

    return SidebarPageStructurePanel;
  }(_metalComponent.default);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.SidebarPageStructurePanel = SidebarPageStructurePanel;
  SidebarPageStructurePanel.STATE = {
    /**
     * List of expanded nodes.
     * @default ['root']
     * @instance
     * @memberOf SidebarPageStructurePanel
     * @review
     * @type {string[]}
     */
    _expandedNodes: _metalState.Config.arrayOf(_metalState.Config.string()).internal().value(['root'])
  };
  var ConnectedSidebarPageStructurePanel = (0, _ConnectedComponent.getConnectedComponent)(SidebarPageStructurePanel, ['activeItemId', 'activeItemType', 'fragmentEntryLinks', 'hoveredItemId', 'hoveredItemType', 'layoutData', 'spritemap']);
  exports.ConnectedSidebarPageStructurePanel = ConnectedSidebarPageStructurePanel;

  _metalSoy.default.register(ConnectedSidebarPageStructurePanel, _SidebarPageStructurePanel.default);

  var _default = ConnectedSidebarPageStructurePanel;
  exports.default = _default;
  //# sourceMappingURL=SidebarPageStructurePanel.es.js.map
});
//# sourceMappingURL=SidebarPageStructurePanel.es.js.map