"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/components/mapping_type/SelectMappingDialog.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state', 'frontend-js-web/liferay/PortletBase.es', 'frontend-js-metal-web$metal-soy', 'frontend-js-web/liferay/compat/modal/Modal.es', '../../utils/constants', '../../actions/actions.es', '../../utils/FragmentsEditorUpdateUtils.es', '../../store/store.es', '../../actions/updateEditableValue.es', './SelectMappingDialog.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.SelectMappingDialog = void 0;

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _PortletBase2 = _interopRequireDefault(require("frontend-js-web/liferay/PortletBase.es"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  require("frontend-js-web/liferay/compat/modal/Modal.es");

  var _constants = require("../../utils/constants");

  var _actions = require("../../actions/actions.es");

  var _FragmentsEditorUpdateUtils = require("../../utils/FragmentsEditorUpdateUtils.es");

  var _store = require("../../store/store.es");

  var _updateEditableValue = require("../../actions/updateEditableValue.es");

  var _SelectMappingDialog = _interopRequireDefault(require("./SelectMappingDialog.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * SelectMappingDialog
   */
  var SelectMappingDialog =
  /*#__PURE__*/
  function (_PortletBase) {
    _inherits(SelectMappingDialog, _PortletBase);

    function SelectMappingDialog() {
      _classCallCheck(this, SelectMappingDialog);

      return _possibleConstructorReturn(this, _getPrototypeOf(SelectMappingDialog).apply(this, arguments));
    }

    _createClass(SelectMappingDialog, [{
      key: "prepareStateForRender",

      /**
       * @inheritDoc
       * @review
       */
      value: function prepareStateForRender(state) {
        var _mappeableFields = state._mappeableFields,
            editableType = state.editableType;
        var mappeableFields = _mappeableFields ? _mappeableFields.map(function (mappeableField) {
          return {
            enabled: _constants.COMPATIBLE_TYPES[editableType] && _constants.COMPATIBLE_TYPES[editableType].indexOf(mappeableField.type) !== -1,
            key: mappeableField.key,
            label: mappeableField.label
          };
        }) : null;
        return (0, _FragmentsEditorUpdateUtils.setIn)(state, ['_mappeableFields'], mappeableFields);
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "rendered",
      value: function rendered() {
        if (this.visible && !this._loadingMappeableFields && !this._mappeableFields) {
          this._loadMappeableFields();
        }
      }
      /**
       * Map an editable
       * @param {string} [key='']
       * @private
       * @review
       */

    }, {
      key: "_handleMappeableFieldSelected",
      value: function _handleMappeableFieldSelected() {
        var key = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
        this.store.dispatch((0, _updateEditableValue.updateEditableValueAction)(this.fragmentEntryLinkId, this.editableId, 'mappedField', key)).dispatch({
          type: _actions.HIDE_MAPPING_DIALOG
        });
      }
      /**
       * Changes visible property to false
       * @private
       * @review
       */

    }, {
      key: "_handleCancelButtonClick",
      value: function _handleCancelButtonClick() {
        this.store.dispatch({
          type: _actions.HIDE_MAPPING_DIALOG
        });
      }
      /**
       * Unmaps the existing editable field
       * @private
       * @review
       */

    }, {
      key: "_handleUnmapButtonClick",
      value: function _handleUnmapButtonClick() {
        this._handleMappeableFieldSelected('');
      }
      /**
       * Handle a mappeable field click and propagate it's selection
       * @param {Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleMappeableFieldLinkClick",
      value: function _handleMappeableFieldLinkClick(event) {
        this._handleMappeableFieldSelected(event.delegateTarget.dataset.key);
      }
      /**
       * Load the list of mappeable fields from the server
       * @private
       * @review
       * @return {Promise}
       */

    }, {
      key: "_loadMappeableFields",
      value: function _loadMappeableFields() {
        var _this = this;

        var classNameId = this.selectedMappingTypes.type ? this.selectedMappingTypes.type.id : '';
        var classTypeId = this.selectedMappingTypes.subtype ? this.selectedMappingTypes.subtype.id : '';
        this._loadingMappeableFields = true;
        this._mappeableFields = null;
        return this.fetch(this.mappingFieldsURL, {
          classNameId: classNameId,
          classTypeId: classTypeId
        }).then(function (response) {
          return response.json();
        }).then(function (responseContent) {
          _this._loadingMappeableFields = false;
          _this._mappeableFields = responseContent;
        });
      }
    }]);

    return SelectMappingDialog;
  }(_PortletBase2.default);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.SelectMappingDialog = SelectMappingDialog;
  SelectMappingDialog.STATE = {
    /**
     * EditableId of the field that is being mapped
     * @default ''
     * @instance
     * @memberOf SelectMappingDialog
     * @review
     * @type {string}
     */
    editableId: _metalState.Config.string().value(''),

    /**
     * Editable type that is being mapped.
     * This should match the corresponding mappeableField type in order
     * to be available.
     * @default ''
     * @instance
     * @memberOf SelectMappingDialog
     * @review
     * @type {string}
     */
    editableType: _metalState.Config.string().value(''),

    /**
     * FragmentEntryLinkId of the field that is being mapped
     * @default ''
     * @instance
     * @memberOf SelectMappingDialog
     * @review
     * @type {string}
     */
    fragmentEntryLinkId: _metalState.Config.string().value(''),

    /**
     * Mapped field ID of the field that is being mapped
     * @default ''
     * @instance
     * @memberOf SelectMappingDialog
     * @private
     * @review
     * @type {string}
     */
    mappedFieldId: _metalState.Config.string().value(''),

    /**
     * URL for getting the list of mapping fields
     * @default undefined
     * @instance
     * @memberOf SelectMappingDialog
     * @review
     * @type {!string}
     */
    mappingFieldsURL: _metalState.Config.string().required(),

    /**
     * Selected mapping types
     * @default {}
     * @instance
     * @memberOf SelectMappingDialog
     * @review
     * @type {{
     *   subtype: {
     *   	id: !string,
     *   	label: !string
     *   },
     *   type: {
     *   	id: !string,
     *   	label: !string
     *   }
     * }}
     */
    selectedMappingTypes: _metalState.Config.shapeOf({
      subtype: _metalState.Config.shapeOf({
        id: _metalState.Config.string().required(),
        label: _metalState.Config.string().required()
      }),
      type: _metalState.Config.shapeOf({
        id: _metalState.Config.string().required(),
        label: _metalState.Config.string().required()
      })
    }).value({}),

    /**
     * Path of the available icons.
     * @default undefined
     * @instance
     * @memberOf SelectMappingDialog
     * @review
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required(),

    /**
     * Store instance
     * @default undefined
     * @instance
     * @memberOf SelectMappingDialog
     * @review
     * @type {Store}
     */
    store: _metalState.Config.instanceOf(_store.Store),

    /**
     * Flag indicating if mappeable fields are being loaded
     * @default false
     * @instance
     * @memberOf SelectMappingDialog
     * @private
     * @review
     * @type {boolean}
     */
    _loadingMappeableFields: _metalState.Config.bool().value(false),

    /**
     * List of mappeable fields being shown as options
     * @default null
     * @instance
     * @memberOf SelectMappingDialog
     * @review
     * @private
     * @type {null|Array<{
     *   key: !string,
     *   label: !string
     * }>}
     */
    _mappeableFields: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      key: _metalState.Config.string().required(),
      label: _metalState.Config.string().required(),
      type: _metalState.Config.string().required()
    })).value(null)
  };

  _metalSoy.default.register(SelectMappingDialog, _SelectMappingDialog.default);

  var _default = SelectMappingDialog;
  exports.default = _default;
  //# sourceMappingURL=SelectMappingDialog.es.js.map
});
//# sourceMappingURL=SelectMappingDialog.es.js.map