"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/components/fragment_processors/EditableLinkFragmentProcessor.es", ['module', 'exports', 'require', '../../utils/constants', './EditableTextFragmentProcessor.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = void 0;

  var _constants = require("../../utils/constants");

  var _EditableTextFragmentProcessor = require("./EditableTextFragmentProcessor.es");

  /**
   * @param {object} editableValues
   * @return {object[]} Floating toolbar panels
   */
  function getFloatingToolbarButtons(editableValues) {
    return [_constants.FLOATING_TOOLBAR_BUTTONS.edit, _constants.FLOATING_TOOLBAR_BUTTONS.link];
  }
  /**
   * @param {string} content editableField's original HTML
   * @param {string} value Translated/segmented value
   * @param {object} editableValues values of the element
   * @return {string} Transformed content
   */

  function render(content, value, editableValues) {
    var wrapper = document.createElement('div');
    wrapper.innerHTML = content;
    var config = editableValues && editableValues.config || {};
    var link = wrapper.querySelector('a');

    if (link) {
      link.innerHTML = value;

      if (config.href) {
        link.href = config.href;
      }

      if (config.target) {
        link.target = config.target;
      }

      Array.from(link.classList).forEach(function (elementClass) {
        if (elementClass.indexOf('btn-') === 0 || elementClass === 'btn') {
          link.classList.remove(elementClass);
        }
      });

      if (config.buttonType && config.buttonType === 'link') {
        link.classList.add('link');
      } else {
        link.classList.add('btn');
        link.classList.add("btn-".concat(config.buttonType));
      }
    }

    return wrapper.innerHTML;
  }

  var _default = {
    destroy: _EditableTextFragmentProcessor.destroy,
    getFloatingToolbarButtons: getFloatingToolbarButtons,
    init: _EditableTextFragmentProcessor.init,
    render: render
  };
  exports.default = _default;
  //# sourceMappingURL=EditableLinkFragmentProcessor.es.js.map
});
//# sourceMappingURL=EditableLinkFragmentProcessor.es.js.map