"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/components/fragment_processors/EditableImageFragmentProcessor.es", ['module', 'exports', 'require', '../../utils/constants', '../../utils/FragmentsEditorDialogUtils'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = void 0;

  var _constants = require("../../utils/constants");

  var _FragmentsEditorDialogUtils = require("../../utils/FragmentsEditorDialogUtils");

  /**
   * Handle item selector image changes and propagate them with an
   * "editableChanged" event.
   * @param {string} url
   * @param {HTMLElement} editableElement
   * @param {string} fragmentEntryLinkId
   * @param {function} changedCallback
   * @private
   */
  function _handleImageEditorChange(url, editableElement, fragmentEntryLinkId, changedCallback) {
    var imageElement = editableElement.querySelector('img');

    if (imageElement && url) {
      imageElement.src = url;
      changedCallback(url);
    }
  }
  /**
   * Do nothing, as LiferayItemSelectorDialog is automatically
   * destroyed on hide.
   * @review
   */

  function destroy() {}
  /**
   * @param {object} editableValues
   * @return {object[]} Floating toolbar panels
   */

  function getFloatingToolbarButtons(editableValues) {
    return editableValues.mappedField ? [_constants.FLOATING_TOOLBAR_BUTTONS.imageLink, _constants.FLOATING_TOOLBAR_BUTTONS.map] : [_constants.FLOATING_TOOLBAR_BUTTONS.imageProperties, _constants.FLOATING_TOOLBAR_BUTTONS.map];
  }
  /**
   * Show the image selector dialog and calls the given callback when an
   * image is selected.
   * @param {HTMLElement} editableElement
   * @param {string} fragmentEntryLinkId
   * @param {string} portletNamespace
   * @param {{imageSelectorURL: string}} options
   * @param {function} changedCallback
   * @param {function} destroyedCallback
   * @review
   */

  function init(editableElement, fragmentEntryLinkId, portletNamespace, options, changedCallback, destroyedCallback) {
    var imageSelectorURL = options.imageSelectorURL;
    (0, _FragmentsEditorDialogUtils.openImageSelector)({
      callback: function callback(url) {
        _handleImageEditorChange(url, editableElement, fragmentEntryLinkId, changedCallback);
      },
      destroyedCallback: destroyedCallback,
      imageSelectorURL: imageSelectorURL,
      portletNamespace: portletNamespace
    });
  }
  /**
   * @param {string} content editableField's original HTML
   * @param {string} value Translated/segmented value
   * @return {string} Transformed content
   */

  function render(content, value) {
    var wrapper = document.createElement('div');
    wrapper.innerHTML = content;
    var image = wrapper.querySelector('img');

    if (image) {
      image.src = value;
    }

    return wrapper.innerHTML;
  }

  var _default = {
    destroy: destroy,
    getFloatingToolbarButtons: getFloatingToolbarButtons,
    init: init,
    render: render
  };
  exports.default = _default;
  //# sourceMappingURL=EditableImageFragmentProcessor.es.js.map
});
//# sourceMappingURL=EditableImageFragmentProcessor.es.js.map