"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/components/fragment_processors/EditableBackgroundImageProcessor.es", ['module', 'exports', 'require', '../../utils/FragmentsEditorDialogUtils'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = void 0;

  var _FragmentsEditorDialogUtils = require("../../utils/FragmentsEditorDialogUtils");

  /**
   * Do nothing, as LiferayItemSelectorDialog is automatically
   * destroyed on hide.
   * @review
   */
  function destroy() {}
  /**
   * Show the image selector dialog and calls the given callback when an
   * image is selected.
   * @param {function} callback
   * @param {string} imageSelectorURL
   * @param {string} portletNamespace
   * @review
   */

  function init(callback, imageSelectorURL, portletNamespace) {
    (0, _FragmentsEditorDialogUtils.openImageSelector)({
      callback: callback,
      imageSelectorURL: imageSelectorURL,
      portletNamespace: portletNamespace
    });
  }
  /**
   * @param {HTMLElement} element
   * @param {string} [backgroundImageURL='']
   */

  function render(element) {
    var backgroundImageURL = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
    element.style.backgroundImage = backgroundImageURL ? "url(\"".concat(backgroundImageURL, "\")") : '';
    element.style.backgroundSize = 'cover';
  }

  var _default = {
    destroy: destroy,
    init: init,
    render: render
  };
  exports.default = _default;
  //# sourceMappingURL=EditableBackgroundImageProcessor.es.js.map
});
//# sourceMappingURL=EditableBackgroundImageProcessor.es.js.map