"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/components/fragment_entry_link/FragmentEntryLinkList.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-position', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal-drag-drop', '../floating_toolbar/FloatingToolbar.es', './FragmentEntryLink.es', './FragmentEntryLinkListRow.es', '../../actions/actions.es', '../../utils/constants', '../../utils/FragmentsEditorDragDrop.es', '../../utils/FragmentsEditorUpdateUtils.es', '../../utils/FragmentsEditorComponentUtils.es', '../../store/ConnectedComponent.es', './FragmentEntryLinkList.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.FragmentEntryLinkList = exports.ConnectedFragmentEntryLinkList = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalPosition = _interopRequireDefault(require("frontend-js-metal-web$metal-position"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _metalDragDrop = require("frontend-js-metal-web$metal-drag-drop");

  require("../floating_toolbar/FloatingToolbar.es");

  require("./FragmentEntryLink.es");

  require("./FragmentEntryLinkListRow.es");

  var _actions = require("../../actions/actions.es");

  var _constants = require("../../utils/constants");

  var _FragmentsEditorDragDrop = require("../../utils/FragmentsEditorDragDrop.es");

  var _FragmentsEditorUpdateUtils = require("../../utils/FragmentsEditorUpdateUtils.es");

  var _FragmentsEditorComponentUtils = require("../../utils/FragmentsEditorComponentUtils.es");

  var _ConnectedComponent = _interopRequireDefault(require("../../store/ConnectedComponent.es"));

  var _FragmentEntryLinkList = _interopRequireDefault(require("./FragmentEntryLinkList.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * FragmentEntryLinkList
   * @review
   */
  var FragmentEntryLinkList =
  /*#__PURE__*/
  function (_Component) {
    _inherits(FragmentEntryLinkList, _Component);

    function FragmentEntryLinkList() {
      _classCallCheck(this, FragmentEntryLinkList);

      return _possibleConstructorReturn(this, _getPrototypeOf(FragmentEntryLinkList).apply(this, arguments));
    }

    _createClass(FragmentEntryLinkList, [{
      key: "attached",

      /**
       * @inheritdoc
       * @private
       * @review
       */
      value: function attached() {
        this._initializeDragAndDrop();
      }
      /**
       * @inheritdoc
       * @private
       * @review
       */

    }, {
      key: "disposed",
      value: function disposed() {
        this._dragDrop.dispose();
      }
      /**
       * @inheritdoc
       * @private
       * @return {Object}
       * @review
       */

    }, {
      key: "prepareStateForRender",
      value: function prepareStateForRender(nextState) {
        var _state = FragmentEntryLinkList._addDropTargetItemTypesToState(nextState);

        _state = FragmentEntryLinkList._setEmptyRows(_state);
        return _state;
      }
      /**
       * @inheritdoc
       * @private
       * @review
       */

    }, {
      key: "rendered",
      value: function rendered() {
        if (this.activeItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragmentList && this.element) {
          this.element.focus();
        }
      }
      /**
       * @inheritdoc
       * @return {boolean}
       * @review
       */

    }, {
      key: "shouldUpdate",
      value: function shouldUpdate(changes) {
        return (0, _FragmentsEditorComponentUtils.shouldUpdatePureComponent)(changes);
      }
      /**
       * Handle layoutData changed
       * @inheritDoc
       * @review
       */

    }, {
      key: "syncLayoutData",
      value: function syncLayoutData() {
        this._initializeDragAndDrop();
      }
      /**
       * Callback that is executed when an item is being dragged.
       * @param {Object} eventData
       * @param {MouseEvent} eventData.originalEvent
       * @private
       * @review
       */

    }, {
      key: "_handleDrag",
      value: function _handleDrag(eventData) {
        (0, _FragmentsEditorUpdateUtils.setDraggingItemPosition)(eventData.originalEvent);

        if (FragmentEntryLinkList._dropValid(eventData)) {
          var mouseY = eventData.originalEvent.clientY;
          var targetItem = eventData.target;

          var targetItemRegion = _metalPosition.default.getRegion(targetItem);

          var dropTargetItemData = FragmentEntryLinkList._getItemData(targetItem.dataset);

          var targetBorder = _constants.FRAGMENTS_EDITOR_ITEM_BORDERS.bottom;

          if (Math.abs(mouseY - targetItemRegion.top) <= Math.abs(mouseY - targetItemRegion.bottom)) {
            targetBorder = _constants.FRAGMENTS_EDITOR_ITEM_BORDERS.top;
          }

          this.store.dispatch({
            dropTargetBorder: targetBorder,
            dropTargetItemId: dropTargetItemData.itemId,
            dropTargetItemType: dropTargetItemData.itemType,
            type: _actions.UPDATE_DROP_TARGET
          });
        }
      }
      /**
       * Callback that is executed when we leave a drag target.
       * @private
       * @review
       */

    }, {
      key: "_handleDragEnd",
      value: function _handleDragEnd() {
        this.store.dispatch({
          type: _actions.CLEAR_DROP_TARGET
        });
      }
      /**
       * Callback that is executed when an item is dropped.
       * @param {Object} data
       * @param {MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleDrop",
      value: function _handleDrop(data, event) {
        var _this = this;

        event.preventDefault();

        if (FragmentEntryLinkList._dropValid(data)) {
          requestAnimationFrame(function () {
            _this._initializeDragAndDrop();
          });

          var itemData = FragmentEntryLinkList._getItemData(data.source.dataset);

          var moveItemAction = null;
          var moveItemPayload = null;

          if (itemData.itemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.row) {
            moveItemAction = _actions.MOVE_ROW;
            moveItemPayload = {
              rowId: itemData.itemId,
              targetBorder: this.dropTargetBorder,
              targetItemId: this.dropTargetItemId
            };
          } else if (itemData.itemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment) {
            moveItemAction = _actions.MOVE_FRAGMENT_ENTRY_LINK;
            moveItemPayload = {
              fragmentEntryLinkId: itemData.itemId,
              fragmentEntryLinkRowType: itemData.fragmentEntryLinkRowType,
              targetBorder: this.dropTargetBorder,
              targetItemId: this.dropTargetItemId,
              targetItemType: this.dropTargetItemType
            };
          }

          (0, _FragmentsEditorUpdateUtils.moveItem)(this.store, moveItemAction, moveItemPayload);
        }
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_initializeDragAndDrop",
      value: function _initializeDragAndDrop() {
        if (this._dragDrop) {
          this._dragDrop.dispose();
        }

        this._dragDrop = (0, _FragmentsEditorDragDrop.initializeDragDrop)({
          handles: '.fragments-editor__drag-handler',
          sources: '.fragments-editor__drag-source--fragment, .fragments-editor__drag-source--layout',
          targets: '.fragments-editor__drop-target--fragment, .fragments-editor__drop-target--layout'
        });

        this._dragDrop.on(_metalDragDrop.DragDrop.Events.DRAG, this._handleDrag.bind(this));

        this._dragDrop.on(_metalDragDrop.DragDrop.Events.END, this._handleDrop.bind(this));

        this._dragDrop.on(_metalDragDrop.DragDrop.Events.TARGET_LEAVE, this._handleDragEnd.bind(this));
      }
    }], [{
      key: "_addDropTargetItemTypesToState",

      /**
       * Adds drop target types to state
       * @param {Object} state
       * @private
       * @return {Object}
       * @static
       */
      value: function _addDropTargetItemTypesToState(state) {
        var nextState = state;
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['dropTargetItemTypes'], _constants.FRAGMENTS_EDITOR_ITEM_TYPES);
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['fragmentsEditorRowTypes'], _constants.FRAGMENTS_EDITOR_ROW_TYPES);
        return nextState;
      }
      /**
       * Returns whether a drop is valid or not
       * @param {Object} eventData
       * @private
       * @return {boolean}
       * @static
       */

    }, {
      key: "_dropValid",
      value: function _dropValid(eventData) {
        var sourceItemData = FragmentEntryLinkList._getItemData(eventData.source.dataset);

        var targetItemData = FragmentEntryLinkList._getItemData(eventData.target ? eventData.target.dataset : null);

        var dropValid = false;

        if (sourceItemData.itemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.row) {
          dropValid = targetItemData.itemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.row && sourceItemData.itemId !== targetItemData.itemId;
        } else if (sourceItemData.itemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment) {
          if (sourceItemData.fragmentEntryLinkRowType === _constants.FRAGMENTS_EDITOR_ROW_TYPES.sectionRow) {
            dropValid = targetItemData.itemType && sourceItemData.itemId !== targetItemData.itemId && targetItemData.itemType !== _constants.FRAGMENTS_EDITOR_ITEM_TYPES.column && targetItemData.itemType !== _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment;
          } else {
            dropValid = targetItemData.itemType && sourceItemData.itemId !== targetItemData.itemId;
          }
        }

        return dropValid;
      }
      /**
       * Get id and type of an item from its dataset
       * @param {!Object} itemDataset
       * @private
       * @return {Object}
       * @static
       */

    }, {
      key: "_getItemData",
      value: function _getItemData(itemDataset) {
        var itemData = {};

        if (itemDataset) {
          if ('columnId' in itemDataset) {
            itemData = {
              itemId: itemDataset.columnId,
              itemType: _constants.FRAGMENTS_EDITOR_ITEM_TYPES.column
            };
          } else if ('fragmentEntryLinkId' in itemDataset) {
            itemData = {
              fragmentEntryLinkRowType: itemDataset.fragmentEntryLinkRowType,
              itemId: itemDataset.fragmentEntryLinkId,
              itemType: _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment
            };
          } else if ('layoutRowId' in itemDataset) {
            itemData = {
              itemId: itemDataset.layoutRowId,
              itemType: _constants.FRAGMENTS_EDITOR_ITEM_TYPES.row
            };
          } else if ('fragmentEmptyList' in itemDataset) {
            itemData = {
              itemType: _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragmentList
            };
          }
        }

        return itemData;
      }
      /**
       * Checks wether a row is empty or not, sets empty parameter
       * and returns a new state
       * @param {Object} _state
       * @private
       * @return {Object}
       * @static
       */

    }, {
      key: "_setEmptyRows",
      value: function _setEmptyRows(_state) {
        return (0, _FragmentsEditorUpdateUtils.setIn)(_state, ['layoutData', 'structure'], _state.layoutData.structure.map(function (row) {
          return (0, _FragmentsEditorUpdateUtils.setIn)(row, ['empty'], row.columns.every(function (column) {
            return column.fragmentEntryLinkIds.length === 0;
          }));
        }));
      }
    }]);

    return FragmentEntryLinkList;
  }(_metalComponent.default);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.FragmentEntryLinkList = FragmentEntryLinkList;
  FragmentEntryLinkList.STATE = {
    /**
     * Internal DragDrop instance.
     * @default null
     * @instance
     * @memberOf FragmentEntryLinkList
     * @review
     * @type {object|null}
     */
    _dragDrop: _metalState.Config.internal().value(null)
  };
  var ConnectedFragmentEntryLinkList = (0, _ConnectedComponent.default)(FragmentEntryLinkList, ['activeItemId', 'activeItemType', 'dropTargetBorder', 'dropTargetItemId', 'dropTargetItemType', 'hoveredItemId', 'hoveredItemType', 'layoutData']);
  exports.ConnectedFragmentEntryLinkList = ConnectedFragmentEntryLinkList;

  _metalSoy.default.register(ConnectedFragmentEntryLinkList, _FragmentEntryLinkList.default);

  var _default = ConnectedFragmentEntryLinkList;
  exports.default = _default;
  //# sourceMappingURL=FragmentEntryLinkList.es.js.map
});
//# sourceMappingURL=FragmentEntryLinkList.es.js.map