"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/components/fragment_entry_link/FragmentEntryLink.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './FragmentEntryLinkContent.es', './FragmentEntryLink.soy', '../../actions/actions.es', '../../store/ConnectedComponent.es', '../../utils/FragmentsEditorGetUtils.es', '../../utils/constants', '../../utils/FragmentsEditorUpdateUtils.es', '../../utils/FragmentsEditorComponentUtils.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.FragmentEntryLink = exports.ConnectedFragmentEntryLink = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  require("./FragmentEntryLinkContent.es");

  var _FragmentEntryLink = _interopRequireDefault(require("./FragmentEntryLink.soy"));

  var _actions = require("../../actions/actions.es");

  var _ConnectedComponent = require("../../store/ConnectedComponent.es");

  var _FragmentsEditorGetUtils = require("../../utils/FragmentsEditorGetUtils.es");

  var _constants = require("../../utils/constants");

  var _FragmentsEditorUpdateUtils = require("../../utils/FragmentsEditorUpdateUtils.es");

  var _FragmentsEditorComponentUtils = require("../../utils/FragmentsEditorComponentUtils.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * FragmentEntryLink
   * @review
   */
  var FragmentEntryLink =
  /*#__PURE__*/
  function (_Component) {
    _inherits(FragmentEntryLink, _Component);

    function FragmentEntryLink() {
      _classCallCheck(this, FragmentEntryLink);

      return _possibleConstructorReturn(this, _getPrototypeOf(FragmentEntryLink).apply(this, arguments));
    }

    _createClass(FragmentEntryLink, [{
      key: "prepareStateForRender",

      /**
       * @inheritdoc
       * @param {object} state
       * @return {object}
       * @review
       */
      value: function prepareStateForRender(state) {
        var hoveredPath = (0, _FragmentsEditorGetUtils.getItemPath)(state.hoveredItemId, state.hoveredItemType, state.layoutData.structure);
        var fragmentEntryLinkInHoveredPath = (0, _FragmentsEditorGetUtils.itemIsInPath)(hoveredPath, state.fragmentEntryLinkId, _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment);
        var nextState = (0, _FragmentsEditorUpdateUtils.setIn)(state, ['_fragmentEntryLinkRowType'], state.rowType);
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_fragmentsEditorItemTypes'], _constants.FRAGMENTS_EDITOR_ITEM_TYPES);
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_fragmentsEditorRowTypes'], _constants.FRAGMENTS_EDITOR_ROW_TYPES);
        return (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_hovered'], fragmentEntryLinkInHoveredPath);
      }
      /**
       * @inheritdoc
       * @return {boolean}
       * @review
       */

    }, {
      key: "shouldUpdate",
      value: function shouldUpdate(changes) {
        return (0, _FragmentsEditorComponentUtils.shouldUpdatePureComponent)(changes);
      }
      /**
       * Handle fragment keyup event so it can emit when it
       * should be moved or selected.
       * @param {KeyboardEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleFragmentKeyUp",
      value: function _handleFragmentKeyUp(event) {
        if (!this.fragmentEditorEnabled) {
          event.stopPropagation();
          var direction = (0, _FragmentsEditorGetUtils.getItemMoveDirection)(event.keyCode);
          var fragmentEntryLinkRowType = event.delegateTarget.dataset.fragmentEntryLinkRowType;

          if (direction) {
            if (fragmentEntryLinkRowType === _constants.FRAGMENTS_EDITOR_ROW_TYPES.sectionRow) {
              (0, _FragmentsEditorUpdateUtils.moveRow)(direction, (0, _FragmentsEditorGetUtils.getFragmentRowIndex)(this.layoutData.structure, this.fragmentEntryLinkId), this.store, this.layoutData.structure);
            } else {
              var column = (0, _FragmentsEditorGetUtils.getFragmentColumn)(this.layoutData.structure, this.fragmentEntryLinkId);
              var fragmentIndex = column.fragmentEntryLinkIds.indexOf(this.fragmentEntryLinkId);
              var targetFragmentEntryLinkId = column.fragmentEntryLinkIds[fragmentIndex + direction];

              if (direction && targetFragmentEntryLinkId) {
                var moveItemPayload = {
                  fragmentEntryLinkId: this.fragmentEntryLinkId,
                  targetBorder: (0, _FragmentsEditorGetUtils.getTargetBorder)(direction),
                  targetItemId: targetFragmentEntryLinkId,
                  targetItemType: _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment
                };
                (0, _FragmentsEditorUpdateUtils.moveItem)(this.store, _actions.MOVE_FRAGMENT_ENTRY_LINK, moveItemPayload);
              }
            }
          }
        }
      }
      /**
       * Callback executed when the fragment remove button is clicked.
       * @param {Object} event
       * @private
       */

    }, {
      key: "_handleFragmentRemoveButtonClick",
      value: function _handleFragmentRemoveButtonClick(event) {
        event.stopPropagation();
        (0, _FragmentsEditorUpdateUtils.removeItem)(this.store, _actions.REMOVE_FRAGMENT_ENTRY_LINK, {
          fragmentEntryLinkId: this.fragmentEntryLinkId
        });
      }
    }]);

    return FragmentEntryLink;
  }(_metalComponent.default);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.FragmentEntryLink = FragmentEntryLink;
  FragmentEntryLink.STATE = {
    /**
     * FragmentEntryLink id
     * @default undefined
     * @instance
     * @memberOf FragmentEntryLink
     * @review
     * @type {!string}
     */
    fragmentEntryLinkId: _metalState.Config.string().required(),

    /**
     * Fragment name
     * @default ''
     * @instance
     * @memberOf FragmentEntryLink
     * @review
     * @type {string}
     */
    name: _metalState.Config.string().value(''),

    /**
     * Row type
     * @instance
     * @memberOf FragmentEntryLink
     * @review
     * @type {string}
     */
    rowType: _metalState.Config.string(),

    /**
     * Shows FragmentEntryLink control toolbar
     * @default true
     * @instance
     * @memberOf FragmentEntryLink
     * @review
     * @type {!bool}
     */
    showControlBar: _metalState.Config.bool().value(true),

    /**
     * CSS class to modify style
     * @default undefined
     * @instance
     * @memberOf FragmentEntryLink
     * @review
     * @type {!string}
     */
    styleModifier: _metalState.Config.string()
  };
  var ConnectedFragmentEntryLink = (0, _ConnectedComponent.getConnectedComponent)(FragmentEntryLink, ['activeItemId', 'activeItemType', 'defaultLanguageId', 'dropTargetItemId', 'dropTargetItemType', 'dropTargetBorder', 'fragmentEditorEnabled', 'hoveredItemId', 'hoveredItemType', 'imageSelectorURL', 'languageId', 'layoutData', 'portletNamespace', 'selectedMappingTypes', 'selectedSidebarPanelId', 'spritemap']);
  exports.ConnectedFragmentEntryLink = ConnectedFragmentEntryLink;

  _metalSoy.default.register(ConnectedFragmentEntryLink, _FragmentEntryLink.default);

  var _default = ConnectedFragmentEntryLink;
  exports.default = _default;
  //# sourceMappingURL=FragmentEntryLink.es.js.map
});
//# sourceMappingURL=FragmentEntryLink.es.js.map