"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/components/floating_toolbar/link/FloatingToolbarLinkPanel.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-debounce', 'frontend-js-metal-web$metal-soy', './FloatingToolbarLinkPanelDelegateTemplate.soy', '../../../utils/constants', '../../../actions/saveChanges.es', './FloatingToolbarLinkPanel.soy', '../../../actions/actions.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.FloatingToolbarLinkPanel = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalDebounce = _interopRequireDefault(require("frontend-js-metal-web$metal-debounce"));

  var _metalSoy = _interopRequireWildcard(require("frontend-js-metal-web$metal-soy"));

  require("./FloatingToolbarLinkPanelDelegateTemplate.soy");

  var _constants = require("../../../utils/constants");

  var _saveChanges = require("../../../actions/saveChanges.es");

  var _FloatingToolbarLinkPanel = _interopRequireDefault(require("./FloatingToolbarLinkPanel.soy"));

  var _actions = require("../../../actions/actions.es");

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj.default = obj;return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * FloatingToolbarLinkPanel
   */
  var FloatingToolbarLinkPanel =
  /*#__PURE__*/
  function (_Component) {
    _inherits(FloatingToolbarLinkPanel, _Component);

    function FloatingToolbarLinkPanel() {
      _classCallCheck(this, FloatingToolbarLinkPanel);

      return _possibleConstructorReturn(this, _getPrototypeOf(FloatingToolbarLinkPanel).apply(this, arguments));
    }

    _createClass(FloatingToolbarLinkPanel, [{
      key: "created",

      /**
       * @inheritdoc
       * @review
       */
      value: function created() {
        this._handleInputHrefKeyUp = (0, _metalDebounce.default)(this._handleInputHrefKeyUp.bind(this), 400);
      }
      /**
       * Callback executed on href keyup
       * @param {object} event
       * @private
       * @review
       */

    }, {
      key: "_handleInputHrefKeyUp",
      value: function _handleInputHrefKeyUp(event) {
        var hrefElement = event.target;
        var config = {
          href: hrefElement.value
        };

        this._updateRowConfig(config);
      }
      /**
       * @param {object} event
       * @private
       * @review
       */

    }, {
      key: "_handleSubmit",
      value: function _handleSubmit(event) {
        event.preventDefault();
        event.stopPropagation();
      }
      /**
       * Updates row configuration
       * @param {object} config Row configuration
       * @private
       * @review
       */

    }, {
      key: "_updateRowConfig",
      value: function _updateRowConfig(config) {
        this.store.dispatch((0, _saveChanges.enableSavingChangesStatusAction)()).dispatch({
          config: config,
          editableId: this.item.editableId,
          fragmentEntryLinkId: this.item.fragmentEntryLinkId,
          type: _actions.UPDATE_CONFIG_ATTRIBUTES
        }).dispatch((0, _saveChanges.updateLastSaveDateAction)()).dispatch((0, _saveChanges.disableSavingChangesStatusAction)());
      }
      /**
       * Handle button type option change
       * @param {Event} event
       */

    }, {
      key: "_handleButtonTypeOptionChange",
      value: function _handleButtonTypeOptionChange(event) {
        var buttonElement = event.delegateTarget;
        var buttonElementValue = buttonElement.options[buttonElement.selectedIndex].value;

        var buttonType = this._buttonTypes.find(function (type) {
          return type.buttonTypeId === buttonElementValue;
        });

        var config = {
          buttonType: buttonType.buttonTypeId
        };

        this._updateRowConfig(config);
      }
      /**
       * Handle button type option change
       * @param {Event} event
       */

    }, {
      key: "_handleTargetOptionChange",
      value: function _handleTargetOptionChange(event) {
        var targetElement = event.delegateTarget;
        var config = {
          target: targetElement.options[targetElement.selectedIndex].value
        };

        this._updateRowConfig(config);
      }
    }]);

    return FloatingToolbarLinkPanel;
  }(_metalComponent.default);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.FloatingToolbarLinkPanel = FloatingToolbarLinkPanel;
  FloatingToolbarLinkPanel.STATE = {
    /**
     * @default BUTTON_TYPES
     * @memberOf FloatingToolbarLinkPanel
     * @private
     * @review
     * @type {object[]}
     */
    _buttonTypes: _metalSoy.Config.array().internal().value(_constants.BUTTON_TYPES),

    /**
     * @default TARGET_TYPES
     * @memberOf FloatingToolbarLinkPanel
     * @private
     * @review
     * @type {object[]}
     */
    _targetTypes: _metalSoy.Config.array().internal().value(_constants.TARGET_TYPES),

    /**
     * @default undefined
     * @memberof FloatingToolbarLinkPanel
     * @review
     * @type {object}
     */
    item: _metalSoy.Config.object().value(null),

    /**
     * @default undefined
     * @memberof FloatingToolbarLinkPanel
     * @review
     * @type {!string}
     */
    itemId: _metalSoy.Config.string().required(),

    /**
     * @default undefined
     * @memberof FloatingToolbarLinkPanel
     * @review
     * @type {object}
     */
    store: _metalSoy.Config.object().value(null)
  };

  _metalSoy.default.register(FloatingToolbarLinkPanel, _FloatingToolbarLinkPanel.default);

  var _default = FloatingToolbarLinkPanel;
  exports.default = _default;
  //# sourceMappingURL=FloatingToolbarLinkPanel.es.js.map
});
//# sourceMappingURL=FloatingToolbarLinkPanel.es.js.map