"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/components/edit_mode/DisabledAreaMask.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-state', './DisabledAreaPopover.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.DisabledAreaMask = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _DisabledAreaPopover = _interopRequireDefault(require("./DisabledAreaPopover.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Applies a mask on edit mode for disabling some areas.
   * Starting from "origin" selector, it looks for elements that are
   * not parent of that element or inside "whitelist".
   * @review
   */
  var DisabledAreaMask =
  /*#__PURE__*/
  function (_Component) {
    _inherits(DisabledAreaMask, _Component);

    function DisabledAreaMask() {
      _classCallCheck(this, DisabledAreaMask);

      return _possibleConstructorReturn(this, _getPrototypeOf(DisabledAreaMask).apply(this, arguments));
    }

    _createClass(DisabledAreaMask, [{
      key: "created",

      /**
       * @inheritdoc
       * @review
       */
      value: function created() {
        this._markDisabledAreas();

        this._createDisabledAreaPopover();
      }
      /**
       * @inheritdoc
       * @review
       */

    }, {
      key: "disposed",
      value: function disposed() {
        if (this._disabledAreaPopover) {
          this._disabledAreaPopover.dispose();
        }
      }
      /**
       * Looks for disabled areas and marks them with
       * disabledAreaClass.
       * @private
       * @review
       */

    }, {
      key: "_markDisabledAreas",
      value: function _markDisabledAreas() {
        var _this = this;

        var element = document.querySelector(this.origin);

        while (element.parentElement && element !== document.body) {
          Array.from(element.parentElement.children).forEach(function (childElement) {
            return _this._markDisabledElement(childElement);
          });
          element = element.parentElement;
        }
      }
      /**
       * Marks the given element as disabled if it
       * does not fit any element from the whitelist.
       * @param {HTMLElement} element
       */

    }, {
      key: "_markDisabledElement",
      value: function _markDisabledElement(element) {
        var disable = element.tagName !== 'SCRIPT' && DisabledAreaMask._elementCanBeDisabled(element) && !this.whitelist.some(function (selector) {
          return DisabledAreaMask._elementMatchesSelector(element, selector);
        });

        if (disable) {
          element.classList.add(this.disabledAreaClass);
        }
      }
      /**
       * Creates a DisabledAreaPopover instance for
       * existing disabled areas.
       * @private
       * @review
       */

    }, {
      key: "_createDisabledAreaPopover",
      value: function _createDisabledAreaPopover() {
        if (this._disabledAreaPopover) {
          this._disabledAreaPopover.dispose();
        }

        this._disabledAreaPopover = new _DisabledAreaPopover.default({
          selector: '.lfr-edit-mode__disabled-area'
        });
      }
    }], [{
      key: "_elementCanBeDisabled",

      /**
       * Checks if the given element can be disabled.
       * @param {HTMLElement} element
       * @private
       * @return {boolean}
       * @review
       */
      value: function _elementCanBeDisabled(element) {
        var _element$getBoundingC = element.getBoundingClientRect(),
            height = _element$getBoundingC.height;

        var _window$getComputedSt = window.getComputedStyle(element),
            position = _window$getComputedSt.position;

        var hasAbsolutePosition = DisabledAreaMask.STATIC_POSITIONS.indexOf(position) === -1;
        var hasZeroHeight = height === 0;
        return !hasZeroHeight && !hasAbsolutePosition;
      }
      /**
       * Checks if the given element matches all necesary
       * rules to be disabled.
       * @param {HTMLElement} element
       * @param {string} selector
       * @private
       * @return {boolean}
       * @review
       */

    }, {
      key: "_elementMatchesSelector",
      value: function _elementMatchesSelector(element, selector) {
        var childMatchesSelector = element.querySelector(selector);
        var matchesSelector = element.matches(selector);
        return matchesSelector || childMatchesSelector;
      }
    }]);

    return DisabledAreaMask;
  }(_metalComponent.default);
  /**
   * @review
   * @see DisabledAreaMask.disabledAreaClass
   * @type {string}
   */

  exports.DisabledAreaMask = DisabledAreaMask;
  DisabledAreaMask.DEFAULT_DISABLED_AREA_CLASS = 'lfr-edit-mode__disabled-area';
  /**
   * @review
   * @see DisabledAreaMask.origin
   */

  DisabledAreaMask.DEFAULT_ORIGIN = '.layout-content';
  /**
   * @review
   * @see DisabledAreaMask.whitelist
   */

  DisabledAreaMask.DEFAULT_WHITELIST = [DisabledAreaMask.DEFAULT_ORIGIN, ".".concat(DisabledAreaMask.DEFAULT_DISABLED_AREA_CLASS), '.control-menu', '.lfr-add-panel', '.lfr-product-menu-panel'];
  /**
   * List of CSS positions that define
   * an static-like positioned element
   * @review
   * @type {string[]}
   */

  DisabledAreaMask.STATIC_POSITIONS = ['', 'static', 'relative'];
  /**
   * State definition
   * @review
   * @static
   * @type {!object}
   */

  DisabledAreaMask.STATE = {
    /**
     * HTMLElement where the disabling process starts
     * @default DEFAULT_ORIGIN
     * @instance
     * @memberOf DisabledAreaMask
     * @review
     * @type {string}
     */
    origin: _metalState.Config.string().value(DisabledAreaMask.DEFAULT_ORIGIN),

    /**
     * CSS class added to elements that are going to
     * be disabled.
     * @default DEFAULT_DISABLED_AREA_CLASS
     * @instance
     * @memberOf DisabledAreaMask
     * @review
     * @type {string}
     */
    disabledAreaClass: _metalState.Config.string().value(DisabledAreaMask.DEFAULT_DISABLED_AREA_CLASS),

    /**
     * List of selectors that are ignored when disabling
     * elements. Any element matching any of these selector
     * will NOT be disabled.
     * @default DEFAULT_WHITELIST
     * @instance
     * @memberOf DisabledAreaMask
     * @review
     * @type {string[]}
     */
    whitelist: _metalState.Config.arrayOf(_metalState.Config.string()).value(DisabledAreaMask.DEFAULT_WHITELIST),

    /**
     * Popover instance used internally
     * @default null
     * @instance
     * @memberOf DisabledAreaMask
     * @review
     * @type {object}
     */
    _disabledAreaPopover: _metalState.Config.object().value(null)
  };
  var _default = DisabledAreaMask;
  exports.default = _default;
  //# sourceMappingURL=DisabledAreaMask.es.js.map
});
//# sourceMappingURL=DisabledAreaMask.es.js.map