"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/actions/updateRowColumnsNumber.es", ['module', 'exports', 'require', './saveChanges.es', '../utils/FragmentsEditorGetUtils.es', '../utils/rowConstants', '../utils/FragmentsEditorFetchUtils.es', '../utils/FragmentsEditorUpdateUtils.es', './actions.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.updateRowColumnsNumberAction = updateRowColumnsNumberAction;

  var _saveChanges = require("./saveChanges.es");

  var _FragmentsEditorGetUtils = require("../utils/FragmentsEditorGetUtils.es");

  var _rowConstants = require("../utils/rowConstants");

  var _FragmentsEditorFetchUtils = require("../utils/FragmentsEditorFetchUtils.es");

  var _FragmentsEditorUpdateUtils = require("../utils/FragmentsEditorUpdateUtils.es");

  var _actions = require("./actions.es");

  /**
   * @param {number} numberOfColumns
   * @param {string} rowId
   * @return {function}
   * @review
   */
  function updateRowColumnsNumberAction(numberOfColumns, rowId) {
    return function (dispatch, getState) {
      var state = getState();
      var columnsSize = Math.floor(_rowConstants.MAX_COLUMNS / numberOfColumns);
      var rowIndex = (0, _FragmentsEditorGetUtils.getRowIndex)(state.layoutData.structure, rowId);
      var columns = state.layoutData.structure[rowIndex].columns;
      var nextData;

      if (numberOfColumns > columns.length) {
        nextData = _addColumns(state.layoutData, rowIndex, numberOfColumns, columnsSize);
      } else {
        nextData = _removeColumns(state.layoutData, rowIndex, numberOfColumns, columnsSize);
      }

      var fragmentEntryLinkIdsToRemove = (0, _FragmentsEditorGetUtils.getRowFragmentEntryLinkIds)({
        columns: columns.slice(numberOfColumns - columns.length)
      });
      dispatch(updateRowColumnsNumberLoadingAction());
      dispatch((0, _saveChanges.enableSavingChangesStatusAction)());
      (0, _FragmentsEditorFetchUtils.updatePageEditorLayoutData)(nextData, state.segmentsExperienceId).then(function () {
        return (0, _FragmentsEditorFetchUtils.removeFragmentEntryLinks)(nextData, fragmentEntryLinkIdsToRemove, state.segmentsExperienceId);
      }).then(function () {
        dispatch(updateRowColumnsNumberSuccessAction(fragmentEntryLinkIdsToRemove, nextData));
        dispatch((0, _saveChanges.updateLastSaveDateAction)());
        dispatch((0, _saveChanges.disableSavingChangesStatusAction)());
      }).catch(function () {
        dispatch(updateRowColumnsNumberErrorAction());
        dispatch((0, _saveChanges.disableSavingChangesStatusAction)());
      });
    };
  }
  /**
   * @return {object}
   * @review
   */

  function updateRowColumnsNumberErrorAction() {
    return {
      type: _actions.UPDATE_ROW_COLUMNS_NUMBER_ERROR
    };
  }
  /**
   * @return {object}
   * @review
   */

  function updateRowColumnsNumberLoadingAction() {
    return {
      type: _actions.UPDATE_ROW_COLUMNS_NUMBER_LOADING
    };
  }
  /**
   * @param {Array} fragmentEntryLinkIdsToRemove
   * @param {object} layoutData
   * @return {object}
   * @review
   */

  function updateRowColumnsNumberSuccessAction(fragmentEntryLinkIdsToRemove, layoutData) {
    return {
      fragmentEntryLinkIdsToRemove: fragmentEntryLinkIdsToRemove,
      layoutData: layoutData,
      type: _actions.UPDATE_ROW_COLUMNS_NUMBER_SUCCESS
    };
  }
  /**
   * Returns a new layoutData with the given columns inserted in the specified
   * row with the specified size and resizes the rest of columns to the
   * same size.
   *
   * @param {object} layoutData
   * @param {number} rowIndex
   * @param {number} numberOfColumns
   * @param {number} columnsSize
   * @return {object}
   */

  function _addColumns(layoutData, rowIndex, numberOfColumns, columnsSize) {
    var nextColumnId = layoutData.nextColumnId || 0;
    var nextData = (0, _FragmentsEditorUpdateUtils.updateIn)(layoutData, ['structure', rowIndex, 'columns'], function (columns) {
      var newColumns = columns.map(function (column, index) {
        return (0, _FragmentsEditorUpdateUtils.setIn)(column, ['size'], _getColumnSize(numberOfColumns, columnsSize, index));
      });
      var numberOfNewColumns = numberOfColumns - columns.length;
      var numberOfOldColumns = columns.length;

      for (var i = 0; i < numberOfNewColumns; i++) {
        newColumns.push({
          columnId: "".concat(nextColumnId),
          fragmentEntryLinkIds: [],
          size: _getColumnSize(numberOfColumns, columnsSize, i + numberOfOldColumns)
        });
        nextColumnId += 1;
      }

      return newColumns;
    });
    nextData = (0, _FragmentsEditorUpdateUtils.setIn)(nextData, ['nextColumnId'], nextColumnId);
    return nextData;
  }
  /**
   * Returns the new size of a column based on the total number of columns of a
   * grid, the general size and its position in the grid.
   *
   * @param {number} numberOfColumns
   * @param {number} columnsSize
   * @param {number} columnIndex
   * @return {string}
   */

  function _getColumnSize(numberOfColumns, columnsSize, columnIndex) {
    var newColumnSize = columnsSize;
    var middleColumnPosition = Math.ceil(numberOfColumns / 2) - 1;

    if (middleColumnPosition === columnIndex) {
      newColumnSize = _rowConstants.MAX_COLUMNS - (numberOfColumns - 1) * columnsSize;
    }

    return newColumnSize.toString();
  }
  /**
   * Returns a new layoutData without the columns out of range in the specified
   * row and resizes the rest of columns to the specified size.
   *
   * @param {object} layoutData
   * @param {number} rowIndex
   * @param {number} numberOfColumns
   * @param {number} columnsSize
   * @return {object}
   */

  function _removeColumns(layoutData, rowIndex, numberOfColumns, columnsSize) {
    var nextData = (0, _FragmentsEditorUpdateUtils.updateIn)(layoutData, ['structure', rowIndex, 'columns'], function (columns) {
      var newColumns = columns.slice(0, numberOfColumns);
      newColumns = newColumns.map(function (column, index) {
        return (0, _FragmentsEditorUpdateUtils.setIn)(column, ['size'], _getColumnSize(numberOfColumns, columnsSize, index));
      });
      return newColumns;
    });
    return nextData;
  }
  //# sourceMappingURL=updateRowColumnsNumber.es.js.map
});
//# sourceMappingURL=updateRowColumnsNumber.es.js.map