"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/actions/updateEditableValue.es", ['module', 'exports', 'require', './saveChanges.es', '../utils/constants', '../utils/FragmentsEditorUpdateUtils.es', './actions.es', '../utils/FragmentsEditorFetchUtils.es', '../utils/debouncedAlert.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.updateEditableValueAction = updateEditableValueAction;
  exports.updateEditableValuesAction = updateEditableValuesAction;
  exports.updateEditableValueSuccessAction = updateEditableValueSuccessAction;

  var _saveChanges = require("./saveChanges.es");

  var _constants = require("../utils/constants");

  var _FragmentsEditorUpdateUtils = require("../utils/FragmentsEditorUpdateUtils.es");

  var _actions = require("./actions.es");

  var _FragmentsEditorFetchUtils = require("../utils/FragmentsEditorFetchUtils.es");

  var _debouncedAlert = _interopRequireDefault(require("../utils/debouncedAlert.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  /**
   * @type {number}
   */
  var UPDATE_EDITABLE_VALUES_DELAY = 1500;
  /**
   * @param {function} dispatch
   * @param {string} fragmentEntryLinkId
   * @param {object} previousEditableValues
   * @param {object} nextEditableValues
   * @review
   */

  var debouncedUpdateEditableValues = (0, _debouncedAlert.default)(
  /**
   * @param {function} dispatch
   * @param {string} fragmentEntryLinkId
   * @param {object} previousEditableValues
   * @param {object} nextEditableValues
  	 * @review
   */
  function (dispatch, fragmentEntryLinkId, previousEditableValues, nextEditableValues) {
    (0, _FragmentsEditorFetchUtils.updateEditableValues)(fragmentEntryLinkId, nextEditableValues).then(function () {
      dispatch(updateEditableValueSuccessAction());
      dispatch((0, _saveChanges.disableSavingChangesStatusAction)());
      dispatch((0, _saveChanges.updateLastSaveDateAction)());
    }).catch(function () {
      dispatch(updateEditableValueErrorAction(fragmentEntryLinkId, previousEditableValues));
      dispatch((0, _saveChanges.disableSavingChangesStatusAction)());
    });
  }, UPDATE_EDITABLE_VALUES_DELAY);
  /**
   * @param {string} fragmentEntryLinkId
   * @param {string} editableId
   * @param {string} editableValueId
   * @param {string} editableValueContent
   * @param {string} [segmentsExperienceId='']
   * @return {function}
   * @review
   */

  function updateEditableValueAction(fragmentEntryLinkId, editableId, editableValueId, editableValueContent) {
    var segmentsExperienceId = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : '';
    var processor = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : _constants.EDITABLE_FRAGMENT_ENTRY_PROCESSOR;
    return updateEditableValuesAction(fragmentEntryLinkId, editableId, [{
      content: editableValueContent,
      editableValueId: editableValueId
    }], segmentsExperienceId, processor);
  }
  /**
   * @param {string} fragmentEntryLinkId
   * @param {string} editableId
   * @param {Array<{editableValueId: string, content: string}>} editableValues
   * @param {string} [editableValueSegmentsExperienceId='']
   * @return {function}
   * @review
   */

  function updateEditableValuesAction(fragmentEntryLinkId, editableId, editableValues) {
    var editableValueSegmentsExperienceId = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';
    var processor = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : _constants.EDITABLE_FRAGMENT_ENTRY_PROCESSOR;
    return function (dispatch, getState) {
      var state = getState();
      var previousEditableValues = state.fragmentEntryLinks[fragmentEntryLinkId].editableValues;
      var keysTreeArray = editableValueSegmentsExperienceId ? [processor, editableId, editableValueSegmentsExperienceId] : [processor, editableId];
      var nextEditableValues = previousEditableValues;
      editableValues.forEach(function (editableValue) {
        if (!editableValue.content) {
          nextEditableValues = (0, _FragmentsEditorUpdateUtils.deleteIn)(nextEditableValues, [].concat(keysTreeArray, [editableValue.editableValueId]));
        } else {
          nextEditableValues = (0, _FragmentsEditorUpdateUtils.setIn)(nextEditableValues, [].concat(keysTreeArray, [editableValue.editableValueId]), editableValue.content);
        }

        if (editableValue.editableValueId === 'mappedField') {
          nextEditableValues = (0, _FragmentsEditorUpdateUtils.updateIn)(nextEditableValues, keysTreeArray, function (previousEditableValue) {
            var nextEditableValue = Object.assign({}, previousEditableValue);
            ['config', state.defaultSegmentsEntryId].concat(_toConsumableArray(Object.keys(state.availableLanguages)), _toConsumableArray(Object.keys(state.availableSegmentsEntries))).forEach(function (key) {
              delete nextEditableValue[key];
            });
            return nextEditableValue;
          });
        }
      });
      dispatch(updateEditableValueLoadingAction(fragmentEntryLinkId, nextEditableValues));
      dispatch((0, _saveChanges.enableSavingChangesStatusAction)());
      debouncedUpdateEditableValues(dispatch, fragmentEntryLinkId, previousEditableValues, nextEditableValues);
    };
  }
  /**
   * @param {string} fragmentEntryLinkId
   * @param {object} editableValues
   * @param {Date} [date=new Date()]
   * @return {object}
   * @review
   */

  function updateEditableValueErrorAction(fragmentEntryLinkId, editableValues) {
    var date = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : new Date();
    return {
      date: date,
      editableValues: editableValues,
      fragmentEntryLinkId: fragmentEntryLinkId,
      type: _actions.UPDATE_EDITABLE_VALUE_ERROR
    };
  }
  /**
   * @param {string} fragmentEntryLinkId
   * @param {object} editableValues
   * @return {object}
   * @review
   */

  function updateEditableValueLoadingAction(fragmentEntryLinkId, editableValues) {
    return {
      editableValues: editableValues,
      fragmentEntryLinkId: fragmentEntryLinkId,
      type: _actions.UPDATE_EDITABLE_VALUE_LOADING
    };
  }
  /**
   * @param {Date} [date=new Date()]
   * @return {object}
   * @review
   */

  function updateEditableValueSuccessAction() {
    var date = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : new Date();
    return {
      date: date,
      type: _actions.UPDATE_EDITABLE_VALUE_SUCCESS
    };
  }
  //# sourceMappingURL=updateEditableValue.es.js.map
});
//# sourceMappingURL=updateEditableValue.es.js.map