"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/actions/saveChanges.es", ['module', 'exports', 'require', './actions.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.disableSavingChangesStatusAction = disableSavingChangesStatusAction;
  exports.enableSavingChangesStatusAction = enableSavingChangesStatusAction;
  exports.updateLastSaveDateAction = updateLastSaveDateAction;

  var _actions = require("./actions.es");

  /**
   * @return {object}
   */
  function disableSavingChangesStatusAction() {
    return {
      savingChanges: false,
      type: _actions.UPDATE_SAVING_CHANGES_STATUS
    };
  }
  /**
   * @return {object}
   */

  function enableSavingChangesStatusAction() {
    return {
      savingChanges: true,
      type: _actions.UPDATE_SAVING_CHANGES_STATUS
    };
  }
  /**
   * @param {Date} [date=new Date()]
   * @return {object}
   */

  function updateLastSaveDateAction() {
    var date = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : new Date();
    return {
      lastSaveDate: date,
      type: _actions.UPDATE_LAST_SAVE_DATE
    };
  }
  //# sourceMappingURL=saveChanges.es.js.map
});
//# sourceMappingURL=saveChanges.es.js.map