/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.content.page.editor.web.internal.model.listener;

import com.liferay.asset.service.AssetEntryUsageLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.util.LayoutCopyHelper;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class LayoutModelListener
extends BaseModelListener<Layout> {
    private static final Log _log = LogFactoryUtil.getLog(LayoutModelListener.class);
    @Reference
    private AssetEntryUsageLocalService _assetEntryUsageLocalService;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private LayoutCopyHelper _layoutCopyHelper;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;

    public void onAfterCreate(Layout layout) throws ModelListenerException {
        if (!this._isContentLayout(layout)) {
            return;
        }
        this._reindexLayout(layout);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._getLayoutPageTemplateEntry(layout);
        if (ExportImportThreadLocal.isImportInProcess() || ExportImportThreadLocal.isStagingInProcess() || layoutPageTemplateEntry == null) {
            return;
        }
        TransactionCommitCallbackUtil.registerCallback(() -> this._copyStructure(layoutPageTemplateEntry, layout));
    }

    public void onAfterUpdate(Layout layout) throws ModelListenerException {
        if (!this._isContentLayout(layout)) {
            return;
        }
        this._reindexLayout(layout);
    }

    public void onBeforeRemove(Layout layout) throws ModelListenerException {
        if (!this._isContentLayout(layout)) {
            return;
        }
        this._fragmentEntryLinkLocalService.deleteLayoutPageTemplateEntryFragmentEntryLinks(layout.getGroupId(), this._portal.getClassNameId(Layout.class.getName()), layout.getPlid());
        try {
            Indexer indexer = IndexerRegistryUtil.getIndexer(Layout.class);
            indexer.delete((Object)layout);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            throw new ModelListenerException((Throwable)pe);
        }
    }

    private Void _copyStructure(LayoutPageTemplateEntry layoutPageTemplateEntry, Layout layout) throws Exception {
        Layout draftLayout = this._layoutLocalService.fetchLayout(this._portal.getClassNameId(Layout.class), layout.getPlid());
        Layout pagetTemplateLayout = this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid());
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(pagetTemplateLayout.getGroupId(), this._portal.getClassNameId(Layout.class), pagetTemplateLayout.getPlid());
        if (layoutPageTemplateStructure == null) {
            this._layoutPageTemplateStructureLocalService.rebuildLayoutPageTemplateStructure(pagetTemplateLayout.getGroupId(), this._portal.getClassNameId(Layout.class), pagetTemplateLayout.getPlid());
        }
        draftLayout = this._layoutCopyHelper.copyLayout(pagetTemplateLayout, draftLayout);
        this._layoutLocalService.updateLayout(draftLayout.getGroupId(), draftLayout.isPrivateLayout(), draftLayout.getLayoutId(), draftLayout.getTypeSettings());
        List assetEntryUsages = this._assetEntryUsageLocalService.getAssetEntryUsagesByPlid(layoutPageTemplateEntry.getPlid());
        ServiceContext serviceContext = new ServiceContext();
        assetEntryUsages.forEach(assetEntryUsage -> this._assetEntryUsageLocalService.addAssetEntryUsage(assetEntryUsage.getGroupId(), assetEntryUsage.getAssetEntryId(), assetEntryUsage.getContainerType(), assetEntryUsage.getContainerKey(), layout.getPlid(), serviceContext));
        return null;
    }

    private LayoutPageTemplateEntry _getLayoutPageTemplateEntry(Layout layout) {
        long classNameId = this._portal.getClassNameId(LayoutPageTemplateEntry.class);
        if (layout.getClassNameId() != classNameId) {
            return null;
        }
        return this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(layout.getClassPK());
    }

    private boolean _isContentLayout(Layout layout) {
        return Objects.equals(layout.getType(), "content");
    }

    private void _reindexLayout(Layout layout) {
        Indexer indexer = IndexerRegistryUtil.getIndexer(Layout.class);
        try {
            indexer.reindex((Object)layout);
        }
        catch (SearchException se) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to reindex layout " + layout.getPlid()), (Throwable)se);
            }
            throw new ModelListenerException((Throwable)se);
        }
    }
}

