/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.content.page.editor.web.internal.display.context;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.fragment.contributor.FragmentCollectionContributor;
import com.liferay.fragment.contributor.FragmentCollectionContributorTracker;
import com.liferay.fragment.model.FragmentCollection;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.renderer.DefaultFragmentRendererContext;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererContext;
import com.liferay.fragment.renderer.FragmentRendererController;
import com.liferay.fragment.renderer.FragmentRendererTracker;
import com.liferay.fragment.service.FragmentCollectionServiceUtil;
import com.liferay.fragment.service.FragmentEntryLinkLocalServiceUtil;
import com.liferay.fragment.service.FragmentEntryServiceUtil;
import com.liferay.info.display.contributor.InfoDisplayContributor;
import com.liferay.info.display.contributor.InfoDisplayContributorTracker;
import com.liferay.item.selector.ItemSelector;
import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.item.selector.ItemSelectorReturnType;
import com.liferay.item.selector.criteria.DownloadURLItemSelectorReturnType;
import com.liferay.item.selector.criteria.URLItemSelectorReturnType;
import com.liferay.item.selector.criteria.image.criterion.ImageItemSelectorCriterion;
import com.liferay.item.selector.criteria.url.criterion.URLItemSelectorCriterion;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalServiceUtil;
import com.liferay.portal.kernel.editor.configuration.EditorConfiguration;
import com.liferay.portal.kernel.editor.configuration.EditorConfigurationFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletCategory;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.PortletCategoryComparator;
import com.liferay.portal.kernel.util.comparator.PortletTitleComparator;
import com.liferay.portal.template.soy.util.SoyContext;
import com.liferay.portal.template.soy.util.SoyContextFactoryUtil;
import com.liferay.portal.util.PortletCategoryUtil;
import com.liferay.portal.util.WebAppPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceURL;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ContentPageEditorDisplayContext {
    protected final long classNameId;
    protected final long classPK;
    protected final InfoDisplayContributorTracker infoDisplayContributorTracker;
    protected final HttpServletRequest request;
    protected final ThemeDisplay themeDisplay;
    private static final Log _log = LogFactoryUtil.getLog(ContentPageEditorDisplayContext.class);
    private List<SoyContext> _assetBrowserLinksSoyContexts;
    private Map<String, Object> _defaultConfigurations;
    private final FragmentCollectionContributorTracker _fragmentCollectionContributorTracker;
    private final FragmentRendererController _fragmentRendererController;
    private final FragmentRendererTracker _fragmentRendererTracker;
    private Long _groupId;
    private ItemSelectorCriterion _imageItemSelectorCriterion;
    private final ItemSelector _itemSelector;
    private String _layoutData;
    private String _redirect;
    private final RenderResponse _renderResponse;
    private List<SoyContext> _sidebarPanelSoyContexts;
    private SoyContext _soyContextFragmentEntryLinksSoyContext;
    private ItemSelectorCriterion _urlItemSelectorCriterion;

    public ContentPageEditorDisplayContext(HttpServletRequest httpServletRequest, RenderResponse renderResponse, String className, long classPK, FragmentRendererController fragmentRendererController) {
        this.request = httpServletRequest;
        this._renderResponse = renderResponse;
        this.classPK = classPK;
        this.classNameId = PortalUtil.getClassNameId((String)className);
        this.infoDisplayContributorTracker = (InfoDisplayContributorTracker)httpServletRequest.getAttribute("INFO_DISPLAY_CONTRIBUTOR_TRACKER");
        this.themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._fragmentRendererController = fragmentRendererController;
        this._fragmentCollectionContributorTracker = (FragmentCollectionContributorTracker)httpServletRequest.getAttribute("FRAGMENT_COLLECTION_CONTRIBUTOR_TRACKER");
        this._fragmentRendererTracker = (FragmentRendererTracker)httpServletRequest.getAttribute("FRAGMENT_RENDERER_TRACKER");
        this._itemSelector = (ItemSelector)httpServletRequest.getAttribute("ITEM_SELECTOR");
    }

    public SoyContext getEditorSoyContext() throws Exception {
        SoyContext soyContext = SoyContextFactoryUtil.createSoyContext();
        soyContext.put("addFragmentEntryLinkURL", (Object)this.getFragmentEntryActionURL("/content_layout/add_fragment_entry_link")).put("addPortletURL", (Object)this.getFragmentEntryActionURL("/content_layout/add_portlet")).put("assetBrowserLinks", this._getAssetBrowserLinksSoyContexts()).put("availableLanguages", (Object)this._getAvailableLanguagesSoyContext()).put("classNameId", (Object)this.classNameId).put("classPK", (Object)this.classPK).put("defaultEditorConfigurations", this._getDefaultConfigurations()).put("defaultLanguageId", (Object)LocaleUtil.toLanguageId((Locale)this.themeDisplay.getSiteDefaultLocale())).put("deleteFragmentEntryLinkURL", (Object)this.getFragmentEntryActionURL("/content_layout/delete_fragment_entry_link"));
        if (this.classNameId == PortalUtil.getClassNameId(Layout.class)) {
            soyContext.put("discardDraftRedirectURL", (Object)this.themeDisplay.getURLCurrent()).put("discardDraftURL", (Object)this.getFragmentEntryActionURL("/content_layout/discard_draft_layout")).put("lookAndFeelURL", (Object)this._getLookAndFeelURL());
        }
        soyContext.put("editFragmentEntryLinkURL", (Object)this.getFragmentEntryActionURL("/content_layout/edit_fragment_entry_link")).put("elements", this._getFragmentCollectionsSoyContexts(1)).put("fragmentEntryLinks", (Object)this._getFragmentEntryLinksSoyContext());
        ResourceURL getAssetFieldValueURL = this._renderResponse.createResourceURL();
        getAssetFieldValueURL.setResourceID("/content_layout/get_asset_field_value");
        soyContext.put("getAssetFieldValueURL", (Object)getAssetFieldValueURL.toString());
        ResourceURL getAssetMappingFieldsURL = this._renderResponse.createResourceURL();
        getAssetMappingFieldsURL.setResourceID("/content_layout/get_asset_mapping_fields");
        soyContext.put("getAssetMappingFieldsURL", (Object)getAssetMappingFieldsURL.toString()).put("imageSelectorURL", (Object)this._getItemSelectorURL()).put("languageId", (Object)this.themeDisplay.getLanguageId()).put("layoutData", (Object)JSONFactoryUtil.createJSONObject((String)this._getLayoutData())).put("mappedAssetEntries", this._getMappedAssetEntriesSoyContexts()).put("portletNamespace", (Object)this._renderResponse.getNamespace());
        if (this.classNameId == PortalUtil.getClassNameId(Layout.class)) {
            soyContext.put("publishURL", (Object)this.getFragmentEntryActionURL("/content_layout/publish_layout"));
        }
        soyContext.put("renderFragmentEntryURL", (Object)this.getFragmentEntryActionURL("/content_layout/render_fragment_entry")).put("redirectURL", (Object)this._getRedirect()).put("sections", this._getFragmentCollectionsSoyContexts(0)).put("spritemap", (Object)(this.themeDisplay.getPathThemeImages() + "/lexicon/icons.svg")).put("themeColorsCssClasses", (Object)this._getThemeColorsCssClasses()).put("updateLayoutPageTemplateDataURL", (Object)this.getFragmentEntryActionURL("/content_layout/update_layout_page_template_data")).put("widgets", this._getWidgetsSoyContexts());
        return soyContext;
    }

    public SoyContext getFragmentsEditorToolbarSoyContext() throws PortalException {
        SoyContext soyContext = SoyContextFactoryUtil.createSoyContext();
        soyContext.put("availableLanguages", (Object)this._getAvailableLanguagesSoyContext()).put("classPK", (Object)this.themeDisplay.getPlid()).put("defaultLanguageId", (Object)this.themeDisplay.getLanguageId());
        boolean draft = false;
        Layout draftLayout = LayoutLocalServiceUtil.getLayout((long)this.classPK);
        Layout layout = LayoutLocalServiceUtil.getLayout((long)draftLayout.getClassPK());
        Date modifiedDate = draftLayout.getModifiedDate();
        Date publishDate = layout.getPublishDate();
        if (publishDate == null) {
            publishDate = modifiedDate;
        }
        draft = modifiedDate.after(publishDate);
        soyContext.put("draft", (Object)draft).put("lastSaveDate", (Object)"").put("portletNamespace", (Object)this._renderResponse.getNamespace()).put("spritemap", (Object)(this.themeDisplay.getPathThemeImages() + "/lexicon/icons.svg"));
        return soyContext;
    }

    protected String getFragmentEntryActionURL(String action) {
        PortletURL actionURL = this._renderResponse.createActionURL();
        actionURL.setParameter("javax.portlet.action", action);
        return HttpUtil.addParameter((String)actionURL.toString(), (String)"p_l_mode", (String)"edit");
    }

    protected long getGroupId() {
        if (this._groupId != null) {
            return this._groupId;
        }
        this._groupId = ParamUtil.getLong((HttpServletRequest)this.request, (String)"groupId", (long)this.themeDisplay.getScopeGroupId());
        return this._groupId;
    }

    protected List<SoyContext> getSidebarPanelSoyContexts(boolean showMapping) {
        if (this._sidebarPanelSoyContexts != null) {
            return this._sidebarPanelSoyContexts;
        }
        ArrayList<SoyContext> soyContexts = new ArrayList<SoyContext>();
        SoyContext availableSoyContext = SoyContextFactoryUtil.createSoyContext();
        availableSoyContext.put("icon", (Object)"cards-full");
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)this.themeDisplay.getLocale(), this.getClass());
        availableSoyContext.put("label", (Object)LanguageUtil.get((ResourceBundle)resourceBundle, (String)"sections")).put("sidebarPanelId", (Object)"sections");
        soyContexts.add(availableSoyContext);
        availableSoyContext = SoyContextFactoryUtil.createSoyContext();
        availableSoyContext.put("icon", (Object)"cards2").put("label", (Object)LanguageUtil.get((ResourceBundle)resourceBundle, (String)"section-builder")).put("sidebarPanelId", (Object)"elements");
        soyContexts.add(availableSoyContext);
        availableSoyContext = SoyContextFactoryUtil.createSoyContext();
        availableSoyContext.put("icon", (Object)"square-hole").put("label", (Object)LanguageUtil.get((ResourceBundle)resourceBundle, (String)"widgets")).put("sidebarPanelId", (Object)"widgets");
        soyContexts.add(availableSoyContext);
        if (showMapping) {
            availableSoyContext = SoyContextFactoryUtil.createSoyContext();
            availableSoyContext.put("icon", (Object)"bolt").put("label", (Object)LanguageUtil.get((Locale)this.themeDisplay.getLocale(), (String)"mapping")).put("sidebarPanelId", (Object)"mapping");
            soyContexts.add(availableSoyContext);
        }
        availableSoyContext = SoyContextFactoryUtil.createSoyContext();
        availableSoyContext.put("icon", (Object)"pages-tree").put("label", (Object)LanguageUtil.get((ResourceBundle)resourceBundle, (String)"page-structure")).put("sidebarPanelId", (Object)"page-structure");
        soyContexts.add(availableSoyContext);
        this._sidebarPanelSoyContexts = soyContexts;
        return this._sidebarPanelSoyContexts;
    }

    private List<SoyContext> _getAssetBrowserLinksSoyContexts() throws Exception {
        if (this._assetBrowserLinksSoyContexts != null) {
            return this._assetBrowserLinksSoyContexts;
        }
        ArrayList<SoyContext> soyContexts = new ArrayList<SoyContext>();
        List infoDisplayContributors = this.infoDisplayContributorTracker.getInfoDisplayContributors();
        for (InfoDisplayContributor infoDisplayContributor : infoDisplayContributors) {
            PortletURL assetBrowserURL;
            if (infoDisplayContributor == null || (assetBrowserURL = PortletProviderUtil.getPortletURL((HttpServletRequest)this.request, (String)infoDisplayContributor.getClassName(), (PortletProvider.Action)PortletProvider.Action.BROWSE)) == null) continue;
            SoyContext assetBrowserSoyContext = SoyContextFactoryUtil.createSoyContext();
            assetBrowserURL.setParameter("groupId", String.valueOf(this.themeDisplay.getScopeGroupId()));
            assetBrowserURL.setParameter("selectedGroupIds", String.valueOf(this.themeDisplay.getScopeGroupId()));
            assetBrowserURL.setParameter("typeSelection", infoDisplayContributor.getClassName());
            assetBrowserURL.setParameter("showNonindexable", String.valueOf(Boolean.TRUE));
            assetBrowserURL.setParameter("showScheduled", String.valueOf(Boolean.TRUE));
            assetBrowserURL.setParameter("eventName", this._renderResponse.getNamespace() + "selectAsset");
            assetBrowserURL.setPortletMode(PortletMode.VIEW);
            assetBrowserURL.setWindowState(LiferayWindowState.POP_UP);
            assetBrowserSoyContext.put("href", (Object)assetBrowserURL.toString()).put("typeName", (Object)infoDisplayContributor.getLabel(this.themeDisplay.getLocale()));
            soyContexts.add(assetBrowserSoyContext);
        }
        this._assetBrowserLinksSoyContexts = soyContexts;
        return this._assetBrowserLinksSoyContexts;
    }

    private SoyContext _getAvailableLanguagesSoyContext() {
        String[] languageIds;
        SoyContext availableLanguagesSoyContext = SoyContextFactoryUtil.createSoyContext();
        for (String languageId : languageIds = LocaleUtil.toLanguageIds((Collection)LanguageUtil.getAvailableLocales((long)this.themeDisplay.getSiteGroupId()))) {
            SoyContext languageSoyContext = SoyContextFactoryUtil.createSoyContext();
            String languageIcon = StringUtil.toLowerCase((String)languageId.replace("_", "-"));
            languageSoyContext.put("languageIcon", (Object)languageIcon);
            String languageLabel = languageId.replace("_", "-");
            languageSoyContext.put("languageLabel", (Object)languageLabel);
            availableLanguagesSoyContext.put(languageId, (Object)languageSoyContext);
        }
        return availableLanguagesSoyContext;
    }

    private SoyContext _getContributedFragmentEntrySoyContext(String rendererKey) {
        SoyContext soyContext = SoyContextFactoryUtil.createSoyContext();
        Map fragmentEntries = this._fragmentCollectionContributorTracker.getFragmentEntries();
        FragmentEntry fragmentEntry = (FragmentEntry)fragmentEntries.get(rendererKey);
        if (fragmentEntry != null) {
            soyContext.put("fragmentEntryId", (Object)0).put("name", (Object)fragmentEntry.getName());
        }
        return soyContext;
    }

    private Map<String, Object> _getDefaultConfigurations() {
        if (this._defaultConfigurations != null) {
            return this._defaultConfigurations;
        }
        HashMap<String, Object> configurations = new HashMap<String, Object>();
        EditorConfiguration richTextEditorConfiguration = EditorConfigurationFactoryUtil.getEditorConfiguration((String)"com_liferay_layout_content_page_editor_web_internal_portlet_ContentPageEditorPortlet", (String)"fragmenEntryLinkRichTextEditor", (String)"", Collections.emptyMap(), (ThemeDisplay)this.themeDisplay, (RequestBackedPortletURLFactory)RequestBackedPortletURLFactoryUtil.create((HttpServletRequest)this.request));
        configurations.put("rich-text", richTextEditorConfiguration.getData());
        EditorConfiguration editorConfiguration = EditorConfigurationFactoryUtil.getEditorConfiguration((String)"com_liferay_layout_content_page_editor_web_internal_portlet_ContentPageEditorPortlet", (String)"fragmenEntryLinkEditor", (String)"", Collections.emptyMap(), (ThemeDisplay)this.themeDisplay, (RequestBackedPortletURLFactory)RequestBackedPortletURLFactoryUtil.create((HttpServletRequest)this.request));
        configurations.put("text", editorConfiguration.getData());
        this._defaultConfigurations = configurations;
        return this._defaultConfigurations;
    }

    private List<SoyContext> _getDynamicFragmentsSoyContexts(int type) {
        ArrayList<SoyContext> soyContexts = new ArrayList<SoyContext>();
        HashMap<String, List> fragmentCollectionSoyContextsMap = new HashMap<String, List>();
        HashMap<String, FragmentRenderer> fragmentCollectionFragmentRenderers = new HashMap<String, FragmentRenderer>();
        List fragmentRenderers = this._fragmentRendererTracker.getFragmentRenderers(type);
        for (FragmentRenderer fragmentRenderer : fragmentRenderers) {
            if (!fragmentRenderer.isSelectable(this.request)) continue;
            SoyContext dynamicFragmentSoyContext = SoyContextFactoryUtil.createSoyContext();
            dynamicFragmentSoyContext.put("fragmentEntryKey", (Object)fragmentRenderer.getKey()).put("imagePreviewURL", (Object)fragmentRenderer.getImagePreviewURL(this.request)).put("name", (Object)fragmentRenderer.getLabel(this.themeDisplay.getLocale()));
            List fragmentCollectionSoyContexts = (List)fragmentCollectionSoyContextsMap.get(fragmentRenderer.getCollectionKey());
            if (fragmentCollectionSoyContexts == null) {
                List dynamicFragmentSoyContexts = fragmentCollectionSoyContextsMap.computeIfAbsent(fragmentRenderer.getCollectionKey(), key -> new ArrayList());
                dynamicFragmentSoyContexts.add(dynamicFragmentSoyContext);
                fragmentCollectionSoyContextsMap.put(fragmentRenderer.getCollectionKey(), dynamicFragmentSoyContexts);
                fragmentCollectionFragmentRenderers.put(fragmentRenderer.getCollectionKey(), fragmentRenderer);
                continue;
            }
            fragmentCollectionSoyContexts.add(dynamicFragmentSoyContext);
        }
        for (Map.Entry entry : fragmentCollectionSoyContextsMap.entrySet()) {
            FragmentRenderer fragmentRenderer = (FragmentRenderer)fragmentCollectionFragmentRenderers.get(entry.getKey());
            SoyContext soyContext = SoyContextFactoryUtil.createSoyContext();
            soyContext.put("fragmentCollectionId", entry.getKey()).put("fragmentEntries", entry.getValue()).put("name", (Object)LanguageUtil.get((ResourceBundle)ResourceBundleUtil.getBundle((Locale)this.themeDisplay.getLocale(), fragmentRenderer.getClass()), (String)("fragment.collection.label." + (String)entry.getKey())));
            soyContexts.add(soyContext);
        }
        return soyContexts;
    }

    private List<SoyContext> _getFragmentCollectionContributorSoyContexts(int type) {
        ArrayList<SoyContext> soyContexts = new ArrayList<SoyContext>();
        List fragmentCollectionContributors = this._fragmentCollectionContributorTracker.getFragmentCollectionContributors();
        for (FragmentCollectionContributor fragmentCollectionContributor : fragmentCollectionContributors) {
            List fragmentEntries = fragmentCollectionContributor.getFragmentEntries(type);
            if (ListUtil.isEmpty((List)fragmentEntries)) continue;
            SoyContext soyContext = SoyContextFactoryUtil.createSoyContext();
            soyContext.put("fragmentCollectionId", (Object)fragmentCollectionContributor.getFragmentCollectionKey()).put("fragmentEntries", this._getFragmentEntriesSoyContexts(fragmentEntries)).put("name", (Object)fragmentCollectionContributor.getName());
            soyContexts.add(soyContext);
        }
        return soyContexts;
    }

    private List<SoyContext> _getFragmentCollectionsSoyContexts(int type) {
        List<SoyContext> soyContexts = this._getFragmentCollectionContributorSoyContexts(type);
        List fragmentCollections = FragmentCollectionServiceUtil.getFragmentCollections((long)this.getGroupId());
        for (FragmentCollection fragmentCollection : fragmentCollections) {
            List fragmentEntries = FragmentEntryServiceUtil.getFragmentEntriesByType((long)this.getGroupId(), (long)fragmentCollection.getFragmentCollectionId(), (int)type, (int)0);
            if (ListUtil.isEmpty((List)fragmentEntries)) continue;
            SoyContext soyContext = SoyContextFactoryUtil.createSoyContext();
            soyContext.put("fragmentCollectionId", (Object)fragmentCollection.getFragmentCollectionId()).put("fragmentEntries", this._getFragmentEntriesSoyContexts(fragmentEntries)).put("name", (Object)fragmentCollection.getName());
            soyContexts.add(soyContext);
        }
        soyContexts.addAll(this._getDynamicFragmentsSoyContexts(type));
        return soyContexts;
    }

    private List<SoyContext> _getFragmentEntriesSoyContexts(List<FragmentEntry> fragmentEntries) {
        ArrayList<SoyContext> soyContexts = new ArrayList<SoyContext>();
        for (FragmentEntry fragmentEntry : fragmentEntries) {
            SoyContext soyContext = SoyContextFactoryUtil.createSoyContext();
            soyContext.put("fragmentEntryKey", (Object)fragmentEntry.getFragmentEntryKey()).put("imagePreviewURL", (Object)fragmentEntry.getImagePreviewURL(this.themeDisplay)).put("name", (Object)fragmentEntry.getName());
            soyContexts.add(soyContext);
        }
        return soyContexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SoyContext _getFragmentEntryLinksSoyContext() throws PortalException {
        if (this._soyContextFragmentEntryLinksSoyContext != null) {
            return this._soyContextFragmentEntryLinksSoyContext;
        }
        SoyContext soyContexts = SoyContextFactoryUtil.createSoyContext();
        List fragmentEntryLinks = FragmentEntryLinkLocalServiceUtil.getFragmentEntryLinks((long)this.getGroupId(), (long)this.classNameId, (long)this.classPK);
        boolean isolated = this.themeDisplay.isIsolated();
        this.themeDisplay.setIsolated(true);
        long[] segmentsExperienceIds = new long[]{0L};
        try {
            for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
                FragmentEntry fragmentEntry = FragmentEntryServiceUtil.fetchFragmentEntry((long)fragmentEntryLink.getFragmentEntryId());
                SoyContext soyContext = SoyContextFactoryUtil.createSoyContext();
                DefaultFragmentRendererContext fragmentRendererContext = new DefaultFragmentRendererContext(fragmentEntryLink);
                fragmentRendererContext.setLocale(this.themeDisplay.getLocale());
                fragmentRendererContext.setMode("EDIT");
                fragmentRendererContext.setSegmentsExperienceIds(segmentsExperienceIds);
                String content = this._fragmentRendererController.render((FragmentRendererContext)fragmentRendererContext, this.request, PortalUtil.getHttpServletResponse((PortletResponse)this._renderResponse));
                JSONObject editableValuesJSONObject = JSONFactoryUtil.createJSONObject((String)fragmentEntryLink.getEditableValues());
                boolean error = false;
                if (SessionErrors.contains((HttpServletRequest)this.request, (String)"fragmentEntryInvalidContent")) {
                    error = true;
                    SessionErrors.clear((HttpServletRequest)this.request);
                }
                soyContext.putHTML("content", content).put("editableValues", (Object)editableValuesJSONObject).put("error", (Object)error).put("fragmentEntryLinkId", (Object)String.valueOf(fragmentEntryLink.getFragmentEntryLinkId())).putAll((Map)this._getFragmentEntrySoyContext(fragmentEntryLink, fragmentEntry, content));
                soyContexts.put(String.valueOf(fragmentEntryLink.getFragmentEntryLinkId()), (Object)soyContext);
            }
        }
        finally {
            this.themeDisplay.setIsolated(isolated);
        }
        this._soyContextFragmentEntryLinksSoyContext = soyContexts;
        return this._soyContextFragmentEntryLinksSoyContext;
    }

    private SoyContext _getFragmentEntrySoyContext(FragmentEntryLink fragmentEntryLink, FragmentEntry fragmentEntry, String content) {
        SoyContext soyContext;
        if (fragmentEntry != null) {
            SoyContext soyContext2 = SoyContextFactoryUtil.createSoyContext();
            soyContext2.put("fragmentEntryId", (Object)fragmentEntry.getFragmentEntryId()).put("name", (Object)fragmentEntry.getName());
            return soyContext2;
        }
        String rendererKey = fragmentEntryLink.getRendererKey();
        if (Validator.isNotNull((String)rendererKey)) {
            soyContext = this._getContributedFragmentEntrySoyContext(rendererKey);
            if (!soyContext.isEmpty()) {
                return soyContext;
            }
            soyContext = SoyContextFactoryUtil.createSoyContext();
            FragmentRenderer fragmentRenderer = this._fragmentRendererTracker.getFragmentRenderer(fragmentEntryLink.getRendererKey());
            if (fragmentRenderer != null) {
                soyContext.put("fragmentEntryId", (Object)0).put("name", (Object)fragmentRenderer.getLabel(this.themeDisplay.getLocale()));
            }
            if (!soyContext.isEmpty()) {
                return soyContext;
            }
        }
        soyContext = SoyContextFactoryUtil.createSoyContext();
        soyContext.put("fragmentEntryId", (Object)0).put("name", (Object)"");
        String portletId = this._getPortletId(content);
        PortletConfig portletConfig = PortletConfigFactoryUtil.get((String)portletId);
        if (portletConfig == null) {
            return soyContext;
        }
        soyContext.put("name", (Object)PortalUtil.getPortletTitle((String)portletId, (Locale)this.themeDisplay.getLocale())).put("portletId", (Object)portletId);
        return soyContext;
    }

    private ItemSelectorCriterion _getImageItemSelectorCriterion() {
        if (this._imageItemSelectorCriterion != null) {
            return this._imageItemSelectorCriterion;
        }
        ImageItemSelectorCriterion itemSelectorCriterion = new ImageItemSelectorCriterion();
        itemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new DownloadURLItemSelectorReturnType()});
        this._imageItemSelectorCriterion = itemSelectorCriterion;
        return this._imageItemSelectorCriterion;
    }

    private String _getItemSelectorURL() {
        PortletURL itemSelectorURL = this._itemSelector.getItemSelectorURL(RequestBackedPortletURLFactoryUtil.create((HttpServletRequest)this.request), this._renderResponse.getNamespace() + "selectImage", new ItemSelectorCriterion[]{this._getImageItemSelectorCriterion(), this._getURLItemSelectorCriterion()});
        return itemSelectorURL.toString();
    }

    private String _getLayoutData() throws PortalException {
        if (this._layoutData != null) {
            return this._layoutData;
        }
        LayoutPageTemplateStructure layoutPageTemplateStructure = LayoutPageTemplateStructureLocalServiceUtil.fetchLayoutPageTemplateStructure((long)this.themeDisplay.getScopeGroupId(), (long)this.classNameId, (long)this.classPK, (boolean)true);
        this._layoutData = layoutPageTemplateStructure.getData(0L);
        return this._layoutData;
    }

    private String _getLookAndFeelURL() {
        PortletURL lookAndFeelURL = PortalUtil.getControlPanelPortletURL((HttpServletRequest)this.request, (String)"com_liferay_layout_admin_web_portlet_GroupPagesPortlet", (String)"RENDER_PHASE");
        lookAndFeelURL.setParameter("mvcRenderCommandName", "/layout/edit_layout");
        lookAndFeelURL.setParameter("redirect", this.themeDisplay.getURLCurrent());
        lookAndFeelURL.setParameter("backURL", this.themeDisplay.getURLCurrent());
        Layout layout = this.themeDisplay.getLayout();
        lookAndFeelURL.setParameter("groupId", String.valueOf(layout.getGroupId()));
        lookAndFeelURL.setParameter("selPlid", String.valueOf(layout.getPlid()));
        lookAndFeelURL.setParameter("privateLayout", String.valueOf(layout.isPrivateLayout()));
        return lookAndFeelURL.toString();
    }

    private Set<SoyContext> _getMappedAssetEntriesSoyContexts() throws Exception {
        HashSet<SoyContext> mappedAssetEntriesSoyContexts = new HashSet<SoyContext>();
        ArrayList<Long> mappedClassPKs = new ArrayList<Long>();
        List fragmentEntryLinks = FragmentEntryLinkLocalServiceUtil.getFragmentEntryLinks((long)this.getGroupId(), (long)this.classNameId, (long)this.classPK);
        for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
            JSONObject editableValuesJSONObject = JSONFactoryUtil.createJSONObject((String)fragmentEntryLink.getEditableValues());
            Iterator keysIterator = editableValuesJSONObject.keys();
            while (keysIterator.hasNext()) {
                String key = (String)keysIterator.next();
                JSONObject editableProcessorJSONObject = editableValuesJSONObject.getJSONObject(key);
                if (editableProcessorJSONObject == null) continue;
                Iterator editableKeysIterator = editableProcessorJSONObject.keys();
                while (editableKeysIterator.hasNext()) {
                    long classPK;
                    String editableKey = (String)editableKeysIterator.next();
                    JSONObject editableJSONObject = editableProcessorJSONObject.getJSONObject(editableKey);
                    if (!editableJSONObject.has("classNameId") || !editableJSONObject.has("classPK") || !editableJSONObject.has("fieldId") || mappedClassPKs.contains(classPK = editableJSONObject.getLong("classPK"))) continue;
                    mappedClassPKs.add(classPK);
                    long classNameId = editableJSONObject.getLong("classNameId");
                    AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchEntry((long)classNameId, (long)classPK);
                    if (assetEntry == null) continue;
                    SoyContext mappedAssetEntrySoyContext = SoyContextFactoryUtil.createSoyContext();
                    mappedAssetEntrySoyContext.put("classNameId", (Object)classNameId).put("classPK", (Object)classPK).put("title", (Object)assetEntry.getTitle(this.themeDisplay.getLocale()));
                    mappedAssetEntriesSoyContexts.add(mappedAssetEntrySoyContext);
                }
            }
        }
        return mappedAssetEntriesSoyContexts;
    }

    private String _getPortletCategoryTitle(PortletCategory portletCategory) {
        String title = LanguageUtil.get((HttpServletRequest)this.request, (String)portletCategory.getName());
        if (Validator.isNotNull((String)title)) {
            return title;
        }
        for (String portletId : PortletCategoryUtil.getFirstChildPortletIds((PortletCategory)portletCategory)) {
            PortletApp portletApp;
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.themeDisplay.getCompanyId(), (String)portletId);
            if (portlet == null || !(portletApp = portlet.getPortletApp()).isWARFile()) continue;
            PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)this.request.getServletContext());
            ResourceBundle portletResourceBundle = portletConfig.getResourceBundle(this.themeDisplay.getLocale());
            return ResourceBundleUtil.getString((ResourceBundle)portletResourceBundle, (String)portletCategory.getName());
        }
        return "";
    }

    private String _getPortletId(String content) {
        Document document = Jsoup.parse((String)content);
        Elements elements = document.getElementsByAttributeValueStarting("id", "portlet_");
        if (elements.size() != 1) {
            return "";
        }
        Element element = (Element)elements.get(0);
        String id = element.id();
        return PortletIdCodec.decodePortletName((String)id.substring(8));
    }

    private List<SoyContext> _getPortletsSoyContexts(PortletCategory portletCategory) {
        Set portletIds = portletCategory.getPortletIds();
        Stream stream = portletIds.stream();
        HttpSession session = this.request.getSession();
        ServletContext servletContext = session.getServletContext();
        return stream.map(portletId -> PortletLocalServiceUtil.getPortletById((long)this.themeDisplay.getCompanyId(), (String)portletId)).filter(portlet -> {
            if (portlet == null) {
                return false;
            }
            try {
                return PortletPermissionUtil.contains((PermissionChecker)this.themeDisplay.getPermissionChecker(), (Layout)this.themeDisplay.getLayout(), (Portlet)portlet, (String)"ADD_TO_PAGE");
            }
            catch (PortalException pe) {
                _log.error((Object)("Unable to check portlet permissions for " + portlet.getPortletId()), (Throwable)pe);
                return false;
            }
        }).sorted((Comparator<Portlet>)new PortletTitleComparator(servletContext, this.themeDisplay.getLocale())).map(portlet -> {
            SoyContext portletSoyContext = SoyContextFactoryUtil.createSoyContext();
            portletSoyContext.put("instanceable", (Object)portlet.isInstanceable()).put("portletId", (Object)portlet.getPortletId()).put("title", (Object)PortalUtil.getPortletTitle((Portlet)portlet, (ServletContext)servletContext, (Locale)this.themeDisplay.getLocale())).put("used", (Object)this._isUsed((Portlet)portlet, this.themeDisplay.getPlid()));
            return portletSoyContext;
        }).collect(Collectors.toList());
    }

    private String _getRedirect() {
        if (Validator.isNotNull((String)this._redirect)) {
            return this._redirect;
        }
        this._redirect = ParamUtil.getString((HttpServletRequest)this.request, (String)"redirect");
        if (Validator.isNull((String)this._redirect)) {
            this._redirect = ParamUtil.getString((HttpServletRequest)PortalUtil.getOriginalServletRequest((HttpServletRequest)this.request), (String)"p_l_back_url", (String)this.themeDisplay.getURLCurrent());
        }
        return this._redirect;
    }

    private String[] _getThemeColorsCssClasses() {
        Theme theme = this.themeDisplay.getTheme();
        String colorPalette = theme.getSetting("color-palette");
        if (Validator.isNotNull((String)colorPalette)) {
            return StringUtil.split((String)colorPalette);
        }
        return new String[]{"primary", "success", "danger", "warning", "info", "dark", "gray-dark", "secondary", "light", "lighter", "white"};
    }

    private ItemSelectorCriterion _getURLItemSelectorCriterion() {
        if (this._urlItemSelectorCriterion != null) {
            return this._urlItemSelectorCriterion;
        }
        URLItemSelectorCriterion itemSelectorCriterion = new URLItemSelectorCriterion();
        itemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new URLItemSelectorReturnType()});
        this._urlItemSelectorCriterion = itemSelectorCriterion;
        return this._urlItemSelectorCriterion;
    }

    private List<SoyContext> _getWidgetCategoriesSoyContexts(PortletCategory portletCategory) {
        Collection portletCategories = portletCategory.getCategories();
        Stream stream = portletCategories.stream();
        return stream.sorted(new PortletCategoryComparator(this.themeDisplay.getLocale())).filter(category -> !category.isHidden()).map(category -> {
            SoyContext categoryContext = SoyContextFactoryUtil.createSoyContext();
            categoryContext.put("categories", this._getWidgetCategoriesSoyContexts((PortletCategory)category)).put("path", (Object)StringUtil.replace((String)category.getPath(), (String[])new String[]{"/", "."}, (String[])new String[]{"-", "-"})).put("portlets", this._getPortletsSoyContexts((PortletCategory)category)).put("title", (Object)this._getPortletCategoryTitle((PortletCategory)category));
            return categoryContext;
        }).collect(Collectors.toList());
    }

    private List<SoyContext> _getWidgetsSoyContexts() throws Exception {
        PortletCategory portletCategory = (PortletCategory)WebAppPool.get((Long)this.themeDisplay.getCompanyId(), (String)"PORTLET_CATEGORY");
        portletCategory = PortletCategoryUtil.getRelevantPortletCategory((PermissionChecker)this.themeDisplay.getPermissionChecker(), (long)this.themeDisplay.getCompanyId(), (Layout)this.themeDisplay.getLayout(), (PortletCategory)portletCategory, (LayoutTypePortlet)this.themeDisplay.getLayoutTypePortlet());
        return this._getWidgetCategoriesSoyContexts(portletCategory);
    }

    private boolean _isUsed(Portlet portlet, long plid) {
        if (portlet.isInstanceable()) {
            return false;
        }
        long count = PortletPreferencesLocalServiceUtil.getPortletPreferencesCount((int)3, (long)plid, (String)portlet.getPortletId());
        return count > 0L;
    }
}

