Liferay.Loader.define('layout-content-page-editor-web$lodash-es@4.17.15/size', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseKeys from './_baseKeys.js';
  import getTag from './_getTag.js';
  import isArrayLike from './isArrayLike.js';
  import isString from './isString.js';
  import stringSize from './_stringSize.js';

  /** `Object#toString` result references. */
  var mapTag = '[object Map]',
      setTag = '[object Set]';

  /**
   * Gets the size of `collection` by returning its length for array-like
   * values or the number of own enumerable string keyed properties for objects.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Collection
   * @param {Array|Object|string} collection The collection to inspect.
   * @returns {number} Returns the collection size.
   * @example
   *
   * _.size([1, 2, 3]);
   * // => 3
   *
   * _.size({ 'a': 1, 'b': 2 });
   * // => 2
   *
   * _.size('pebbles');
   * // => 7
   */
  function size(collection) {
    if (collection == null) {
      return 0;
    }
    if (isArrayLike(collection)) {
      return isString(collection) ? stringSize(collection) : collection.length;
    }
    var tag = getTag(collection);
    if (tag == mapTag || tag == setTag) {
      return collection.size;
    }
    return baseKeys(collection).length;
  }

  export default size;
});
//# sourceMappingURL=size.js.map