Liferay.Loader.define('layout-content-page-editor-web$lodash-es@4.17.15/isBoolean', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseGetTag from './_baseGetTag.js';
  import isObjectLike from './isObjectLike.js';

  /** `Object#toString` result references. */
  var boolTag = '[object Boolean]';

  /**
   * Checks if `value` is classified as a boolean primitive or object.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a boolean, else `false`.
   * @example
   *
   * _.isBoolean(false);
   * // => true
   *
   * _.isBoolean(null);
   * // => false
   */
  function isBoolean(value) {
    return value === true || value === false || isObjectLike(value) && baseGetTag(value) == boolTag;
  }

  export default isBoolean;
});
//# sourceMappingURL=isBoolean.js.map