'use strict';

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 */

Liferay.Loader.define('layout-content-page-editor-web$fbjs@0.8.17/lib/containsNode', ['module', 'exports', 'require', './isTextNode'], function (module, exports, require) {
  var define = undefined;
  var isTextNode = require('./isTextNode');

  /*eslint-disable no-bitwise */

  /**
   * Checks if a given DOM node contains or is another DOM node.
   */
  function containsNode(outerNode, innerNode) {
    if (!outerNode || !innerNode) {
      return false;
    } else if (outerNode === innerNode) {
      return true;
    } else if (isTextNode(outerNode)) {
      return false;
    } else if (isTextNode(innerNode)) {
      return containsNode(outerNode, innerNode.parentNode);
    } else if ('contains' in outerNode) {
      return outerNode.contains(innerNode);
    } else if (outerNode.compareDocumentPosition) {
      return !!(outerNode.compareDocumentPosition(innerNode) & 16);
    } else {
      return false;
    }
  }

  module.exports = containsNode;
});
//# sourceMappingURL=containsNode.js.map