Liferay.Loader.define("layout-content-page-editor-web@1.0.139/js/store/ConnectedComponent.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state', 'frontend-js-react-web$react', './StoreContext.es', './state.es', './store.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.getConnectedReactComponent = getConnectedReactComponent;
  exports["default"] = exports.getConnectedComponent = void 0;

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _StoreContext = _interopRequireDefault(require("./StoreContext.es"));

  var _state = _interopRequireDefault(require("./state.es"));

  var _store = require("./store.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }return target;
    };return _extends.apply(this, arguments);
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * HOC that returns a component that connects automatically
   * to a Store parameter.
   * @param {Component} Component
   * @param {string[]} [properties=[]] List of properties to be fetched from store
   * @return {Component}
   */
  var getConnectedComponent = function getConnectedComponent(Component, properties) {
    /**
     * ConnectedComponent
     */
    var ConnectedComponent = /*#__PURE__*/function (_Component) {
      _inherits(ConnectedComponent, _Component);

      /**
       * @inheritdoc
       * @param {object} props
       * @param  {...any} ...args
       */
      function ConnectedComponent(props) {
        var _getPrototypeOf2;

        var _this;

        _classCallCheck(this, ConnectedComponent);

        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }

        _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(ConnectedComponent)).call.apply(_getPrototypeOf2, [this, props].concat(args)));

        _this.on('storeChanged', function (change) {
          var newStore = change.newVal;
          var prevStore = change.prevVal;

          if (newStore !== prevStore) {
            (0, _store.disconnect)(_assertThisInitialized(_this));

            if (newStore instanceof _store.Store) {
              (0, _store.connect)(_assertThisInitialized(_this), newStore);
            }
          }
        });

        _this.on('disposed', function () {
          (0, _store.disconnect)(_assertThisInitialized(_this));
        });

        if (props.store instanceof _store.Store) {
          (0, _store.connect)(_assertThisInitialized(_this), props.store);
        }

        return _this;
      }

      return ConnectedComponent;
    }(Component);
    /**
     * Connected component state
     */

    ConnectedComponent.STATE = {
      store: _metalState.Config.instanceOf(_store.Store).value(null)
    };
    properties.forEach(function (property) {
      try {
        ConnectedComponent.STATE[property] = _state["default"][property].internal();
      } catch (e) {
        throw new Error("".concat(property, " is not available from ").concat(Component.name));
      }
    });
    return ConnectedComponent;
  };
  /**
   * Second order function to produce a Connected Component Wrapper
   * @param {Function} mapStateToProps - Recieves the state and returns mapped version of it ready for consumption by the Wrapped Component
   * @param {Function} mapDispatchToProps - Recieves the dispatch and returns a set of component props that use it to call the modify the state tree
   * @returns {object}
   */

  exports.getConnectedComponent = getConnectedComponent;

  function getConnectedReactComponent(mapStateToProps, mapDispatchToProps) {
    /**
     *
     * @param {React.Component} WrappedComponent - The Component to connect to the store
     * @returns {React.Component} - Wrapper Connected Component that propagates every store change mapped to the component
     */
    return function _getConnectedWrapperComponent(WrappedComponent) {
      return function ConnectedWrapperComponent(props) {
        var store = (0, _react.useContext)(_StoreContext["default"]);

        var _useState = (0, _react.useState)(store ? store.getState() : {}),
            _useState2 = _slicedToArray(_useState, 2),
            storeState = _useState2[0],
            setStoreState = _useState2[1];

        (0, _react.useEffect)(function () {
          if (store) {
            var handleStoreChange = function handleStoreChange() {
              return setStoreState(store.getState());
            };

            var subscriber = store.on('change', handleStoreChange);
            return function () {
              return subscriber.removeListener();
            };
          }
        }, [store]);
        return store ? _react["default"].createElement(WrappedComponent, _extends({}, props, mapStateToProps(storeState, props), mapDispatchToProps(store.dispatch, props))) : null;
      };
    };
  }

  var _default = getConnectedComponent;
  exports["default"] = _default;
  //# sourceMappingURL=ConnectedComponent.es.js.map
});
//# sourceMappingURL=ConnectedComponent.es.js.map