Liferay.Loader.define("layout-content-page-editor-web@1.0.139/js/reducers/reducers.es", ['module', 'exports', 'require', '../actions/actions.es', './changes.es', './createSetValueReducer.es', './fragments.es', './mapping.es', './placeholders.es', './portlets.es', './rows.es', './segmentsExperiences.es', './widgets.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.reducer = reducer;
  exports["default"] = exports.reducers = void 0;

  var _actions = require("../actions/actions.es");

  var _changes = require("./changes.es");

  var _createSetValueReducer = require("./createSetValueReducer.es");

  var _fragments = require("./fragments.es");

  var _mapping = require("./mapping.es");

  var _placeholders = require("./placeholders.es");

  var _portlets = require("./portlets.es");

  var _rows = require("./rows.es");

  var _segmentsExperiences = require("./segmentsExperiences.es");

  var _widgets = require("./widgets.es");

  var _reducers;

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  /**
   * List of reducers
   * @type {object}
   */
  var reducers = (_reducers = {}, _defineProperty(_reducers, _actions.ADD_FRAGMENT_ENTRY_LINK, _fragments.addFragmentEntryLinkReducer), _defineProperty(_reducers, _actions.ADD_MAPPED_ASSET_ENTRY, _mapping.addMappingAssetEntry), _defineProperty(_reducers, _actions.ADD_PORTLET, _portlets.addPortletReducer), _defineProperty(_reducers, _actions.ADD_ROW, _rows.addRowReducer), _defineProperty(_reducers, _actions.CHANGE_LANGUAGE_ID, (0, _createSetValueReducer.createSetValueReducer)('languageId')), _defineProperty(_reducers, _actions.CLEAR_ACTIVE_ITEM, _placeholders.updateActiveItemReducer), _defineProperty(_reducers, _actions.CLEAR_DROP_TARGET, _placeholders.updateDropTargetReducer), _defineProperty(_reducers, _actions.CLEAR_HOVERED_ITEM, _placeholders.updateHoveredItemReducer), _defineProperty(_reducers, _actions.CREATE_SEGMENTS_EXPERIENCE, _segmentsExperiences.createSegmentsExperienceReducer), _defineProperty(_reducers, _actions.DELETE_FRAGMENT_ENTRY_LINK_COMMENT, _fragments.deleteFragmentEntryLinkCommentReducer), _defineProperty(_reducers, _actions.DELETE_SEGMENTS_EXPERIENCE, _segmentsExperiences.deleteSegmentsExperienceReducer), _defineProperty(_reducers, _actions.DUPLICATE_FRAGMENT_ENTRY_LINK, _fragments.duplicateFragmentEntryLinkReducer), _defineProperty(_reducers, _actions.DUPLICATE_SEGMENTS_EXPERIENCE, _segmentsExperiences.duplicateSegmentsExperienceReducer), _defineProperty(_reducers, _actions.EDIT_SEGMENTS_EXPERIENCE, _segmentsExperiences.editSegmentsExperienceReducer), _defineProperty(_reducers, _actions.MOVE_FRAGMENT_ENTRY_LINK, _fragments.moveFragmentEntryLinkReducer), _defineProperty(_reducers, _actions.MOVE_ROW, _rows.moveRowReducer), _defineProperty(_reducers, _actions.REMOVE_FRAGMENT_ENTRY_LINK, _fragments.removeFragmentEntryLinkReducer), _defineProperty(_reducers, _actions.REMOVE_ROW, _rows.removeRowReducer), _defineProperty(_reducers, _actions.SELECT_SEGMENTS_EXPERIENCE, _segmentsExperiences.selectSegmentsExperienceReducer), _defineProperty(_reducers, _actions.TOGGLE_SHOW_RESOLVED_COMMENTS, _fragments.toggleShowResolvedCommentsReducer), _defineProperty(_reducers, _actions.UPDATE_ACTIVE_ITEM, _placeholders.updateActiveItemReducer), _defineProperty(_reducers, _actions.UPDATE_CONFIG_ATTRIBUTES, _fragments.updateFragmentEntryLinkConfigReducer), _defineProperty(_reducers, _actions.UPDATE_DROP_TARGET, _placeholders.updateDropTargetReducer), _defineProperty(_reducers, _actions.UPDATE_EDITABLE_VALUE_ERROR, _fragments.updateEditableValueReducer), _defineProperty(_reducers, _actions.UPDATE_EDITABLE_VALUE_LOADING, _fragments.updateEditableValueReducer), _defineProperty(_reducers, _actions.UPDATE_FRAGMENT_ENTRY_LINK_COMMENT, _fragments.updateFragmentEntryLinkCommentReducer), _defineProperty(_reducers, _actions.UPDATE_FRAGMENT_ENTRY_LINK_COMMENT_REPLY, _fragments.updateFragmentEntryLinkCommentReducer), _defineProperty(_reducers, _actions.UPDATE_FRAGMENT_ENTRY_LINK_CONTENT, _fragments.updateFragmentEntryLinkContentReducer), _defineProperty(_reducers, _actions.UPDATE_FRAGMENT_ENTRY_LINK_SEARCH_OPTIONS, _fragments.updateFragmentEntryLinkSearchOptionsReducer), _defineProperty(_reducers, _actions.UPDATE_HOVERED_ITEM, _placeholders.updateHoveredItemReducer), _defineProperty(_reducers, _actions.UPDATE_LAST_SAVE_DATE, _changes.saveChangesReducer), _defineProperty(_reducers, _actions.UPDATE_PAGE_CONTENTS, (0, _createSetValueReducer.createSetValueReducer)('pageContents')), _defineProperty(_reducers, _actions.UPDATE_ROW_COLUMNS_ERROR, (0, _createSetValueReducer.createSetValueReducer)('layoutData')), _defineProperty(_reducers, _actions.UPDATE_ROW_COLUMNS_LOADING, (0, _createSetValueReducer.createSetValueReducer)('layoutData')), _defineProperty(_reducers, _actions.UPDATE_ROW_COLUMNS_NUMBER_SUCCESS, _rows.updateRowColumnsNumberReducer), _defineProperty(_reducers, _actions.UPDATE_ROW_CONFIG, _rows.updateRowConfigReducer), _defineProperty(_reducers, _actions.UPDATE_SAVING_CHANGES_STATUS, _changes.saveChangesReducer), _defineProperty(_reducers, _actions.UPDATE_SEGMENTS_EXPERIENCE_PRIORITY, _segmentsExperiences.updateSegmentsExperiencePriorityReducer), _defineProperty(_reducers, _actions.UPDATE_SELECTED_SIDEBAR_PANEL_ID, (0, _createSetValueReducer.createSetValueReducer)('selectedSidebarPanelId')), _defineProperty(_reducers, _actions.UPDATE_WIDGETS, _widgets.updateWigetsReducer), _reducers);
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.type
   * @return {object}
   */

  exports.reducers = reducers;

  function reducer(state, action) {
    var nextState = state;
    var selectedReducer = reducers[action.type];

    if (selectedReducer) {
      nextState = selectedReducer(nextState, action);
    }

    return nextState;
  }

  var _default = reducer;
  exports["default"] = _default;
  //# sourceMappingURL=reducers.es.js.map
});
//# sourceMappingURL=reducers.es.js.map