Liferay.Loader.define("layout-content-page-editor-web@1.0.139/js/reducers/createSetValueReducer.es", ['module', 'exports', 'require', '../utils/FragmentsEditorUpdateUtils.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.createSetValueReducer = createSetValueReducer;

  var _FragmentsEditorUpdateUtils = require("../utils/FragmentsEditorUpdateUtils.es");

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */

  /**
   * @param {string|string[]} keyPath
   * @return {function}
   */
  function createSetValueReducer(keyPath) {
    var path = Array.isArray(keyPath) ? keyPath : [keyPath];
    /**
     * @type {function}
     * @param {object} state
     * @param {object} action
     * @param {any} [action.value]
     */

    return function (state, action) {
      var nextState = state;

      if ('value' in action) {
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, path, action.value);
      } else {
        nextState = (0, _FragmentsEditorUpdateUtils.deleteIn)(nextState, path);
      }

      return nextState;
    };
  }
  //# sourceMappingURL=createSetValueReducer.es.js.map
});
//# sourceMappingURL=createSetValueReducer.es.js.map