Liferay.Loader.define("layout-content-page-editor-web@1.0.139/js/components/sidebar/comments/ResolvedCommentsToggle.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/form', 'frontend-js-react-web$react', '../../../actions/toggleShowResolvedComments.es', '../../../store/hooks/useDispatch.es', '../../../store/hooks/useSelector.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.ResolvedCommentsToggle = void 0;

  var _form = require("@frontend-taglib-clay$clayui/form");

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _toggleShowResolvedComments = require("../../../actions/toggleShowResolvedComments.es");

  var _useDispatch = _interopRequireDefault(require("../../../store/hooks/useDispatch.es"));

  var _useSelector = _interopRequireDefault(require("../../../store/hooks/useSelector.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var ResolvedCommentsToggle = function ResolvedCommentsToggle() {
    var dispatch = (0, _useDispatch["default"])();
    var showResolvedComments = (0, _useSelector["default"])(function (state) {
      return state.showResolvedComments;
    });
    var hasResolvedComments = (0, _useSelector["default"])(function (state) {
      return Object.values(state.fragmentEntryLinks).some(function (fragmentEntryLink) {
        return (fragmentEntryLink.comments || []).some(function (comment) {
          return comment.resolved;
        });
      });
    });
    return _react["default"].createElement("div", {
      className: "pb-3 px-3"
    }, _react["default"].createElement(_form.ClayCheckbox, {
      checked: showResolvedComments,
      disabled: !showResolvedComments && !hasResolvedComments,
      label: Liferay.Language.get('show-resolved-comments'),
      onClick: function onClick() {
        return dispatch((0, _toggleShowResolvedComments.toggleShowResolvedComments)());
      }
    }));
  };

  exports.ResolvedCommentsToggle = ResolvedCommentsToggle;
  var _default = ResolvedCommentsToggle;
  exports["default"] = _default;
  //# sourceMappingURL=ResolvedCommentsToggle.es.js.map
});
//# sourceMappingURL=ResolvedCommentsToggle.es.js.map