Liferay.Loader.define("layout-content-page-editor-web@1.0.139/js/components/fragment_processors/EditableRichTextFragmentProcessor.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-events', '../../utils/constants'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.destroy = destroy;
  exports.getActiveEditableElement = getActiveEditableElement;
  exports.getFloatingToolbarButtons = getFloatingToolbarButtons;
  exports.init = init;
  exports.render = render;
  exports["default"] = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  var _metal = require("frontend-js-metal-web$metal");

  var _metalEvents = require("frontend-js-metal-web$metal-events");

  var _constants = require("../../utils/constants");

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var KEY_ENTER = 13;
  var KEY_SHIFT_ENTER = (window.CKEDITOR ? window.CKEDITOR.SHIFT : 0) + KEY_ENTER;
  var _destroyedCallback = null;
  var _editableElement = null;
  var _editor = null;
  var _editorEventHandler = null;
  /**
   * Destroys, if any, an existing instance of AlloyEditor.
   */

  function destroy() {
    if (_editor) {
      _editorEventHandler.removeAllListeners();

      _editorEventHandler.dispose();

      var editorData = _editor.get('nativeEditor').getData();

      _editableElement.innerHTML = editorData;

      _editor.destroy();

      _editableElement = null;
      _editor = null;
      _editorEventHandler = null;

      _destroyedCallback();

      _destroyedCallback = null;
    }
  }
  /**
   * @param {object} editableValues
   * @return {object[]} Floating toolbar panels
   */

  function getFloatingToolbarButtons(editableValues) {
    var buttons = [];

    var editButton = _objectSpread({}, _constants.FLOATING_TOOLBAR_BUTTONS.edit);

    if (editableValues.mappedField || editableValues.fieldId) {
      editButton.cssClass = 'disabled fragments-editor__floating-toolbar--disabled fragments-editor__floating-toolbar--mapped-field';
    }

    buttons.push(editButton);

    var mapButton = _objectSpread({}, _constants.FLOATING_TOOLBAR_BUTTONS.map);

    if (editableValues.fieldId || editableValues.mappedField) {
      mapButton.cssClass = 'fragments-editor__floating-toolbar--mapped-field';
    }

    buttons.push(mapButton);
    return buttons;
  }
  /**
   * Returns the existing editable element or null.
   * @returns {HTMLElement|null}
   */

  function getActiveEditableElement() {
    return _editableElement;
  }
  /**
   * Creates an instance of AlloyEditor and destroys the existing one if any.
   * @param {HTMLElement} editableElement
   * @param {string} fragmentEntryLinkId
   * @param {string} portletNamespace
   * @param {Object} options
   * @param {function} changedCallback
   * @param {function} destroyedCallback
   */

  function init(editableElement, fragmentEntryLinkId, portletNamespace, options, changedCallback, destroyedCallback, event, type) {
    destroy();
    var defaultEditorConfiguration = options.defaultEditorConfiguration;
    var editableContent = editableElement.innerHTML;
    var wrapper = document.createElement('div');
    wrapper.dataset.lfrEditableId = editableElement.id;
    wrapper.innerHTML = editableContent;
    var editorName = "".concat(portletNamespace, "FragmentEntryLinkEditable_").concat(editableElement.id);
    wrapper.setAttribute('id', editorName);
    wrapper.setAttribute('name', editorName);
    editableElement.innerHTML = '';
    editableElement.appendChild(wrapper);
    _editableElement = editableElement;
    _editorEventHandler = new _metalEvents.EventHandler();
    _destroyedCallback = destroyedCallback;
    _editor = AlloyEditor.editable(wrapper, _getEditorConfiguration(editableElement, portletNamespace, fragmentEntryLinkId, defaultEditorConfiguration, editorName));

    var nativeEditor = _editor.get('nativeEditor');

    _editorEventHandler.add(nativeEditor.on('key', _handleNativeEditorKey));

    _editorEventHandler.add(nativeEditor.on('change', function () {
      return changedCallback(nativeEditor.getData());
    }));

    _editorEventHandler.add(nativeEditor.on('actionPerformed', function () {
      return changedCallback(nativeEditor.getData());
    }));

    _editorEventHandler.add(nativeEditor.on('blur', function () {
      if (_editor._mainUI.state.hidden) {
        requestAnimationFrame(destroy);
      }
    }));

    _editorEventHandler.add(nativeEditor.on('instanceReady', function () {
      nativeEditor.focus();

      if (type === _constants.CREATE_PROCESSOR_EVENT_TYPES.button) {
        nativeEditor.execCommand('selectAll');
      } else if (event) {
        _selectRange(event, nativeEditor);
      }
    }));
  }
  /**
   * @param {string} content editableField's original HTML
   * @param {string} value Translated/segmented value
   * @return {string} Transformed content
   */

  function render(content, value) {
    return value;
  }
  /**
   * Returns a configuration object for a AlloyEditor instance.
   * @param {HTMLElement} editableElement
   * @param {string} portletNamespace
   * @param {string} fragmentEntryLinkId
   * @param {object} defaultEditorConfiguration
   * @param {string} editorName
   * @return {object}
   */

  function _getEditorConfiguration(editableElement, portletNamespace, fragmentEntryLinkId, defaultEditorConfiguration, editorName) {
    return _metal.object.mixin({}, defaultEditorConfiguration.editorConfig || {}, {
      documentBrowseLinkCallback: function documentBrowseLinkCallback(editor, url, changeLinkCallback) {
        var itemSelectorDialog = new _frontendJsWeb.ItemSelectorDialog({
          eventName: editor.title + 'selectItem',
          singleSelect: true,
          title: Liferay.Language.get('select-item'),
          url: url
        });
        itemSelectorDialog.open();
        itemSelectorDialog.on('selectedItemChange', function (event) {
          var selectedItem = event.selectedItem;

          if (selectedItem) {
            changeLinkCallback(selectedItem);
          }
        });
      },
      documentBrowseLinkUrl: defaultEditorConfiguration.editorConfig.documentBrowseLinkUrl.replace('_EDITOR_NAME_', editorName),
      filebrowserImageBrowseLinkUrl: defaultEditorConfiguration.editorConfig.filebrowserImageBrowseLinkUrl.replace('_EDITOR_NAME_', editorName),
      filebrowserImageBrowseUrl: defaultEditorConfiguration.editorConfig.filebrowserImageBrowseUrl.replace('_EDITOR_NAME_', editorName),
      title: editorName
    });
  }
  /**
   * Place the caret in the click position
   * @param {Event} event
   * @param {CKEditor} nativeEditor
   */

  function _selectRange(event, nativeEditor) {
    var ckRange = nativeEditor.getSelection().getRanges()[0];

    if (document.caretPositionFromPoint) {
      var range = document.caretPositionFromPoint(event.clientX, event.clientY);
      var textNode = range.offsetNode;
      ckRange.setStart(CKEDITOR.dom.node(textNode), range.offset);
      ckRange.setEnd(CKEDITOR.dom.node(textNode), range.offset);
    } else if (document.caretRangeFromPoint) {
      var _range = document.caretRangeFromPoint(event.clientX, event.clientY);

      var offset = _range.startOffset || 0;
      ckRange.setStart(CKEDITOR.dom.node(_range.startContainer), offset);
      ckRange.setEnd(CKEDITOR.dom.node(_range.endContainer), offset);
    }

    nativeEditor.getSelection().selectRanges([ckRange]);
  }
  /**
   * Handle native editor key presses.
   * It avoids including line breaks on text editors.
   * @param {Event} event
   * @private
   * @review
   */

  function _handleNativeEditorKey(event) {
    if ((event.data.keyCode === KEY_ENTER || event.data.keyCode === KEY_SHIFT_ENTER) && _editableElement && _editableElement.getAttribute('type') === 'text') {
      event.cancel();
    }
  }

  var _default = {
    destroy: destroy,
    getActiveEditableElement: getActiveEditableElement,
    getFloatingToolbarButtons: getFloatingToolbarButtons,
    init: init,
    render: render
  };
  exports["default"] = _default;
  //# sourceMappingURL=EditableRichTextFragmentProcessor.es.js.map
});
//# sourceMappingURL=EditableRichTextFragmentProcessor.es.js.map