Liferay.Loader.define("layout-content-page-editor-web@1.0.139/js/components/floating_toolbar/mapping/FloatingToolbarMappingPanel.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-metal-web$metal-soy', '../../common/AssetSelector.es', './FloatingToolbarMappingPanelDelegateTemplate.soy', '../../../actions/actions.es', '../../../actions/updateEditableValue.es', '../../../store/ConnectedComponent.es', '../../../utils/FragmentsEditorDialogUtils', '../../../utils/FragmentsEditorGetUtils.es', '../../../utils/FragmentsEditorIdUtils.es', '../../../utils/FragmentsEditorUpdateUtils.es', '../../../utils/constants', './FloatingToolbarMappingPanel.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  Object.defineProperty(exports, "MAPPING_SOURCE_TYPE_IDS", {
    enumerable: true,
    get: function get() {
      return _constants.MAPPING_SOURCE_TYPE_IDS;
    }
  });
  exports["default"] = exports.FloatingToolbarMappingPanel = exports.ConnectedFloatingToolbarMappingPanel = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  var _metalSoy = _interopRequireWildcard(require("frontend-js-metal-web$metal-soy"));

  require("../../common/AssetSelector.es");

  require("./FloatingToolbarMappingPanelDelegateTemplate.soy");

  var _actions = require("../../../actions/actions.es");

  var _updateEditableValue = require("../../../actions/updateEditableValue.es");

  var _ConnectedComponent = _interopRequireDefault(require("../../../store/ConnectedComponent.es"));

  var _FragmentsEditorDialogUtils = require("../../../utils/FragmentsEditorDialogUtils");

  var _FragmentsEditorGetUtils = require("../../../utils/FragmentsEditorGetUtils.es");

  var _FragmentsEditorIdUtils = require("../../../utils/FragmentsEditorIdUtils.es");

  var _FragmentsEditorUpdateUtils = require("../../../utils/FragmentsEditorUpdateUtils.es");

  var _constants = require("../../../utils/constants");

  var _FloatingToolbarMappingPanel = _interopRequireDefault(require("./FloatingToolbarMappingPanel.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * FloatingToolbarMappingPanel
   */
  var FloatingToolbarMappingPanel = /*#__PURE__*/function (_PortletBase) {
    _inherits(FloatingToolbarMappingPanel, _PortletBase);

    function FloatingToolbarMappingPanel() {
      _classCallCheck(this, FloatingToolbarMappingPanel);

      return _possibleConstructorReturn(this, _getPrototypeOf(FloatingToolbarMappingPanel).apply(this, arguments));
    }

    _createClass(FloatingToolbarMappingPanel, [{
      key: "prepareStateForRender",

      /**
       * @inheritdoc
       * @param {object} state
       * @return {object}
       * @review
       */
      value: function prepareStateForRender(state) {
        var nextState = state;
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['mappedAssetEntries'], nextState.mappedAssetEntries.map(_FragmentsEditorIdUtils.encodeAssetId));
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_sourceTypeIds'], _constants.MAPPING_SOURCE_TYPE_IDS);

        if (nextState.mappingFieldsURL && nextState.selectedMappingTypes && nextState.selectedMappingTypes.type) {
          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_sourceTypes'], (0, _FragmentsEditorGetUtils.getMappingSourceTypes)(nextState.selectedMappingTypes.subtype ? nextState.selectedMappingTypes.subtype.label : nextState.selectedMappingTypes.type.label));
        }

        if (nextState.mappedAssetEntries && nextState._selectedAssetEntry && nextState._selectedAssetEntry.classNameId && nextState._selectedAssetEntry.classPK) {
          var mappedAssetEntry = nextState.mappedAssetEntries.find(function (assetEntry) {
            return nextState._selectedAssetEntry.classNameId === assetEntry.classNameId && nextState._selectedAssetEntry.classPK === assetEntry.classPK;
          });

          if (mappedAssetEntry) {
            nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['item', 'editableValues', 'title'], mappedAssetEntry.title);
            nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['item', 'editableValues', 'encodedId'], mappedAssetEntry);
          }
        }

        return nextState;
      }
      /**
       * @inheritdoc
       * @param {boolean} firstRender
       * @review
       */

    }, {
      key: "rendered",
      value: function rendered(firstRender) {
        if (firstRender) {
          this._selectedAssetEntry.classNameId = this.item.editableValues.classNameId;
          this._selectedAssetEntry.classPK = this.item.editableValues.classPK;
          this._selectedSourceTypeId = _constants.MAPPING_SOURCE_TYPE_IDS.content;

          if (this.item && this.mappingFieldsURL && !this.item.editableValues.classNameId) {
            this._selectedSourceTypeId = _constants.MAPPING_SOURCE_TYPE_IDS.structure;
          }
        }
      }
      /**
       * @param {{editableValues: object}} newItem
       * @param {{editableValues: object}} [oldItem]
       * @inheritdoc
       * @review
       */

    }, {
      key: "syncItem",
      value: function syncItem(newItem, oldItem) {
        if (!oldItem || newItem.editableValues.classNameId !== oldItem.editableValues.classNameId || newItem.editableValues.mappedField !== oldItem.editableValues.mappedField) {
          this._loadFields();
        }
      }
      /**
       * Clears editable values
       * @private
       * @review
       */

    }, {
      key: "_clearEditableValues",
      value: function _clearEditableValues() {
        this.store.dispatch((0, _updateEditableValue.updateEditableValueFieldIdAction)(this.item.fragmentEntryLinkId, this._getFragmentEntryProcessor(), this.item.editableId, {}));
      }
      /**
       * Clears fields
       * @private
       * @review
       */

    }, {
      key: "_clearFields",
      value: function _clearFields() {
        this._fields = [];
      }
      /**
       * Gets right processor depending on itemType
       * @private
       * @review
       */

    }, {
      key: "_getFragmentEntryProcessor",
      value: function _getFragmentEntryProcessor() {
        return this.itemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.backgroundImageEditable ? _constants.BACKGROUND_IMAGE_FRAGMENT_ENTRY_PROCESSOR : _constants.EDITABLE_FRAGMENT_ENTRY_PROCESSOR;
      }
      /**
       * @param {MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleAssetBrowserLinkClick",
      value: function _handleAssetBrowserLinkClick(event) {
        var _this = this;

        var _event$delegateTarget = event.delegateTarget.dataset,
            assetBrowserUrl = _event$delegateTarget.assetBrowserUrl,
            assetBrowserWindowTitle = _event$delegateTarget.assetBrowserWindowTitle;
        (0, _FragmentsEditorDialogUtils.openAssetBrowser)({
          assetBrowserURL: assetBrowserUrl,
          callback: function callback(selectedAssetEntry) {
            _this._selectAssetEntry(selectedAssetEntry);

            requestAnimationFrame(function () {
              _this.refs.panel.focus();
            });
          },
          eventName: "".concat(this.portletNamespace, "selectAsset"),
          modalTitle: assetBrowserWindowTitle
        });
      }
      /**
       * @param {MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleAssetEntryLinkClick",
      value: function _handleAssetEntryLinkClick(event) {
        var _this2 = this;

        var data = event.delegateTarget.dataset;

        this._selectAssetEntry({
          classNameId: data.classNameId,
          classPK: data.classPk
        });

        requestAnimationFrame(function () {
          _this2.refs.panel.focus();
        });
      }
      /**
       * Opens content creation dialog
       * @private
       * @review
       */

    }, {
      key: "_handleCreateContentClick",
      value: function _handleCreateContentClick() {
        (0, _FragmentsEditorDialogUtils.openCreateContentDialog)(this.store);
      }
      /**
       * Handle field option change
       * @param {Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleFieldOptionChange",
      value: function _handleFieldOptionChange(event) {
        var fieldId = event.delegateTarget.value;
        var shouldRemoveValues = fieldId === '';

        if (this._selectedSourceTypeId === _constants.MAPPING_SOURCE_TYPE_IDS.content) {
          this.store.dispatch((0, _updateEditableValue.updateEditableValueFieldIdAction)(this.item.fragmentEntryLinkId, this._getFragmentEntryProcessor(), this.item.editableId, {
            classNameId: shouldRemoveValues ? '' : this._selectedAssetEntry.classNameId,
            classPK: shouldRemoveValues ? '' : this._selectedAssetEntry.classPK,
            fieldId: fieldId
          }));
        } else {
          this.store.dispatch((0, _updateEditableValue.updateEditableValueMappedFieldAction)(this.item.fragmentEntryLinkId, this._getFragmentEntryProcessor(), this.item.editableId, fieldId));
        }
      }
      /**
       * Handle source option change
       * @param {Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleSourceTypeChange",
      value: function _handleSourceTypeChange(event) {
        this._selectedSourceTypeId = event.delegateTarget.value;

        if (FloatingToolbarMappingPanel.emptyEditableValues(this.item.editableValues)) {
          this._loadFields();
        } else {
          this._clearEditableValues();
        }
      }
      /**
       * Load the list of fields
       * @private
       * @review
       */

    }, {
      key: "_loadFields",
      value: function _loadFields() {
        var _this3 = this;

        var promise;

        this._clearFields();

        if (this._selectedSourceTypeId === _constants.MAPPING_SOURCE_TYPE_IDS.structure) {
          var data = {
            classNameId: this.selectedMappingTypes.type.id
          };

          if (this.selectedMappingTypes.subtype) {
            data.classTypeId = this.selectedMappingTypes.subtype.id;
          }

          promise = this.fetch(this.mappingFieldsURL, data);
        } else if (this._selectedSourceTypeId === _constants.MAPPING_SOURCE_TYPE_IDS.content && this._selectedAssetEntry.classNameId && this._selectedAssetEntry.classPK) {
          promise = this.fetch(this.getAssetMappingFieldsURL, {
            classNameId: this._selectedAssetEntry.classNameId,
            classPK: this._selectedAssetEntry.classPK
          });
        }

        if (promise) {
          promise.then(function (response) {
            return response.json();
          }).then(function (response) {
            _this3._fields = response.filter(function (field) {
              return _constants.COMPATIBLE_TYPES[_this3.item.type].indexOf(field.type) !== -1;
            });
          });
        } else if (this._fields.length) {
          this._clearFields();
        }
      }
      /**
       * @param {object} assetEntry
       * @param {string} assetEntry.classNameId
       * @param {string} assetEntry.classPK
       * @private
       * @review
       */

    }, {
      key: "_selectAssetEntry",
      value: function _selectAssetEntry(assetEntry) {
        this._selectedAssetEntry = assetEntry;
        this.store.dispatch(_objectSpread({}, this._selectedAssetEntry, {
          type: _actions.ADD_MAPPED_ASSET_ENTRY
        }));

        this._loadFields();
      }
    }], [{
      key: "emptyEditableValues",

      /**
       * @return {boolean} Mapping values are empty
       * @private
       * @static
       * @review
       */
      value: function emptyEditableValues(editableValues) {
        return !editableValues.classNameId && !editableValues.classPK && !editableValues.fieldId && !editableValues.mappedField;
      }
    }]);

    return FloatingToolbarMappingPanel;
  }(_frontendJsWeb.PortletBase);
  /**
   * State definition.
   * @review
   * @static
   * @type {object}
   */

  exports.FloatingToolbarMappingPanel = FloatingToolbarMappingPanel;
  FloatingToolbarMappingPanel.STATE = {
    /**
     * @default []
     * @memberOf FloatingToolbarMappingPanel
     * @private
     * @review
     * @type {object[]}
     */
    _fields: _metalSoy.Config.array().internal().value([]),

    /**
     * @default undefined
     * @memberof FloatingToolbarMappingPanel
     * @review
     * @type {string}
     */
    _selectedAssetEntry: _metalSoy.Config.object().internal().value({}),

    /**
     * @default undefined
     * @memberof FloatingToolbarMappingPanel
     * @review
     * @type {string}
     */
    _selectedSourceTypeId: _metalSoy.Config.oneOf(Object.values(_constants.MAPPING_SOURCE_TYPE_IDS)).internal(),

    /**
     * @default undefined
     * @memberof FloatingToolbarMappingPanel
     * @review
     * @type {object}
     */
    item: _metalSoy.Config.required(),

    /**
     * @default undefined
     * @memberof FloatingToolbarMappingPanel
     * @review
     * @type {string}
     */
    itemId: _metalSoy.Config.string().required(),

    /**
     * @default undefined
     * @memberof FloatingToolbarMappingPanel
     * @review
     * @type {string}
     */
    itemType: _metalSoy.Config.string().required()
  };
  var ConnectedFloatingToolbarMappingPanel = (0, _ConnectedComponent["default"])(FloatingToolbarMappingPanel, ['assetBrowserLinks', 'contentCreationEnabled', 'defaultSegmentsExperienceId', 'getAssetMappingFieldsURL', 'languageId', 'mappedAssetEntries', 'mappingFieldsURL', 'portletNamespace', 'segmentsExperienceId', 'selectedItems', 'selectedMappingTypes']);
  exports.ConnectedFloatingToolbarMappingPanel = ConnectedFloatingToolbarMappingPanel;

  _metalSoy["default"].register(ConnectedFloatingToolbarMappingPanel, _FloatingToolbarMappingPanel["default"]);

  var _default = ConnectedFloatingToolbarMappingPanel;
  exports["default"] = _default;
  //# sourceMappingURL=FloatingToolbarMappingPanel.es.js.map
});
//# sourceMappingURL=FloatingToolbarMappingPanel.es.js.map