Liferay.Loader.define("layout-content-page-editor-web@1.0.139/js/components/common/Editor.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-events', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../store/hooks/useSelector.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.Editor = void 0;

  var _metalEvents = require("frontend-js-metal-web$metal-events");

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _useSelector = _interopRequireDefault(require("../../store/hooks/useSelector.es"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var Editor = function Editor(props) {
    var editorConfig = (0, _useSelector["default"])(function (state) {
      return state.defaultEditorConfigurations.text.editorConfig;
    });
    var portletNamespace = (0, _useSelector["default"])(function (state) {
      return state.portletNamespace;
    });

    var _useState = (0, _react.useState)(null),
        _useState2 = _slicedToArray(_useState, 2),
        editor = _useState2[0],
        setEditor = _useState2[1];

    var autoFocus = props.autoFocus,
        initialValue = props.initialValue,
        onChange = props.onChange;
    var wrapperRef = (0, _react.useRef)(null);
    (0, _react.useEffect)(function () {
      if (editor) {
        var nativeEditor = editor.get('nativeEditor');

        if (!nativeEditor.getData() || !initialValue) {
          nativeEditor.setData(initialValue);
        }
      }
    }, [editor, initialValue]);
    (0, _react.useEffect)(function () {
      var editorEventHandler = new _metalEvents.EventHandler();

      if (editor && onChange) {
        var nativeEditor = editor.get('nativeEditor');
        editorEventHandler.add(nativeEditor.on('change', function () {
          return onChange(nativeEditor.getData());
        }));
        editorEventHandler.add(nativeEditor.on('actionPerformed', function () {
          return onChange(nativeEditor.getData());
        }));
      }

      return function () {
        editorEventHandler.removeAllListeners();
        editorEventHandler.dispose();
      };
    }, [editor, onChange]);
    (0, _react.useEffect)(function () {
      var newEditor = AlloyEditor.editable(wrapperRef.current, _objectSpread({}, editorConfig, {
        enterMode: 1,
        startupFocus: autoFocus
      }));
      var ready = false;
      var instanceReadyEventHandler = newEditor.get('nativeEditor').once('instanceReady', function () {
        ready = true;
        setEditor(newEditor);
      });
      return function () {
        try {
          if (ready) {
            newEditor.destroy();
            setEditor(null);
          } else {
            instanceReadyEventHandler.removeListener();
            newEditor.get('nativeEditor').once('instanceReady', function () {
              newEditor.destroy();
            });
          }
        } catch (_err) {// https://github.com/liferay/alloy-editor/issues/1306
        }
      };
    }, [autoFocus, editorConfig]);
    return _react["default"].createElement("div", {
      className: "alloy-editor-container",
      id: "".concat(portletNamespace).concat(props.id)
    }, _react["default"].createElement("div", {
      className: "alloy-editor form-control form-control-sm fragments-editor__editor",
      contentEditable: false,
      "data-placeholder": props.placeholder,
      "data-required": false,
      id: "".concat(portletNamespace).concat(props.id),
      name: props.id,
      ref: wrapperRef
    }), _react["default"].createElement("div", {
      className: "alloy-editor-placeholder"
    }, props.placeholder));
  };

  exports.Editor = Editor;
  Editor.defaultProps = {
    autoFocus: false
  };
  var _default = Editor;
  exports["default"] = _default;
  //# sourceMappingURL=Editor.es.js.map
});
//# sourceMappingURL=Editor.es.js.map