Liferay.Loader.define("layout-content-page-editor-web@1.0.139/js/actions/removeRow.es", ['module', 'exports', 'require', '../utils/FragmentsEditorFetchUtils.es', '../utils/FragmentsEditorGetUtils.es', '../utils/LayoutDataList.es', './actions.es', './removeFragmentEntryLinks.es', './updatePageEditorLayoutData.es', './updateWidgets.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.removeRowAction = removeRowAction;

  var _FragmentsEditorFetchUtils = require("../utils/FragmentsEditorFetchUtils.es");

  var _FragmentsEditorGetUtils = require("../utils/FragmentsEditorGetUtils.es");

  var _LayoutDataList = require("../utils/LayoutDataList.es");

  var _actions = require("./actions.es");

  var _removeFragmentEntryLinks = require("./removeFragmentEntryLinks.es");

  var _updatePageEditorLayoutData = require("./updatePageEditorLayoutData.es");

  var _updateWidgets = require("./updateWidgets.es");

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */

  /**
   * Removes a row of the layout data structure
   * @param {number} rowId
   * @review
   */
  function removeRowAction(rowId) {
    return function (dispatch, getState) {
      var state = getState();
      dispatch(_removeRowAction(rowId));
      var fragmentEntryLinkIds = (0, _FragmentsEditorGetUtils.getRowFragmentEntryLinkIds)(state.layoutData.structure[(0, _FragmentsEditorGetUtils.getRowIndex)(state.layoutData.structure, rowId)]);
      var fragmentEntryLinkIdsToRemove = fragmentEntryLinkIds.filter(function (fragmentEntryLinkId) {
        return !(0, _LayoutDataList.containsFragmentEntryLinkId)(state.layoutDataList, fragmentEntryLinkId, state.segmentsExperienceId || state.defaultSegmentsExperienceId);
      });
      var fragmentEntryLinkIdsToRemoveExperience = fragmentEntryLinkIds.filter(function (fragmentEntryLinkId) {
        return (0, _LayoutDataList.containsFragmentEntryLinkId)(state.layoutDataList, fragmentEntryLinkId, state.segmentsExperienceId || state.defaultSegmentsExperienceId);
      });

      if (fragmentEntryLinkIdsToRemoveExperience.length > 0) {
        (0, _FragmentsEditorFetchUtils.removeExperience)(state.segmentsExperienceId || state.defaultSegmentsExperienceId, fragmentEntryLinkIdsToRemoveExperience, false);
      }

      dispatch((0, _updateWidgets.updateWidgetsAction)(fragmentEntryLinkIds));
      dispatch((0, _updatePageEditorLayoutData.updatePageEditorLayoutDataAction)());
      dispatch((0, _removeFragmentEntryLinks.removeFragmentEntryLinksAction)(fragmentEntryLinkIdsToRemove));
    };
  }

  function _removeRowAction(rowId) {
    return {
      rowId: rowId,
      type: _actions.REMOVE_ROW
    };
  }
  //# sourceMappingURL=removeRow.es.js.map
});
//# sourceMappingURL=removeRow.es.js.map