Liferay.Loader.define("layout-content-page-editor-web@1.0.139/js/actions/duplicateFragmentEntryLink.es", ['module', 'exports', 'require', '../utils/FragmentsEditorFetchUtils.es', '../utils/constants', './actions.es', './updateActiveItem.es', './updatePageEditorLayoutData.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.duplicateFragmentEntryLinkAction = duplicateFragmentEntryLinkAction;

  var _FragmentsEditorFetchUtils = require("../utils/FragmentsEditorFetchUtils.es");

  var _constants = require("../utils/constants");

  var _actions = require("./actions.es");

  var _updateActiveItem = require("./updateActiveItem.es");

  var _updatePageEditorLayoutData = require("./updatePageEditorLayoutData.es");

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */

  /**
   * @param {string} fragmentEntryLinkId
   * @param {string} fragmentEntryLinkRowType
   * @review
   */
  function duplicateFragmentEntryLinkAction(fragmentEntryLinkId, fragmentEntryLinkRowType) {
    return function (dispatch) {
      var newFragmentEntryLinkId;
      (0, _FragmentsEditorFetchUtils.duplicateFragmentEntryLink)(fragmentEntryLinkId).then(function (fragmentEntryLink) {
        newFragmentEntryLinkId = fragmentEntryLink.fragmentEntryLinkId;
        return dispatch(_duplicateFragmentEntryLinkAction(fragmentEntryLinkId, fragmentEntryLink, fragmentEntryLinkRowType));
      }).then(function () {
        return dispatch((0, _updatePageEditorLayoutData.updatePageEditorLayoutDataAction)());
      }).then(function () {
        return dispatch((0, _updateActiveItem.updateActiveItemAction)(newFragmentEntryLinkId, _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment));
      });
    };
  }
  /**
   * @param {string} originalFragmentEntryLinkId
   * @param {object} fragmentEntryLink
   * @param {string} fragmentEntryLinkRowType
   */

  function _duplicateFragmentEntryLinkAction(originalFragmentEntryLinkId, fragmentEntryLink, fragmentEntryLinkRowType) {
    return {
      fragmentEntryLink: fragmentEntryLink,
      fragmentEntryLinkId: originalFragmentEntryLinkId,
      fragmentEntryLinkRowType: fragmentEntryLinkRowType,
      type: _actions.DUPLICATE_FRAGMENT_ENTRY_LINK
    };
  }
  //# sourceMappingURL=duplicateFragmentEntryLink.es.js.map
});
//# sourceMappingURL=duplicateFragmentEntryLink.es.js.map