'use strict';

Liferay.Loader.define('layout-content-page-editor-web$promise@7.3.1/setimmediate/synchronous', ['module', 'exports', 'require', './core'], function (module, exports, require) {
  var define = undefined;
  var Promise = require('./core');

  module.exports = Promise;
  Promise.enableSynchronous = function () {
    Promise.prototype.isPending = function () {
      return this.getState() == 0;
    };

    Promise.prototype.isFulfilled = function () {
      return this.getState() == 1;
    };

    Promise.prototype.isRejected = function () {
      return this.getState() == 2;
    };

    Promise.prototype.getValue = function () {
      if (this._65 === 3) {
        return this._55.getValue();
      }

      if (!this.isFulfilled()) {
        throw new Error('Cannot get a value of an unfulfilled promise.');
      }

      return this._55;
    };

    Promise.prototype.getReason = function () {
      if (this._65 === 3) {
        return this._55.getReason();
      }

      if (!this.isRejected()) {
        throw new Error('Cannot get a rejection reason of a non-rejected promise.');
      }

      return this._55;
    };

    Promise.prototype.getState = function () {
      if (this._65 === 3) {
        return this._55.getState();
      }
      if (this._65 === -1 || this._65 === -2) {
        return 0;
      }

      return this._65;
    };
  };

  Promise.disableSynchronous = function () {
    Promise.prototype.isPending = undefined;
    Promise.prototype.isFulfilled = undefined;
    Promise.prototype.isRejected = undefined;
    Promise.prototype.getValue = undefined;
    Promise.prototype.getReason = undefined;
    Promise.prototype.getState = undefined;
  };
});
//# sourceMappingURL=synchronous.js.map