Liferay.Loader.define('layout-content-page-editor-web$lodash-es@4.17.15/_createCurry', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import apply from './_apply.js';
  import createCtor from './_createCtor.js';
  import createHybrid from './_createHybrid.js';
  import createRecurry from './_createRecurry.js';
  import getHolder from './_getHolder.js';
  import replaceHolders from './_replaceHolders.js';
  import root from './_root.js';

  /**
   * Creates a function that wraps `func` to enable currying.
   *
   * @private
   * @param {Function} func The function to wrap.
   * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
   * @param {number} arity The arity of `func`.
   * @returns {Function} Returns the new wrapped function.
   */
  function createCurry(func, bitmask, arity) {
    var Ctor = createCtor(func);

    function wrapper() {
      var length = arguments.length,
          args = Array(length),
          index = length,
          placeholder = getHolder(wrapper);

      while (index--) {
        args[index] = arguments[index];
      }
      var holders = length < 3 && args[0] !== placeholder && args[length - 1] !== placeholder ? [] : replaceHolders(args, placeholder);

      length -= holders.length;
      if (length < arity) {
        return createRecurry(func, bitmask, createHybrid, wrapper.placeholder, undefined, args, holders, undefined, undefined, arity - length);
      }
      var fn = this && this !== root && this instanceof wrapper ? Ctor : func;
      return apply(fn, this, args);
    }
    return wrapper;
  }

  export default createCurry;
});
//# sourceMappingURL=_createCurry.js.map