Liferay.Loader.define("layout-content-page-editor-web@1.0.126/js/components/sidebar/page_content/PageContent.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/label', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../store/hooks/useSelector.es', '../../../utils/constants'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.PageContent = void 0;

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _dropDown = _interopRequireDefault(require("@frontend-taglib-clay$clayui/drop-down"));

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _label = _interopRequireDefault(require("@frontend-taglib-clay$clayui/label"));

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _useSelector = _interopRequireDefault(require("../../../store/hooks/useSelector.es"));

  var _constants = require("../../../utils/constants");

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _toArray(arr) {
    return _arrayWithHoles(arr) || _iterableToArray(arr) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var getEditableValues = function getEditableValues(itemId, fragmentEntryLinks) {
    var _itemId$split = itemId.split('-'),
        _itemId$split2 = _toArray(_itemId$split),
        fragmentEntryLinkId = _itemId$split2[0],
        editableNameSplit = _itemId$split2.slice(1);

    var editableName = editableNameSplit.join('-');
    var fragmentEntryLink = fragmentEntryLinks[fragmentEntryLinkId];

    if (fragmentEntryLink) {
      return fragmentEntryLink.editableValues[_constants.EDITABLE_FRAGMENT_ENTRY_PROCESSOR][editableName] || {};
    }

    return {};
  };

  var PageContent = function PageContent(props) {
    var _useState = (0, _react.useState)(false),
        _useState2 = _slicedToArray(_useState, 2),
        active = _useState2[0],
        setActive = _useState2[1];

    var classNameId = props.classNameId,
        classPK = props.classPK;
    var _props$actions = props.actions,
        editURL = _props$actions.editURL,
        permissionsURL = _props$actions.permissionsURL,
        viewUsagesURL = _props$actions.viewUsagesURL;
    var itemId = "".concat(classNameId, "-").concat(classPK);
    var isPageContentHovered = (0, _useSelector["default"])(function (state) {
      var fragmentEntryLinks = state.fragmentEntryLinks,
          hoveredItemId = state.hoveredItemId,
          hoveredItemType = state.hoveredItemType;

      if (hoveredItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.editable) {
        var editableValues = getEditableValues(hoveredItemId, fragmentEntryLinks);
        return editableValues.classNameId === classNameId && editableValues.classPK === classPK;
      } else if (hoveredItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.mappedItem) {
        return itemId === state.hoveredItemId;
      }
    });

    var openWindow = function openWindow(uri, title) {
      Liferay.Util.openWindow({
        dialog: {
          destroyOnHide: true,
          modal: true
        },
        dialogIframe: {
          bodyCssClass: 'dialog-with-footer'
        },
        title: title,
        uri: uri
      });
    };

    var className = (0, _classnames["default"])({
      'fragments-editor__page-content': true,
      'fragments-editor__page-content--mapped-item-hovered': isPageContentHovered
    });
    return _react["default"].createElement("li", {
      className: className,
      "data-fragments-editor-item-id": itemId,
      "data-fragments-editor-item-type": _constants.FRAGMENTS_EDITOR_ITEM_TYPES.mappedItem
    }, _react["default"].createElement("div", {
      className: "d-flex pl-3 pr-2 py-3"
    }, _react["default"].createElement("div", {
      className: "autofit-col autofit-col-expand"
    }, _react["default"].createElement("strong", {
      className: "list-group-title truncate-text"
    }, props.title), _react["default"].createElement("span", {
      className: "small text-secondary"
    }, props.name), _react["default"].createElement("span", {
      className: "small text-secondary"
    }, props.usagesCount === 1 ? Liferay.Language.get('used-in-1-page') : Liferay.Util.sub(Liferay.Language.get('used-in-x-pages'), props.usagesCount)), _react["default"].createElement("div", null, props.status.hasApprovedVersion && _react["default"].createElement(_label["default"], {
      displayType: "success"
    }, Liferay.Language.get('approved')), _react["default"].createElement(_label["default"], {
      displayType: props.status.style
    }, props.status.label))), _react["default"].createElement(_dropDown["default"], {
      active: active,
      onActiveChange: setActive,
      trigger: _react["default"].createElement(_button["default"], {
        className: "btn-monospaced btn-sm text-secondary",
        displayType: "unstyled"
      }, _react["default"].createElement(_icon["default"], {
        symbol: "ellipsis-v"
      }))
    }, _react["default"].createElement(_dropDown["default"].ItemList, null, editURL && _react["default"].createElement(_dropDown["default"].Item, {
      href: editURL,
      key: "editURL"
    }, Liferay.Language.get('edit')), permissionsURL && _react["default"].createElement(_dropDown["default"].Item, {
      key: "permissionsURL",
      onClick: function onClick() {
        return openWindow(permissionsURL, Liferay.Language.get('permissions'));
      }
    }, Liferay.Language.get('permissions')), viewUsagesURL && _react["default"].createElement(_dropDown["default"].Item, {
      key: "viewUsagesURL",
      onClick: function onClick() {
        return openWindow(viewUsagesURL, Liferay.Language.get('view-usages'));
      }
    }, Liferay.Language.get('view-usages'))))));
  };

  exports.PageContent = PageContent;
  var _default = PageContent;
  exports["default"] = _default;
  //# sourceMappingURL=PageContent.es.js.map
});
//# sourceMappingURL=PageContent.es.js.map