Liferay.Loader.define("layout-content-page-editor-web@1.0.126/js/components/sidebar/layouts/SidebarLayoutsPanel.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', '../../../actions/actions.es', '../../../store/store.es', '../../../utils/constants', './SidebarLayoutsPanel.soy', './utils/SidebarLayoutsDragDrop.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.SidebarLayoutsPanel = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _actions = require("../../../actions/actions.es");

  var _store = require("../../../store/store.es");

  var _constants = require("../../../utils/constants");

  var _SidebarLayoutsPanel = _interopRequireDefault(require("./SidebarLayoutsPanel.soy"));

  var _SidebarLayoutsDragDrop = _interopRequireDefault(require("./utils/SidebarLayoutsDragDrop.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * SidebarLayoutsPanel
   */
  var SidebarLayoutsPanel = /*#__PURE__*/function (_Component) {
    _inherits(SidebarLayoutsPanel, _Component);

    function SidebarLayoutsPanel() {
      _classCallCheck(this, SidebarLayoutsPanel);

      return _possibleConstructorReturn(this, _getPrototypeOf(SidebarLayoutsPanel).apply(this, arguments));
    }

    _createClass(SidebarLayoutsPanel, [{
      key: "rendered",

      /**
       * @inheritDoc
       */
      value: function rendered(firstRendered) {
        if (firstRendered) {
          this._initializeSidebarLayoutsDragDrop();
        }
      }
      /**
       * @inheritdoc
       */

    }, {
      key: "disposed",
      value: function disposed() {
        this._sidebarLayoutsDragDrop.dispose();
      }
      /**
       * Handles dragLayout event and dispatches action to update drag target
       * @param {object} eventData
       * @param {string} eventData.hoveredRowBorder
       * @param {string} eventData.hoveredRowId
       */

    }, {
      key: "_handleDragLayout",
      value: function _handleDragLayout(eventData) {
        var hoveredRowBorder = eventData.hoveredRowBorder,
            hoveredRowId = eventData.hoveredRowId;
        this.store.dispatch({
          dropTargetBorder: hoveredRowBorder,
          dropTargetItemId: hoveredRowId,
          dropTargetItemType: _constants.FRAGMENTS_EDITOR_ITEM_TYPES.row,
          type: _actions.UPDATE_DROP_TARGET
        });
      }
      /**
       * Handles dropLayout event and dispatches action to add a row
       * @param {!object} eventData
       * @param {!number} eventData.layoutIndex
       * @private
       * @review
       */

    }, {
      key: "_handleDropLayout",
      value: function _handleDropLayout(eventData) {
        var _this = this;

        var layoutColumns = this._layouts[eventData.layoutIndex].columns;
        this.store.dispatch({
          layoutColumns: layoutColumns,
          type: _actions.ADD_ROW
        }).dispatch({
          type: _actions.CLEAR_DROP_TARGET
        });
        requestAnimationFrame(function () {
          _this._initializeSidebarLayoutsDragDrop();
        });
      }
      /**
       * Handles leaveLayoutTarget event and dispatches
       * action to clear drag target
       * @private
       * @review
       */

    }, {
      key: "_handleLeaveLayoutTarget",
      value: function _handleLeaveLayoutTarget() {
        this.store.dispatch({
          type: _actions.CLEAR_DROP_TARGET
        });
      }
      /**
       * Initializes sidebarLayoutsDragDrop instance
       * @private
       * @review
       */

    }, {
      key: "_initializeSidebarLayoutsDragDrop",
      value: function _initializeSidebarLayoutsDragDrop() {
        if (this._sidebarLayoutsDragDrop) {
          this._sidebarLayoutsDragDrop.dispose();
        }

        this._sidebarLayoutsDragDrop = new _SidebarLayoutsDragDrop["default"]();

        this._sidebarLayoutsDragDrop.on('dragLayout', this._handleDragLayout.bind(this));

        this._sidebarLayoutsDragDrop.on('dropLayout', this._handleDropLayout.bind(this));

        this._sidebarLayoutsDragDrop.on('leaveLayoutTarget', this._handleLeaveLayoutTarget.bind(this));
      }
    }]);

    return SidebarLayoutsPanel;
  }(_metalComponent["default"]);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.SidebarLayoutsPanel = SidebarLayoutsPanel;
  SidebarLayoutsPanel.STATE = {
    /**
     * List of layouts to be shown
     * @default []
     * @memberOf SidebarLayoutsPanel
     * @private
     * @review
     * @type {Array}
     */
    _layouts: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      columns: _metalState.Config.arrayOf(_metalState.Config.string())
    })).value([{
      columns: ['12']
    }, {
      columns: ['6', '6']
    }, {
      columns: ['8', '4']
    }, {
      columns: ['4', '8']
    }, {
      columns: ['4', '4', '4']
    }, {
      columns: ['3', '3', '3', '3']
    }]),

    /**
     * Internal SidebarLayoutsDragDrop instance
     * @default null
     * @instance
     * @memberOf SidebarLayoutsPanel
     * @review
     * @type {object|null}
     */
    _sidebarLayoutsDragDrop: _metalState.Config.internal().value(null),

    /**
     * Store instance
     * @default undefined
     * @instance
     * @memberOf SidebarLayoutsPanel
     * @review
     * @type {Store}
     */
    store: _metalState.Config.instanceOf(_store.Store)
  };

  _metalSoy["default"].register(SidebarLayoutsPanel, _SidebarLayoutsPanel["default"]);

  var _default = SidebarLayoutsPanel;
  exports["default"] = _default;
  //# sourceMappingURL=SidebarLayoutsPanel.es.js.map
});
//# sourceMappingURL=SidebarLayoutsPanel.es.js.map