Liferay.Loader.define("layout-content-page-editor-web@1.0.126/js/components/sidebar/comments/FragmentEntryLinksWithComments.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../../actions/actions.es', '../../../actions/updateActiveItem.es', '../../../store/hooks/useDispatch.es', '../../../store/hooks/useGetComments.es', '../../../store/hooks/useSelector.es', '../../../utils/LayoutDataList.es', '../../../utils/constants', '../SidebarHeader.es', './NoCommentsMessage.es', './ResolvedCommentsToggle.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.FragmentEntryLinksWithComments = void 0;

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _actions = require("../../../actions/actions.es");

  var _updateActiveItem = require("../../../actions/updateActiveItem.es");

  var _useDispatch = _interopRequireDefault(require("../../../store/hooks/useDispatch.es"));

  var _useGetComments = _interopRequireDefault(require("../../../store/hooks/useGetComments.es"));

  var _useSelector = _interopRequireDefault(require("../../../store/hooks/useSelector.es"));

  var _LayoutDataList = require("../../../utils/LayoutDataList.es");

  var _constants = require("../../../utils/constants");

  var _SidebarHeader = _interopRequireDefault(require("../SidebarHeader.es"));

  var _NoCommentsMessage = require("./NoCommentsMessage.es");

  var _ResolvedCommentsToggle = _interopRequireDefault(require("./ResolvedCommentsToggle.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var FragmentEntryLinksWithComments = function FragmentEntryLinksWithComments() {
    var dispatch = (0, _useDispatch["default"])();
    var getComments = (0, _useGetComments["default"])();
    var fragmentEntryLinksWithComments = (0, _useSelector["default"])(function (state) {
      return (0, _LayoutDataList.getLayoutDataFragmentEntryLinkIds)(state.layoutData).map(function (fragmentEntryLinkId) {
        return state.fragmentEntryLinks[fragmentEntryLinkId];
      }).filter(function (fragmentEntryLink) {
        return fragmentEntryLink;
      }).filter(function (fragmentEntryLink) {
        return getComments(fragmentEntryLink).length;
      });
    });

    var setActiveFragmentEntryLink = function setActiveFragmentEntryLink(fragmentEntryLinkId) {
      return function () {
        dispatch((0, _updateActiveItem.updateActiveItemAction)(fragmentEntryLinkId, _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment));
        var fragmentEntryLinkElement = document.querySelector(".fragment-entry-link-list [data-fragments-editor-item-id=\"".concat(fragmentEntryLinkId, "\"][data-fragments-editor-item-type=\"").concat(_constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment, "\"]"));

        if (fragmentEntryLinkElement) {
          fragmentEntryLinkElement.scrollIntoView({
            behavior: 'smooth',
            block: 'center'
          });
        }
      };
    };

    var setHoveredFragmentEntryLink = function setHoveredFragmentEntryLink(fragmentEntryLinkId) {
      return function () {
        dispatch({
          hoveredItemId: fragmentEntryLinkId,
          hoveredItemType: _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment,
          type: _actions.UPDATE_HOVERED_ITEM
        });
      };
    };

    return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_SidebarHeader["default"], null, Liferay.Language.get('comments')), _react["default"].createElement(_ResolvedCommentsToggle["default"], null), fragmentEntryLinksWithComments.length ? _react["default"].createElement("nav", {
      className: "list-group"
    }, fragmentEntryLinksWithComments.map(function getFragmentEntryLinkItem(fragmentEntryLink) {
      var commentCount = getComments(fragmentEntryLink).length;
      var fragmentEntryLinkId = fragmentEntryLink.fragmentEntryLinkId,
          name = fragmentEntryLink.name;
      return _react["default"].createElement("a", {
        className: "border-0 list-group-item list-group-item-action",
        href: "#".concat(fragmentEntryLinkId),
        key: fragmentEntryLinkId,
        onClick: setActiveFragmentEntryLink(fragmentEntryLinkId),
        onFocus: setHoveredFragmentEntryLink(fragmentEntryLinkId),
        onMouseOver: setHoveredFragmentEntryLink(fragmentEntryLinkId)
      }, _react["default"].createElement("strong", {
        className: "d-block text-dark"
      }, name), _react["default"].createElement("span", {
        className: "text-secondary"
      }, Liferay.Util.sub(commentCount === 1 ? Liferay.Language.get('x-comment') : Liferay.Language.get('x-comments'), commentCount)));
    })) : _react["default"].createElement(_NoCommentsMessage.NoCommentsMessage, null));
  };

  exports.FragmentEntryLinksWithComments = FragmentEntryLinksWithComments;
  var _default = FragmentEntryLinksWithComments;
  exports["default"] = _default;
  //# sourceMappingURL=FragmentEntryLinksWithComments.es.js.map
});
//# sourceMappingURL=FragmentEntryLinksWithComments.es.js.map