Liferay.Loader.define("layout-content-page-editor-web@1.0.126/js/components/sidebar/comments/FragmentComments.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../actions/actions.es', '../../../actions/deleteFragmentEntryLinkComment.es', '../../../actions/updateFragmentEntryLinkComment.es', '../../../actions/updateFragmentEntryLinkCommentReply.es', '../../../store/hooks/useDispatch.es', '../../../store/hooks/useGetComments.es', '../../../utils/constants', '../SidebarHeader.es', './AddCommentForm.es', './FragmentComment.es', './ResolvedCommentsToggle.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.FragmentComments = void 0;

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _actions = require("../../../actions/actions.es");

  var _deleteFragmentEntryLinkComment = require("../../../actions/deleteFragmentEntryLinkComment.es");

  var _updateFragmentEntryLinkComment = require("../../../actions/updateFragmentEntryLinkComment.es");

  var _updateFragmentEntryLinkCommentReply = require("../../../actions/updateFragmentEntryLinkCommentReply.es");

  var _useDispatch = _interopRequireDefault(require("../../../store/hooks/useDispatch.es"));

  var _useGetComments = _interopRequireDefault(require("../../../store/hooks/useGetComments.es"));

  var _constants = require("../../../utils/constants");

  var _SidebarHeader = _interopRequireDefault(require("../SidebarHeader.es"));

  var _AddCommentForm = _interopRequireDefault(require("./AddCommentForm.es"));

  var _FragmentComment = _interopRequireDefault(require("./FragmentComment.es"));

  var _ResolvedCommentsToggle = _interopRequireDefault(require("./ResolvedCommentsToggle.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var FragmentComments = function FragmentComments(props) {
    var fragmentEntryLink = props.fragmentEntryLink;
    var getComments = (0, _useGetComments["default"])();
    var fragmentEntryLinkComments = getComments(fragmentEntryLink);
    var dispatch = (0, _useDispatch["default"])();

    var _getActions = getActions(dispatch, props),
        clearActiveItem = _getActions.clearActiveItem,
        deleteComment = _getActions.deleteComment,
        editComment = _getActions.editComment,
        editCommentReply = _getActions.editCommentReply;

    return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_SidebarHeader["default"], {
      className: "comments-sidebar-title"
    }, _react["default"].createElement(_button["default"], {
      borderless: true,
      className: "text-dark",
      onClick: clearActiveItem,
      small: true
    }, _react["default"].createElement(_icon["default"], {
      symbol: "angle-left"
    })), _react["default"].createElement("span", null, fragmentEntryLink.name)), _react["default"].createElement(_ResolvedCommentsToggle["default"], null), _react["default"].createElement("div", {
      "data-fragments-editor-item-id": fragmentEntryLink.fragmentEntryLinkId,
      "data-fragments-editor-item-type": _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment
    }, _react["default"].createElement(_AddCommentForm["default"], {
      fragmentEntryLinkId: fragmentEntryLink.fragmentEntryLinkId
    }), fragmentEntryLinkComments.map(function (_, i) {
      var comment = fragmentEntryLinkComments[fragmentEntryLinkComments.length - 1 - i];
      return _react["default"].createElement(_FragmentComment["default"], {
        comment: comment,
        fragmentEntryLinkId: fragmentEntryLink.fragmentEntryLinkId,
        key: comment.commentId,
        onDelete: deleteComment,
        onEdit: editComment,
        onEditReply: editCommentReply
      });
    })));
  };

  exports.FragmentComments = FragmentComments;

  var getActions = function getActions(dispatch, ownProps) {
    return {
      clearActiveItem: function clearActiveItem() {
        return dispatch({
          type: _actions.CLEAR_ACTIVE_ITEM
        });
      },
      deleteComment: function deleteComment(comment) {
        return dispatch((0, _deleteFragmentEntryLinkComment.deleteFragmentEntryLinkCommentAction)(ownProps.fragmentEntryLink.fragmentEntryLinkId, comment));
      },
      editComment: function editComment(comment) {
        return dispatch((0, _updateFragmentEntryLinkComment.updateFragmentEntryLinkCommentAction)(ownProps.fragmentEntryLink.fragmentEntryLinkId, comment));
      },
      editCommentReply: function editCommentReply(parentCommentId) {
        return function (comment) {
          return dispatch((0, _updateFragmentEntryLinkCommentReply.updateFragmentEntryLinkCommentReplyAction)(ownProps.fragmentEntryLink.fragmentEntryLinkId, parentCommentId, comment));
        };
      }
    };
  };

  var _default = FragmentComments;
  exports["default"] = _default;
  //# sourceMappingURL=FragmentComments.es.js.map
});
//# sourceMappingURL=FragmentComments.es.js.map