Liferay.Loader.define("layout-content-page-editor-web@1.0.126/js/components/fragment_entry_link/FragmentEntryLinkContent.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', '../../store/ConnectedComponent.es', '../../utils/FragmentsEditorComponentUtils.es', '../../utils/FragmentsEditorUpdateUtils.es', '../../utils/constants', './FragmentEditableBackgroundImage.es', './FragmentEditableField.es', './FragmentEntryLinkContent.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.FragmentEntryLinkContent = exports.ConnectedFragmentEntryLinkContent = void 0;

  var _metal = require("frontend-js-metal-web$metal");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalDom = require("frontend-js-metal-web$metal-dom");

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _ConnectedComponent = require("../../store/ConnectedComponent.es");

  var _FragmentsEditorComponentUtils = require("../../utils/FragmentsEditorComponentUtils.es");

  var _FragmentsEditorUpdateUtils = require("../../utils/FragmentsEditorUpdateUtils.es");

  var _constants = require("../../utils/constants");

  var _FragmentEditableBackgroundImage = _interopRequireDefault(require("./FragmentEditableBackgroundImage.es"));

  var _FragmentEditableField = _interopRequireDefault(require("./FragmentEditableField.es"));

  var _FragmentEntryLinkContent = _interopRequireDefault(require("./FragmentEntryLinkContent.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Creates a Fragment Entry Link Content component.
   * @review
   */
  var FragmentEntryLinkContent = /*#__PURE__*/function (_Component) {
    _inherits(FragmentEntryLinkContent, _Component);

    function FragmentEntryLinkContent() {
      _classCallCheck(this, FragmentEntryLinkContent);

      return _possibleConstructorReturn(this, _getPrototypeOf(FragmentEntryLinkContent).apply(this, arguments));
    }

    _createClass(FragmentEntryLinkContent, [{
      key: "disposed",

      /**
       * @inheritDoc
       */
      value: function disposed() {
        this._destroyEditables();
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "prepareStateForRender",
      value: function prepareStateForRender(state) {
        var nextState = state;

        if (state.languageId && Liferay.Language.direction) {
          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_languageDirection'], Liferay.Language.direction[state.languageId] || 'ltr');
        }

        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['content'], this.content ? _metalSoy["default"].toIncDom(this.content) : null);
        return nextState;
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "rendered",
      value: function rendered() {
        var _this = this;

        requestAnimationFrame(function () {
          if (_this.content) {
            _this._renderContent(_this.content, {
              evaluateJs: true
            });
          }
        });
      }
      /**
       * @inheritdoc
       * @return {boolean}
       * @review
       */

    }, {
      key: "shouldUpdate",
      value: function shouldUpdate(changes) {
        return (0, _FragmentsEditorComponentUtils.shouldUpdateOnChangeProperties)(changes, ['content', 'languageId', 'segmentsExperienceId', 'selectedMappingTypes', 'showMapping']);
      }
      /**
       * Renders the content if it is changed.
       * @inheritDoc
       * @param {string} newContent The new content to render.
       * @param {string} prevContent
       */

    }, {
      key: "syncContent",
      value: function syncContent(newContent, prevContent) {
        var _this2 = this;

        if (newContent && newContent !== prevContent) {
          requestAnimationFrame(function () {
            _this2._renderContent(newContent, {
              evaluateJs: true
            });
          });
        }
      }
      /**
       * Handles changes to editable values.
       * @inheritDoc
       * @param {object} newEditableValues The updated values.
       * @param {object} oldEditableValues The original values.
       */

    }, {
      key: "syncEditableValues",
      value: function syncEditableValues(newEditableValues, oldEditableValues) {
        if (newEditableValues !== oldEditableValues) {
          if (this._editables) {
            this._editables.forEach(function (editable) {
              var editableValues = newEditableValues[editable.processor] && newEditableValues[editable.processor][editable.editableId] ? newEditableValues[editable.processor][editable.editableId] : {
                defaultValue: editable.content
              };
              editable.editableValues = editableValues;
            });
          }

          this._update({
            defaultLanguageId: this.defaultLanguageId,
            defaultSegmentsExperienceId: this.defaultSegmentsExperienceId,
            languageId: this.languageId,
            segmentsExperienceId: this.segmentsExperienceId,
            updateFunctions: []
          });
        }
      }
      /**
       * Propagates the store to editable fields when it's loaded.
       */

    }, {
      key: "syncStore",
      value: function syncStore() {
        var _this3 = this;

        if (this._editables) {
          this._editables.forEach(function (editable) {
            editable.store = _this3.store;
          });
        }
      }
      /**
       * Creates instances of a fragment editable field for each editable.
       */

    }, {
      key: "_createEditables",
      value: function _createEditables() {
        var _this4 = this;

        this._destroyEditables();

        var backgroundImageEditables = Array.from(this.refs.content.querySelectorAll('[data-lfr-background-image-id]')).map(function (element) {
          var editableId = element.dataset.lfrBackgroundImageId;
          var editableValues = _this4.editableValues[_constants.BACKGROUND_IMAGE_FRAGMENT_ENTRY_PROCESSOR] && _this4.editableValues[_constants.BACKGROUND_IMAGE_FRAGMENT_ENTRY_PROCESSOR][editableId] ? _this4.editableValues[_constants.BACKGROUND_IMAGE_FRAGMENT_ENTRY_PROCESSOR][editableId] : {
            defaultValue: ''
          };
          return new _FragmentEditableBackgroundImage["default"]({
            editableId: editableId,
            editableValues: editableValues,
            element: element,
            fragmentEntryLinkId: _this4.fragmentEntryLinkId,
            processor: _constants.BACKGROUND_IMAGE_FRAGMENT_ENTRY_PROCESSOR,
            showMapping: _this4.showMapping,
            store: _this4.store
          });
        });
        var editableFields = Array.from(this.refs.content.querySelectorAll('lfr-editable')).map(function (editable) {
          var editableValues = _this4.editableValues[_constants.EDITABLE_FRAGMENT_ENTRY_PROCESSOR] && _this4.editableValues[_constants.EDITABLE_FRAGMENT_ENTRY_PROCESSOR][editable.id] ? _this4.editableValues[_constants.EDITABLE_FRAGMENT_ENTRY_PROCESSOR][editable.id] : {
            defaultValue: editable.innerHTML
          };

          var defaultEditorConfiguration = _this4.defaultEditorConfigurations[editable.getAttribute('type')] || _this4.defaultEditorConfigurations.text;

          return new _FragmentEditableField["default"]({
            content: editable.innerHTML,
            editableId: editable.id,
            editableValues: editableValues,
            element: editable,
            fragmentEntryLinkId: _this4.fragmentEntryLinkId,
            processor: _constants.EDITABLE_FRAGMENT_ENTRY_PROCESSOR,
            processorsOptions: {
              defaultEditorConfiguration: defaultEditorConfiguration,
              imageSelectorURL: _this4.imageSelectorURL
            },
            segmentsExperienceId: _this4.segmentsExperienceId,
            showMapping: _this4.showMapping,
            store: _this4.store,
            type: editable.getAttribute('type')
          });
        });
        this._editables = [].concat(_toConsumableArray(backgroundImageEditables), _toConsumableArray(editableFields));
      }
      /**
       * Destroys existing fragment editable field instances.
       */

    }, {
      key: "_destroyEditables",
      value: function _destroyEditables() {
        if (this._editables) {
          this._editables.forEach(function (editable) {
            return editable.dispose();
          });

          this._editables = [];
        }
      }
      /**
       * @param {MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleFragmentEntryLinkContentClick",
      value: function _handleFragmentEntryLinkContentClick(event) {
        var element = event.srcElement;

        if ((0, _metalDom.closest)(element, '[href]') && !('lfrPageEditorHrefEnabled' in element.dataset)) {
          event.preventDefault();
        }
      }
      /**
       * Parses and renders the fragment entry link content with AUI.
       * @param {string} content
       * @param {object} [options={}]
       * @param {boolean} [options.evaluateJs]
       * @private
       * @review
       */

    }, {
      key: "_renderContent",
      value: function _renderContent(content) {
        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

        if (content && this.refs.content) {
          this.refs.content.innerHTML = content;

          if (options.evaluateJs) {
            _metalDom.globalEval.runScriptsInElement(this.refs.content);
          }

          if (this.editableValues) {
            this._createEditables();

            this._update({
              defaultLanguageId: this.defaultLanguageId,
              defaultSegmentsExperienceId: this.defaultSegmentsExperienceId,
              languageId: this.languageId,
              segmentsExperienceId: this.segmentsExperienceId,
              updateFunctions: []
            });
          }
        }
      }
      /**
       * Runs a set of update functions through the editable values inside this
       * fragment entry link.
       * @param {string} languageId The current language ID.
       * @param {string} defaultLanguageId The default language ID.
       * @param {Array<Function>} updateFunctions The set of update functions to
       * execute for each editable value.
       * @private
       */

    }, {
      key: "_update",
      value: function _update(_ref) {
        var defaultLanguageId = _ref.defaultLanguageId,
            defaultSegmentsExperienceId = _ref.defaultSegmentsExperienceId,
            languageId = _ref.languageId,
            segmentsExperienceId = _ref.segmentsExperienceId,
            updateFunctions = _ref.updateFunctions;
        var editableValues = this.editableValues[_constants.EDITABLE_FRAGMENT_ENTRY_PROCESSOR] || {};
        Object.keys(editableValues).forEach(function (editableId) {
          var editableValue = editableValues[editableId];
          var segmentedEditableValue = segmentsExperienceId && editableValue[segmentsExperienceId] || editableValue[defaultSegmentsExperienceId];
          var defaultSegmentedEditableValue = editableValue[defaultSegmentsExperienceId];
          var defaultValue = segmentedEditableValue && segmentedEditableValue[defaultLanguageId] || segmentedEditableValue && segmentedEditableValue.defaultValue || defaultSegmentedEditableValue && defaultSegmentedEditableValue[defaultLanguageId] || editableValue.defaultValue;
          var mappedField = editableValue.mappedField || '';
          var value = segmentedEditableValue && segmentedEditableValue[languageId];
          updateFunctions.forEach(function (updateFunction) {
            return updateFunction(editableId, value, defaultValue, mappedField);
          });
        });
      }
    }]);

    return FragmentEntryLinkContent;
  }(_metalComponent["default"]);
  /**
   * State definition.
   * @static
   * @type {!Object}
   */

  exports.FragmentEntryLinkContent = FragmentEntryLinkContent;
  FragmentEntryLinkContent.STATE = {
    /**
     * Fragment content to be rendered.
     * @default ''
     * @instance
     * @memberOf FragmentEntryLink
     * @type {string}
     */
    content: _metalState.Config.any().setter(function (content) {
      return !(0, _metal.isFunction)(content) && (0, _metal.isObject)(content) ? content.value.content : content;
    }).value(''),

    /**
     * Editable values that should be used instead of the default ones inside
     * editable fields.
     * @default undefined
     * @instance
     * @memberOf FragmentEntryLink
     * @type {!Object}
     */
    editableValues: _metalState.Config.object().required(),

    /**
     * Fragment entry link ID.
     * @default undefined
     * @instance
     * @memberOf FragmentEntryLinkContent
     * @type {!string}
     */
    fragmentEntryLinkId: _metalState.Config.string().required(),

    /**
     * If <code>true</code>, the asset mapping is enabled.
     * @default false
     * @instance
     * @memberOf FragmentEntryLink
     * @type {boolean}
     */
    showMapping: _metalState.Config.bool().value(false)
  };
  var ConnectedFragmentEntryLinkContent = (0, _ConnectedComponent.getConnectedComponent)(FragmentEntryLinkContent, ['defaultEditorConfigurations', 'defaultLanguageId', 'defaultSegmentsExperienceId', 'imageSelectorURL', 'languageId', 'portletNamespace', 'selectedMappingTypes', 'segmentsExperienceId', 'spritemap']);
  exports.ConnectedFragmentEntryLinkContent = ConnectedFragmentEntryLinkContent;

  _metalSoy["default"].register(ConnectedFragmentEntryLinkContent, _FragmentEntryLinkContent["default"]);

  var _default = ConnectedFragmentEntryLinkContent;
  exports["default"] = _default;
  //# sourceMappingURL=FragmentEntryLinkContent.es.js.map
});
//# sourceMappingURL=FragmentEntryLinkContent.es.js.map