Liferay.Loader.define("layout-content-page-editor-web@1.0.126/js/components/fragment_entry_link/FragmentEditableFieldTooltip.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-position', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', '../../store/ConnectedComponent.es', './FragmentEditableFieldTooltip.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.FragmentEditableFieldTooltip = exports.ConnectedFragmentEditableFieldTooltip = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalPosition = require("frontend-js-metal-web$metal-position");

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _ConnectedComponent = require("../../store/ConnectedComponent.es");

  var _FragmentEditableFieldTooltip = _interopRequireDefault(require("./FragmentEditableFieldTooltip.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * @type number
   */
  var WINDOW_RESIZE_DEBOUNCE_DELAY = 100;
  /**
   * Creates a Fragment Editable Field Tooltip component.
   */

  var FragmentEditableFieldTooltip = /*#__PURE__*/function (_Component) {
    _inherits(FragmentEditableFieldTooltip, _Component);

    function FragmentEditableFieldTooltip() {
      _classCallCheck(this, FragmentEditableFieldTooltip);

      return _possibleConstructorReturn(this, _getPrototypeOf(FragmentEditableFieldTooltip).apply(this, arguments));
    }

    _createClass(FragmentEditableFieldTooltip, [{
      key: "attached",

      /**
       * @inheritDoc
       */
      value: function attached() {
        this._alignTooltip();
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "created",
      value: function created() {
        this._handleDocumentClick = this._handleDocumentClick.bind(this);
        this._handleFragmentEntryLinkListWrapperScroll = this._handleFragmentEntryLinkListWrapperScroll.bind(this);
        this._handleWindowResize = (0, _frontendJsWeb.debounce)(this._handleWindowResize.bind(this), WINDOW_RESIZE_DEBOUNCE_DELAY);
        this._windowResizeHandler = _metalDom["default"].on(window, 'resize', this._handleWindowResize);
        this._documentClickHandler = _metalDom["default"].on(document.body, 'click', this._handleDocumentClick);
        var fragmentEntryLinkListWrapper = document.querySelector('.fragment-entry-link-list-wrapper');

        if (fragmentEntryLinkListWrapper) {
          fragmentEntryLinkListWrapper.addEventListener('scroll', this._handleFragmentEntryLinkListWrapperScroll);
        }
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "disposed",
      value: function disposed() {
        this._documentClickHandler.removeListener();

        this._windowResizeHandler.removeListener();

        var fragmentEntryLinkListWrapper = document.querySelector('.fragment-entry-link-list-wrapper');

        if (fragmentEntryLinkListWrapper) {
          fragmentEntryLinkListWrapper.removeEventListener('scroll', this._handleFragmentEntryLinkListWrapperScroll);
        }
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "rendered",
      value: function rendered() {
        this._alignTooltip();
      }
      /**
       * Aligns the tooltip position for editable fields.
       *
       * @private
       */

    }, {
      key: "_alignTooltip",
      value: function _alignTooltip() {
        if (this.refs.tooltip) {
          _metalPosition.Align.align(this.refs.tooltip, this.alignElement, _metalPosition.Align.Top, false);
        }
      }
      /**
       * Handles a button click.
       *
       * @param {MouseEvent} event
       */

    }, {
      key: "_handleButtonClick",
      value: function _handleButtonClick(event) {
        var button = event.delegateTarget;
        var buttonId = button.dataset.tooltipButtonId;
        this.emit('buttonClick', {
          buttonId: buttonId
        });
      }
      /**
       * Hides the tooltip when a document click occurs outside the tooltip.
       *
       * @param {MouseEvent} event The document click.
       */

    }, {
      key: "_handleDocumentClick",
      value: function _handleDocumentClick(event) {
        if (this.refs.tooltip && !this.refs.tooltip.contains(event.target) && !this.alignElement.contains(event.target)) {
          this.emit('outsideTooltipClick');
        }
      }
      /**
       * Callback executed to align the tooltip when the window is resized.
       *
       * @private
       */

    }, {
      key: "_handleWindowResize",
      value: function _handleWindowResize() {
        this._alignTooltip();
      }
      /**
       * @private
       */

    }, {
      key: "_handleFragmentEntryLinkListWrapperScroll",
      value: function _handleFragmentEntryLinkListWrapperScroll() {
        this._alignTooltip();
      }
    }]);

    return FragmentEditableFieldTooltip;
  }(_metalComponent["default"]);
  /**
   * State definition.
   *
   * @static
   * @type {!Object}
   */

  exports.FragmentEditableFieldTooltip = FragmentEditableFieldTooltip;
  FragmentEditableFieldTooltip.STATE = {
    /**
     * Reference element the tooltip alignment is based on.
     *
     * @default undefined
     * @instance
     * @memberOf FragmentEditableFieldTooltip
     * @type {HTMLElement}
     */
    alignElement: _metalState.Config.object().required(),

    /**
     * List of buttons rendered inside the tooltip.
     *
     * @default undefined
     * @instance
     * @memberOf FragmentEditableFieldTooltip
     * @type {!Array<{
     *   id: !string,
     *   label: !string
     * }>}
     */
    buttons: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      icon: _metalState.Config.string().required(),
      id: _metalState.Config.string().required(),
      label: _metalState.Config.string().required()
    }))
  };
  var ConnectedFragmentEditableFieldTooltip = (0, _ConnectedComponent.getConnectedComponent)(FragmentEditableFieldTooltip, ['spritemap']);
  exports.ConnectedFragmentEditableFieldTooltip = ConnectedFragmentEditableFieldTooltip;

  _metalSoy["default"].register(ConnectedFragmentEditableFieldTooltip, _FragmentEditableFieldTooltip["default"]);

  var _default = ConnectedFragmentEditableFieldTooltip;
  exports["default"] = _default;
  //# sourceMappingURL=FragmentEditableFieldTooltip.es.js.map
});
//# sourceMappingURL=FragmentEditableFieldTooltip.es.js.map