Liferay.Loader.define("layout-content-page-editor-web@1.0.126/js/components/floating_toolbar/link/FloatingToolbarLinkPanel.es", ['module', 'exports', 'require', '../../common/AssetSelector.es', 'frontend-js-web', 'frontend-js-metal-web$metal-soy', './FloatingToolbarLinkPanelDelegateTemplate.soy', '../../../actions/actions.es', '../../../actions/saveChanges.es', '../../../store/ConnectedComponent.es', '../../../utils/FragmentsEditorDialogUtils', '../../../utils/FragmentsEditorGetUtils.es', '../../../utils/FragmentsEditorIdUtils.es', '../../../utils/FragmentsEditorUpdateUtils.es', '../../../utils/constants', './FloatingToolbarLinkPanel.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.FloatingToolbarLinkPanel = exports.ConnectedFloatingToolbarLinkPanel = void 0;

  require("../../common/AssetSelector.es");

  var _frontendJsWeb = require("frontend-js-web");

  var _metalSoy = _interopRequireWildcard(require("frontend-js-metal-web$metal-soy"));

  require("./FloatingToolbarLinkPanelDelegateTemplate.soy");

  var _actions = require("../../../actions/actions.es");

  var _saveChanges = require("../../../actions/saveChanges.es");

  var _ConnectedComponent = _interopRequireDefault(require("../../../store/ConnectedComponent.es"));

  var _FragmentsEditorDialogUtils = require("../../../utils/FragmentsEditorDialogUtils");

  var _FragmentsEditorGetUtils = require("../../../utils/FragmentsEditorGetUtils.es");

  var _FragmentsEditorIdUtils = require("../../../utils/FragmentsEditorIdUtils.es");

  var _FragmentsEditorUpdateUtils = require("../../../utils/FragmentsEditorUpdateUtils.es");

  var _constants = require("../../../utils/constants");

  var _FloatingToolbarLinkPanel = _interopRequireDefault(require("./FloatingToolbarLinkPanel.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * FloatingToolbarLinkPanel
   */
  var FloatingToolbarLinkPanel = /*#__PURE__*/function (_PortletBase) {
    _inherits(FloatingToolbarLinkPanel, _PortletBase);

    function FloatingToolbarLinkPanel() {
      _classCallCheck(this, FloatingToolbarLinkPanel);

      return _possibleConstructorReturn(this, _getPrototypeOf(FloatingToolbarLinkPanel).apply(this, arguments));
    }

    _createClass(FloatingToolbarLinkPanel, [{
      key: "created",

      /**
       * @inheritdoc
       * @review
       */
      value: function created() {
        this._handleInputHrefKeyUp = (0, _frontendJsWeb.debounce)(this._handleInputHrefKeyUp.bind(this), 400);
      }
      /**
       * @inheritdoc
       * @param {object} state
       * @return {object}
       * @review
       */

    }, {
      key: "prepareStateForRender",
      value: function prepareStateForRender(state) {
        var _this = this;

        var nextState = state;
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['mappedAssetEntries'], nextState.mappedAssetEntries.map(_FragmentsEditorIdUtils.encodeAssetId));
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_sourceTypeIds'], _constants.MAPPING_SOURCE_TYPE_IDS);

        if (nextState.mappingFieldsURL && nextState.selectedMappingTypes && nextState.selectedMappingTypes.type) {
          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_sourceTypes'], (0, _FragmentsEditorGetUtils.getMappingSourceTypes)(nextState.selectedMappingTypes.subtype ? nextState.selectedMappingTypes.subtype.label : nextState.selectedMappingTypes.type.label));
        }

        if (nextState.mappedAssetEntries && nextState._selectedAssetEntry && nextState._selectedAssetEntry.classNameId && nextState._selectedAssetEntry.classPK) {
          var mappedAssetEntry = nextState.mappedAssetEntries.find(function (assetEntry) {
            return nextState._selectedAssetEntry.classNameId === assetEntry.classNameId && nextState._selectedAssetEntry.classPK === assetEntry.classPK;
          });

          if (mappedAssetEntry) {
            nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['item', 'editableValues', 'config', 'title'], mappedAssetEntry.title);
            nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['item', 'editableValues', 'config', 'encodedId'], mappedAssetEntry);

            if (nextState.item.editableValues.config.fieldId && !nextState._mappedFieldValue) {
              var fieldId = nextState.item.editableValues.config.fieldId;

              this._getMappedValue(fieldId).then(function (fieldValue) {
                if (typeof fieldValue === 'string') {
                  _this._mappedFieldValue = fieldValue;
                }
              });
            }
          }
        }

        return nextState;
      }
      /**
       * @inheritdoc
       * @param {boolean} firstRender
       * @review
       */

    }, {
      key: "rendered",
      value: function rendered(firstRender) {
        if (firstRender) {
          if (this.item && this.item.editableValues.config) {
            this._inputURL = this.item.editableValues.config.href;
            this._selectedAssetEntry.classNameId = this.item.editableValues.config.classNameId;
            this._selectedAssetEntry.classPK = this.item.editableValues.config.classPK;
          }

          if (this.item && this.mappingFieldsURL && (!this.item.editableValues.config || !this.item.editableValues.config.classNameId)) {
            this._selectedSourceTypeId = _constants.MAPPING_SOURCE_TYPE_IDS.structure;
          } else {
            this._selectedSourceTypeId = _constants.MAPPING_SOURCE_TYPE_IDS.content;
          }
        }
      }
      /**
       * @param {{editableValues: object}} newItem
       * @param {{editableValues: object}} [oldItem]
       * @inheritdoc
       * @review
       */

    }, {
      key: "syncItem",
      value: function syncItem(newItem, oldItem) {
        if (newItem && oldItem && newItem.editableValues.config && oldItem.editableValues.config) {
          var newConfig = newItem.editableValues.config;
          var oldConfig = oldItem.editableValues.config;

          if (newConfig.classNameId !== oldConfig.classNameId || newConfig.classPK !== oldConfig.classPK || this._fields.length === 0) {
            this._loadFields();
          }
        } else {
          this._loadFields();
        }
      }
      /**
       * Clears fields
       * @private
       * @review
       */

    }, {
      key: "_clearFields",
      value: function _clearFields() {
        this._fields = [];
      }
      /**
       * Clears row config
       * @private
       * @review
       */

    }, {
      key: "_clearRowConfig",
      value: function _clearRowConfig() {

        this._updateRowConfig({
          classNameId: '',
          classPK: '',
          fieldId: '',
          href: '',
          mappedField: '',
          mapperType: 'link'
        });
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_focusPanel",
      value: function _focusPanel() {
        var _this2 = this;

        requestAnimationFrame(function () {
          if (_this2.refs.panel) {
            _this2.refs.panel.focus();
          }
        });
      }
    }, {
      key: "_getMappedValue",
      value: function _getMappedValue(fieldId) {
        if (fieldId) {
          return this.fetch(this.getAssetFieldValueURL, {
            classNameId: this._selectedAssetEntry.classNameId,
            classPK: this._selectedAssetEntry.classPK,
            fieldId: fieldId
          }).then(function (response) {
            return response.json();
          }).then(function (response) {
            return response.fieldValue;
          });
        }
      }
      /**
       * @param {MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleAssetBrowserLinkClick",
      value: function _handleAssetBrowserLinkClick(event) {
        var _this3 = this;

        var _event$delegateTarget = event.delegateTarget.dataset,
            assetBrowserUrl = _event$delegateTarget.assetBrowserUrl,
            assetBrowserWindowTitle = _event$delegateTarget.assetBrowserWindowTitle;
        (0, _FragmentsEditorDialogUtils.openAssetBrowser)({
          assetBrowserURL: assetBrowserUrl,
          callback: function callback(selectedAssetEntry) {
            _this3._selectAssetEntry(selectedAssetEntry);

            _this3._focusPanel();
          },
          eventName: "".concat(this.portletNamespace, "selectAsset"),
          modalTitle: assetBrowserWindowTitle,
          portletNamespace: this.portletNamespace
        });
      }
      /**
       * @param {MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleAssetEntryLinkClick",
      value: function _handleAssetEntryLinkClick(event) {
        var data = event.delegateTarget.dataset;

        this._selectAssetEntry({
          classNameId: data.classNameId,
          classPK: data.classPk
        });

        this._focusPanel();
      }
      /**
       * Handle field option change
       * @param {Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleFieldOptionChange",
      value: function _handleFieldOptionChange(event) {
        var _this4 = this;

        var fieldId = event.delegateTarget.value;

        if (fieldId === '') {
          this._clearRowConfig();
        } else {
          var config = {
            classNameId: this._selectedAssetEntry.classNameId,
            classPK: this._selectedAssetEntry.classPK,
            href: '',
            mapperType: 'link'
          };

          if (this._selectedSourceTypeId === _constants.MAPPING_SOURCE_TYPE_IDS.content) {
            config.fieldId = fieldId;
          } else if (this._selectedSourceTypeId === _constants.MAPPING_SOURCE_TYPE_IDS.structure) {
            config.mappedField = fieldId;
          }

          this._updateRowConfig(config);

          if (!fieldId || this._selectedSourceTypeId === _constants.MAPPING_SOURCE_TYPE_IDS.structure) {
            this._mappedFieldValue = '';
          } else {
            this._getMappedValue(fieldId).then(function (fieldValue) {
              if (typeof fieldValue === 'string') {
                _this4._mappedFieldValue = fieldValue;

                _this4._updateRowConfig({
                  href: fieldValue
                });
              }
            });
          }
        }
      }
      /**
       * Callback executed on href keyup
       * @param {object} event
       * @private
       * @review
       */

    }, {
      key: "_handleInputHrefKeyUp",
      value: function _handleInputHrefKeyUp(event) {
        var hrefElement = event.target;
        var config = {
          classNameId: '',
          classPK: '',
          fieldId: '',
          href: hrefElement.value,
          mappedField: '',
          mapperType: 'link'
        };

        this._updateRowConfig(config);
      }
      /**
       * Handle source option change
       * @param {Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleSourceTypeChange",
      value: function _handleSourceTypeChange(event) {
        this._selectedSourceTypeId = event.delegateTarget.value;

        this._clearFields();

        this._clearRowConfig();
      }
      /**
       * @param {object} event
       * @private
       * @review
       */

    }, {
      key: "_handleSubmit",
      value: function _handleSubmit(event) {
        event.preventDefault();
        event.stopPropagation();
      }
      /**
       * Load the list of fields
       * @private
       * @review
       */

    }, {
      key: "_loadFields",
      value: function _loadFields() {
        var _this5 = this;

        var promise;

        this._clearFields();

        if (this._selectedSourceTypeId === _constants.MAPPING_SOURCE_TYPE_IDS.structure && this.selectedMappingTypes.type) {
          var data = {
            classNameId: this.selectedMappingTypes.type.id
          };

          if (this.selectedMappingTypes.subtype) {
            data.classTypeId = this.selectedMappingTypes.subtype.id;
          }

          promise = this.fetch(this.mappingFieldsURL, data);
        } else if (this._selectedSourceTypeId === _constants.MAPPING_SOURCE_TYPE_IDS.content && this._selectedAssetEntry.classNameId && this._selectedAssetEntry.classPK) {
          promise = this.fetch(this.getAssetMappingFieldsURL, {
            classNameId: this._selectedAssetEntry.classNameId,
            classPK: this._selectedAssetEntry.classPK
          });
        }

        if (promise) {
          promise.then(function (response) {
            return response.json();
          }).then(function (response) {
            _this5._fields = response.filter(function (field) {
              return ['text', 'url'].includes(field.type);
            });
          });
        } else if (this._fields.length) {
          this._clearFields();
        }
      }
      /**
       * @param {object} assetEntry
       * @param {string} assetEntry.classNameId
       * @param {string} assetEntry.classPK
       * @private
       * @review
       */

    }, {
      key: "_selectAssetEntry",
      value: function _selectAssetEntry(assetEntry) {
        this._selectedAssetEntry = assetEntry;
        this.store.dispatch(_objectSpread({}, this._selectedAssetEntry, {
          type: _actions.ADD_MAPPED_ASSET_ENTRY
        }));

        this._loadFields();
      }
      /**
       * Updates row configuration
       * @param {object} config Row configuration
       * @private
       * @review
       */

    }, {
      key: "_updateRowConfig",
      value: function _updateRowConfig(config) {
        this.store.dispatch((0, _saveChanges.enableSavingChangesStatusAction)()).dispatch({
          config: config,
          editableId: this.item.editableId,
          fragmentEntryLinkId: this.item.fragmentEntryLinkId,
          type: _actions.UPDATE_CONFIG_ATTRIBUTES
        }).dispatch((0, _saveChanges.updateLastSaveDateAction)()).dispatch((0, _saveChanges.disableSavingChangesStatusAction)());
      }
      /**
       * Handle button type option change
       * @param {Event} event
       */

    }, {
      key: "_handleTargetOptionChange",
      value: function _handleTargetOptionChange(event) {
        var targetElement = event.delegateTarget;
        var config = {
          target: targetElement.options[targetElement.selectedIndex].value
        };

        this._updateRowConfig(config);
      }
      /**
       * Handle link type option change
       * @param {Event} event
       */

    }, {
      key: "_handleTypeOptionChange",
      value: function _handleTypeOptionChange(event) {
        var targetElement = event.delegateTarget;
        var type = targetElement.options[targetElement.selectedIndex].value;


        this._clearFields();

        this._updateRowConfig({
          classNameId: '',
          classPK: '',
          fieldId: '',
          href: '',
          mappedField: '',
          mapperType: 'link',
          type: type
        });
      }
    }]);

    return FloatingToolbarLinkPanel;
  }(_frontendJsWeb.PortletBase);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.FloatingToolbarLinkPanel = FloatingToolbarLinkPanel;
  FloatingToolbarLinkPanel.STATE = {
    /**
     * @default []
     * @memberOf FloatingToolbarLinkPanel
     * @private
     * @review
     * @type {object[]}
     */
    _fields: _metalSoy.Config.array().internal().value([]),

    /**
     * link input value
     * @private
     * @review
     * @type {string}
     */
    _inputURL: _metalSoy.Config.internal().string(),

    /**
     * Mapped asset field value
     * @instance
     * @memberOf FloatingToolbarLinkPanel
     * @private
     * @review
     * @type {string}
     */
    _mappedFieldValue: _metalSoy.Config.internal().string(),

    /**
     * @default undefined
     * @memberof FloatingToolbarLinkPanel
     * @review
     * @type {string}
     */
    _selectedAssetEntry: _metalSoy.Config.object().internal().value({}),

    /**
     * @default undefined
     * @memberof FloatingToolbarLinkPanel
     * @review
     * @type {string}
     */
    _selectedSourceTypeId: _metalSoy.Config.oneOf(Object.values(_constants.MAPPING_SOURCE_TYPE_IDS)).internal(),

    /**
     * @default TARGET_TYPES
     * @memberOf FloatingToolbarLinkPanel
     * @private
     * @review
     * @type {object[]}
     */
    _targetTypes: _metalSoy.Config.array().internal().value(_constants.TARGET_TYPES),

    /**
     * @default undefined
     * @memberof FloatingToolbarLinkPanel
     * @review
     * @type {object}
     */
    item: _metalSoy.Config.object().value(null),

    /**
     * @default undefined
     * @memberof FloatingToolbarLinkPanel
     * @review
     * @type {!string}
     */
    itemId: _metalSoy.Config.string().required(),

    /**
     * @default undefined
     * @memberof FloatingToolbarLinkPanel
     * @review
     * @type {object}
     */
    store: _metalSoy.Config.object().value(null)
  };
  var ConnectedFloatingToolbarLinkPanel = (0, _ConnectedComponent["default"])(FloatingToolbarLinkPanel, ['assetBrowserLinks', 'getAssetFieldValueURL', 'getAssetMappingFieldsURL', 'mappedAssetEntries', 'mappingFieldsURL', 'portletNamespace', 'selectedMappingTypes', 'spritemap']);
  exports.ConnectedFloatingToolbarLinkPanel = ConnectedFloatingToolbarLinkPanel;

  _metalSoy["default"].register(ConnectedFloatingToolbarLinkPanel, _FloatingToolbarLinkPanel["default"]);

  var _default = ConnectedFloatingToolbarLinkPanel;
  exports["default"] = _default;
  //# sourceMappingURL=FloatingToolbarLinkPanel.es.js.map
});
//# sourceMappingURL=FloatingToolbarLinkPanel.es.js.map