Liferay.Loader.define("layout-content-page-editor-web@1.0.126/js/components/floating_toolbar/FloatingToolbar.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-position', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', '../../store/ConnectedComponent.es', '../../utils/FragmentsEditorUpdateUtils.es', './FloatingToolbar.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.FloatingToolbar = exports.ConnectedFloatingToolbar = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalPosition = require("frontend-js-metal-web$metal-position");

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _ConnectedComponent = _interopRequireDefault(require("../../store/ConnectedComponent.es"));

  var _FragmentsEditorUpdateUtils = require("../../utils/FragmentsEditorUpdateUtils.es");

  var _FloatingToolbar = _interopRequireDefault(require("./FloatingToolbar.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * @type {object}
   */
  var FIXED_PANEL_CLASS = 'fragments-editor__floating-toolbar-panel--fixed';
  /**
   * @type {object}
   */

  var ELEMENT_AVAILABLE_POSITIONS = {
    bottom: [_metalPosition.Align.Bottom, _metalPosition.Align.BottomCenter, _metalPosition.Align.BottomLeft, _metalPosition.Align.BottomRight],
    left: [_metalPosition.Align.BottomLeft, _metalPosition.Align.Left, _metalPosition.Align.LeftCenter, _metalPosition.Align.TopRight],
    right: [_metalPosition.Align.BottomRight, _metalPosition.Align.Right, _metalPosition.Align.RightCenter, _metalPosition.Align.TopRight],
    top: [_metalPosition.Align.Top, _metalPosition.Align.TopCenter, _metalPosition.Align.TopLeft, _metalPosition.Align.TopRight]
  };
  /**
   * @type {object}
   */

  var ELEMENT_POSITION = {
    bottom: {
      left: _metalPosition.Align.BottomLeft,
      right: _metalPosition.Align.BottomRight
    },
    top: {
      left: _metalPosition.Align.TopLeft,
      right: _metalPosition.Align.TopRight
    }
  };
  /**
   * FloatingToolbar
   */

  var FloatingToolbar = /*#__PURE__*/function (_Component) {
    _inherits(FloatingToolbar, _Component);

    function FloatingToolbar() {
      _classCallCheck(this, FloatingToolbar);

      return _possibleConstructorReturn(this, _getPrototypeOf(FloatingToolbar).apply(this, arguments));
    }

    _createClass(FloatingToolbar, [{
      key: "created",

      /**
       * @inheritdoc
       * @review
       */
      value: function created() {
        this._defaultButtonClicked = this._defaultButtonClicked.bind(this);
        this._handleWindowResize = this._handleWindowResize.bind(this);
        this._handleWrapperScroll = this._handleWrapperScroll.bind(this);
        this._lastSelectedPanelId = this.selectedPanelId;
        this._managementBarHeight = FloatingToolbar._getElementHeight('.management-bar');
        this._productMenuHeight = FloatingToolbar._getElementHeight('.control-menu');
        window.addEventListener('resize', this._handleWindowResize);
        this._wrapper = document.querySelector('.fragment-entry-link-list-wrapper');

        this._wrapper.addEventListener('scroll', this._handleWrapperScroll);
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "attached",
      value: function attached() {
        this.addListener('buttonClicked', this._defaultButtonClicked, true);
      }
      /**
       * @inheritdoc
       * @review
       */

    }, {
      key: "disposed",
      value: function disposed() {
        window.removeEventListener('resize', this._handleWindowResize);

        this._wrapper.removeEventListener('scroll', this._handleWrapperScroll);
      }
      /**
       * @inheritdoc
       * @review
       */

    }, {
      key: "prepareStateForRender",
      value: function prepareStateForRender(state) {
        var nextState = state;
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['selectedPanelId'], this._isAnchorElementVisible() ? state.selectedPanelId : null);
        return nextState;
      }
      /**
       * @inheritdoc
       * @review
       */

    }, {
      key: "rendered",
      value: function rendered() {
        var _this = this;

        this._setFixedPanelClass();

        requestAnimationFrame(function () {
          _this._align();
        });
      }
      /**
       * @inheritdoc
       * @review
       */

    }, {
      key: "syncSelectedPanelId",
      value: function syncSelectedPanelId() {
        var _this2 = this;

        requestAnimationFrame(function () {
          if (_this2.refs.selectedPanel) {
            _this2.refs.selectedPanel.on('clearEditor', function () {
              return _this2.emit('clearEditor');
            });

            _this2.refs.selectedPanel.on('createProcessor', function () {
              return _this2.emit('createProcessor');
            });
          }
        });
      }
      /**
       * Select or deselect panel. Default handler for button clicked event.
       * @param {Event} event
       * @param {Object} data
       * @private
       */

    }, {
      key: "_defaultButtonClicked",
      value: function _defaultButtonClicked(event, data) {
        var panelId = data.panelId;

        if (!event.defaultPrevented) {
          if (this.selectedPanelId === panelId) {
            this.selectedPanelId = null;
          } else {
            this.selectedPanelId = panelId;
            this._lastSelectedPanelId = panelId;
          }
        }
      }
      /**
       * Controls the visibility of the panel.
       * The panel will be shown only when the anchor element is visible
       * @private
       * @review
       */

    }, {
      key: "_handlePanelVisibilityOnScroll",
      value: function _handlePanelVisibilityOnScroll() {
        if (!this._isAnchorElementVisible()) {
          this.selectedPanelId = null;
        } else {
          if (this._lastSelectedPanelId && !this.selectedPanelId) {
            this.selectedPanelId = this._lastSelectedPanelId;
          }
        }
      }
      /**
       * Handle panel button click
       * @param {MouseEvent} event Click event
       */

    }, {
      key: "_handlePanelButtonClick",
      value: function _handlePanelButtonClick(event) {
        var _event$delegateTarget = event.delegateTarget.dataset,
            _event$delegateTarget2 = _event$delegateTarget.panelId,
            panelId = _event$delegateTarget2 === void 0 ? null : _event$delegateTarget2,
            type = _event$delegateTarget.type;
        this.emit('buttonClicked', event, {
          panelId: panelId,
          type: type
        });
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_handleWindowResize",
      value: function _handleWindowResize() {
        this._align();
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_handleWrapperScroll",
      value: function _handleWrapperScroll() {
        this._align();

        this._handlePanelVisibilityOnScroll();
      }
      /**
       * Check whether the anchor element is visible or not
       * @private
       * @review
       */

    }, {
      key: "_isAnchorElementVisible",
      value: function _isAnchorElementVisible() {
        if (this.anchorElement) {
          var anchorElementRect = this.anchorElement.getBoundingClientRect();
          var anchorElementY = anchorElementRect.y || anchorElementRect.top;
          var anchorElementBottom = anchorElementY + anchorElementRect.height;
          return anchorElementBottom > this._productMenuHeight + this._managementBarHeight;
        } else {
          return false;
        }
      }
      /**
       * Aligns the FloatingToolbar to the anchorElement
       * @private
       * @review
       */

    }, {
      key: "_align",
      value: function _align() {
        var _this3 = this;

        AUI().use('portal-available-languages', function () {
          if (_this3.refs.buttons && _this3.anchorElement) {
            var buttonsAlign = FloatingToolbar._getElementAlign(_this3._wrapper, _this3.refs.panel || _this3.refs.buttons, _this3.anchorElement);

            _metalPosition.Align.align(_this3.refs.buttons, _this3.anchorElement, buttonsAlign, false);

            requestAnimationFrame(function () {
              _this3._alignPanel();
            });
          } else if (_this3.anchorElement) {
            _this3._alignPanel();
          }
        });
      }
      /**
       * Align FloatingToolbar panel to it's buttons or anchorElement
       * @private
       * @review
       */

    }, {
      key: "_alignPanel",
      value: function _alignPanel() {
        if (this.refs.panel && this.anchorElement) {
          var panelAlign = FloatingToolbar._getElementAlign(this._wrapper, this.refs.panel, this.refs.buttons || this.anchorElement);

          _metalPosition.Align.align(this.refs.panel, this.refs.buttons || this.anchorElement, panelAlign, false);
        }
      }
      /**
       * Add fixed CSS class to panel if buttons are not shown
       * @private
       * @review
       */

    }, {
      key: "_setFixedPanelClass",
      value: function _setFixedPanelClass() {
        if (this.refs.panel && !this.refs.buttons) {
          this.refs.panel.classList.add(FIXED_PANEL_CLASS);
        }
      }
    }], [{
      key: "_getElementAlign",

      /**
       * Gets a suggested align of an element to an anchor, following this logic:
       * - Vertically, if the element fits at bottom, it's placed there, otherwise
       *   it is placed at top.
       * - Horizontally, the element is placed depending on the anchor position
       *   relative to the wrapper.
       * @param {HTMLElement} wrapper
       * @param {HTMLElement|null} element
       * @param {HTMLElement|null} anchor
       * @private
       * @return {number} Selected align
       * @review
       */
      value: function _getElementAlign(wrapper, element, anchor) {
        var alignFits = function alignFits(align, availableAlign) {
          return availableAlign.includes(_metalPosition.Align.suggestAlignBestRegion(element, anchor, align).position);
        };

        var anchorRect = anchor.getBoundingClientRect();
        var fragmentEntryLinkListWidth = wrapper.offsetWidth;
        var horizontal = anchorRect.right > fragmentEntryLinkListWidth / 2 ? 'right' : 'left';
        var fallbackVertical = 'top';
        var vertical = 'bottom';

        if (!alignFits(ELEMENT_POSITION[vertical][horizontal], ELEMENT_AVAILABLE_POSITIONS[vertical]) && alignFits(ELEMENT_POSITION[fallbackVertical][horizontal], ELEMENT_AVAILABLE_POSITIONS[fallbackVertical])) {
          vertical = fallbackVertical;
        }

        return ELEMENT_POSITION[vertical][horizontal];
      }
      /**
       * Gets the height of the element matching the selector
       * Defaults to 0
       * @param {string} selector
       */

    }, {
      key: "_getElementHeight",
      value: function _getElementHeight(selector) {
        var element = document.querySelector(selector);

        if (element) {
          return element.offsetHeight;
        }

        return 0;
      }
    }]);

    return FloatingToolbar;
  }(_metalComponent["default"]);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.FloatingToolbar = FloatingToolbar;
  FloatingToolbar.STATE = {
    /**
     * Used for restoring the panel after hiding it
     * @default null
     * @instance
     * @memberOf FloatingToolbar
     * @private
     * @review
     * @type {string|null}
     */
    _lastSelectedPanelId: _metalState.Config.string().internal().value(null),

    /**
     * @default 0
     * @instance
     * @memberOf FloatingToolbar
     * @private
     * @review
     * @type {number}
     */
    _managementBarHeight: _metalState.Config.number().internal().value(0),

    /**
     * @default 0
     * @instance
     * @memberOf FloatingToolbar
     * @private
     * @review
     * @type {number}
     */
    _productMenuHeight: _metalState.Config.number().internal().value(0),

    /**
     * @default null
     * @instance
     * @memberof FloatingToolbar
     * @private
     * @review
     * @type {object}
     */
    _wrapper: _metalState.Config.object().internal().value(null),

    /**
     * Element where the floating toolbar is positioned with
     * @default undefined
     * @instance
     * @memberof FloatingToolbar
     * @review
     * @type {HTMLElement}
     */
    anchorElement: _metalState.Config.instanceOf(HTMLElement).required(),

    /**
     * List of available buttons.
     * @default undefined
     * @instance
     * @memberOf FloatingToolbar
     * @review
     * @type {object[]}
     */
    buttons: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      cssClass: _metalState.Config.string(),
      icon: _metalState.Config.string(),
      id: _metalState.Config.string(),
      panelId: _metalState.Config.string(),
      title: _metalState.Config.string(),
      type: _metalState.Config.string()
    })).required(),

    /**
     * If true, once a panel has been selected it cannot be changed
     * until selectedPanelId is set manually to null.
     * @default false
     * @instance
     * @memberof FloatingToolbar
     * @review
     * @type {boolean}
     */
    fixSelectedPanel: _metalState.Config.bool().value(false),

    /**
     * Selected panel ID.
     * @default null
     * @instance
     * @memberOf FloatingToolbar
     * @private
     * @review
     * @type {string|null}
     */
    selectedPanelId: _metalState.Config.string().internal().value(null)
  };
  var ConnectedFloatingToolbar = (0, _ConnectedComponent["default"])(FloatingToolbar, ['spritemap']);
  exports.ConnectedFloatingToolbar = ConnectedFloatingToolbar;

  _metalSoy["default"].register(ConnectedFloatingToolbar, _FloatingToolbar["default"]);

  var _default = ConnectedFloatingToolbar;
  exports["default"] = _default;
  //# sourceMappingURL=FloatingToolbar.es.js.map
});
//# sourceMappingURL=FloatingToolbar.es.js.map