Liferay.Loader.define("layout-content-page-editor-web@1.0.126/js/components/content/MapContentForm.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', '../../store/ConnectedComponent.es', '../../utils/FragmentsEditorGetUtils.es', '../../utils/constants', './MapContentForm.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.MapContentForm = exports.ConnectedMapContentForm = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _ConnectedComponent = _interopRequireDefault(require("../../store/ConnectedComponent.es"));

  var _FragmentsEditorGetUtils = require("../../utils/FragmentsEditorGetUtils.es");

  var _constants = require("../../utils/constants");

  var _MapContentForm = _interopRequireDefault(require("./MapContentForm.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * @param {string} html Removes HTML from the given text
   * @return {string} Plain text
   * @review
   */
  var stripHTML = function stripHTML(html) {
    var div = document.createElement('div');
    div.innerHTML = html;
    return div.innerText;
  };
  /**
   * MapContentForm
   */

  var MapContentForm = /*#__PURE__*/function (_PortletBase) {
    _inherits(MapContentForm, _PortletBase);

    function MapContentForm() {
      _classCallCheck(this, MapContentForm);

      return _possibleConstructorReturn(this, _getPrototypeOf(MapContentForm).apply(this, arguments));
    }

    _createClass(MapContentForm, [{
      key: "prepareStateForRender",

      /**
       * @inheritdoc
       * @review
       */
      value: function prepareStateForRender(state) {
        if (state._structureLabel === '') {
          state._structureLabel = Liferay.Util.sub(Liferay.Language.get('map-the-selected-content-to-the-x-structure-fields'), this.ddmStructure.label);
        }

        return state;
      }
      /**
       * @inheritdoc
       * @review
       */

    }, {
      key: "syncSelectedItems",
      value: function syncSelectedItems() {
        var _this = this;

        if (this.selectedItems) {
          this.selectedItems = this.selectedItems.filter(function (selectedItem) {
            return selectedItem.itemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.editable;
          }).map(function (selectedItem) {
            var itemPath = (0, _FragmentsEditorGetUtils.getItemPath)(selectedItem.itemId, selectedItem.itemType, _this.layoutData.structure);
            var fragmentEntryLinkId = itemPath.find(function (activeItem) {
              return activeItem.itemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment;
            }).itemId;
            var fragmentEntryLink = _this.fragmentEntryLinks[fragmentEntryLinkId];
            var editableValues = fragmentEntryLink.editableValues[_constants.EDITABLE_FRAGMENT_ENTRY_PROCESSOR] || {};
            var languageId = _this.languageId || _this.defaultLanguageId;
            var segmentsExperienceId = "segments-experience-id-".concat(_this.segmentsExperienceId || _this.defaultSegmentsExperienceId);
            var editableId = selectedItem.itemId.split('-').slice(1).join('-');
            selectedItem.editableId = editableId;
            selectedItem.fragmentEntryLinkId = fragmentEntryLinkId;
            selectedItem.itemValue = editableValues[editableId][segmentsExperienceId] ? editableValues[editableId][segmentsExperienceId][languageId] : editableValues[editableId].defaultValue.trim();

            if (selectedItem.itemValue.url) {
              selectedItem.itemValue = selectedItem.itemValue.url;
              selectedItem.displayValue = stripHTML(selectedItem.itemValue.title ? selectedItem.itemValue.title : selectedItem.itemValue);
            } else {
              selectedItem.displayValue = stripHTML(selectedItem.itemValue);
            }

            return selectedItem;
          });
        }
      }
    }, {
      key: "_handleFieldChange",
      value: function _handleFieldChange(event) {
        var targetElement = event.delegateTarget;
        var fieldKey = targetElement.options[targetElement.selectedIndex].value;
        var editableId = targetElement.dataset.itemEditableId;
        var fragmentEntryLinkId = targetElement.dataset.itemFragmentEntryLinkId;
        var newFields = this.fields.map(function (field) {
          var newField = _objectSpread({}, field);

          if ((fieldKey === '-' || field.key !== fieldKey) && field.editableId === editableId && field.fragmentEntryLinkId === fragmentEntryLinkId) {
            newField = {
              disabled: false,
              key: field.key,
              label: field.label,
              type: field.type
            };
          } else if (fieldKey !== '-' && field.key === fieldKey) {
            newField.disabled = true;
            newField.editableId = editableId;
            newField.fragmentEntryLinkId = fragmentEntryLinkId;
          }

          return newField;
        });
        this.emit('fieldsChanged', {
          fields: newFields,
          serializedFields: this._getSerializedFields(newFields)
        });
      }
    }, {
      key: "_getSerializedFields",
      value: function _getSerializedFields(fields) {
        var _this2 = this;

        var ddmForm = {
          availableLanguagesIds: [this.languageId],
          defaultLanguageId: this.languageId,
          fieldValues: fields.map(function (field) {
            var itemValue = '';

            _this2.selectedItems.forEach(function (selectedItem) {
              if (selectedItem.editableId === field.editableId && selectedItem.fragmentEntryLinkId === field.fragmentEntryLinkId) {
                itemValue = selectedItem.itemValue;
              }
            });

            return {
              name: field.key,
              value: itemValue
            };
          })
        };
        return JSON.stringify(ddmForm);
      }
    }]);

    return MapContentForm;
  }(_frontendJsWeb.PortletBase);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.MapContentForm = MapContentForm;
  MapContentForm.STATE = {
    /**
     * Selected structure label
     * @default null
     * @instance
     * @memberOf MapContentForm
     * @private
     * @review
     * @type {string}
     */
    _structureLabel: _metalState.Config.string().value(''),

    /**
     * @default undefined
     * @instance
     * @memberOf MapContentForm
     * @review
     * @type {object}
     */
    ddmStructure: _metalState.Config.shapeOf({
      id: _metalState.Config.string().required(),
      label: _metalState.Config.string().required()
    }),

    /**
     * Error message
     * @default ''
     * @instance
     * @memberOf MapContentForm
     * @private
     * @review
     * @type {string}
     */
    errorMessage: _metalState.Config.string().value(null),

    /**
     * List of available structure fields
     * @default null
     * @instance
     * @memberOf MapContentForm
     * @private
     * @review
     * @type {Array<{key: !string, label: !string, type: !string}>}
     */
    fields: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      disabled: _metalState.Config.bool().value(false),
      editableId: _metalState.Config.string().value(''),
      fragmentEntryLinkId: _metalState.Config.string().value(null),
      key: _metalState.Config.string().required(),
      label: _metalState.Config.string().required(),
      type: _metalState.Config.string().required()
    })).value(null)
  };
  var ConnectedMapContentForm = (0, _ConnectedComponent["default"])(MapContentForm, ['defaultLanguageId', 'defaultSegmentsExperienceId', 'fragmentEntryLinks', 'languageId', 'layoutData', 'portletNamespace', 'savingChanges', 'segmentsExperienceId', 'selectedItems']);
  exports.ConnectedMapContentForm = ConnectedMapContentForm;

  _metalSoy["default"].register(ConnectedMapContentForm, _MapContentForm["default"]);

  var _default = ConnectedMapContentForm;
  exports["default"] = _default;
  //# sourceMappingURL=MapContentForm.es.js.map
});
//# sourceMappingURL=MapContentForm.es.js.map