Liferay.Loader.define("layout-content-page-editor-web@1.0.126/js/FragmentsEditor.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './components/fragment_entry_link/FragmentEntryLinkList.es', './components/sidebar/FragmentsEditorSidebar.es', './components/toolbar/FragmentsEditorToolbar.es', './FragmentsEditor.soy', './actions/actions.es', './actions/updateActiveItem.es', './store/state.es', './store/store.es', './utils/FragmentsEditorDialogUtils', './utils/FragmentsEditorGetUtils.es', './utils/constants'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.FragmentsEditor = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  require("./components/fragment_entry_link/FragmentEntryLinkList.es");

  require("./components/sidebar/FragmentsEditorSidebar.es");

  require("./components/toolbar/FragmentsEditorToolbar.es");

  var _FragmentsEditor = _interopRequireDefault(require("./FragmentsEditor.soy"));

  var _actions = require("./actions/actions.es");

  var _updateActiveItem2 = require("./actions/updateActiveItem.es");

  var _state = require("./store/state.es");

  var _store = require("./store/store.es");

  var _FragmentsEditorDialogUtils = require("./utils/FragmentsEditorDialogUtils");

  var _FragmentsEditorGetUtils = require("./utils/FragmentsEditorGetUtils.es");

  var _constants = require("./utils/constants");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * @type {string}
   */
  var ITEM_CLASS = 'fragments-editor__item';
  /**
   * @type {string}
   */

  var HOVERED_ITEM_CLASS = "".concat(ITEM_CLASS, "--hovered");
  /**
   * DOM selector where the sidebar is rendered
   */

  var SIDEBAR_SELECTOR = '.fragments-editor-sidebar';
  /**
   * DOM selector where the fragmentEntryLinks are rendered
   */

  var WRAPPER_SELECTOR = '.fragment-entry-link-list-wrapper';
  /**
   * FragmentsEditor
   * @review
   */

  var FragmentsEditor = /*#__PURE__*/function (_Component) {
    _inherits(FragmentsEditor, _Component);

    function FragmentsEditor() {
      _classCallCheck(this, FragmentsEditor);

      return _possibleConstructorReturn(this, _getPrototypeOf(FragmentsEditor).apply(this, arguments));
    }

    _createClass(FragmentsEditor, [{
      key: "created",

      /**
       * @inheritdoc
       * @review
       */
      value: function created() {
        this._handleDocumentClick = this._handleDocumentClick.bind(this);
        this._handleDocumentKeyDown = this._handleDocumentKeyDown.bind(this);
        this._handleDocumentKeyUp = this._handleDocumentKeyUp.bind(this);
        this._handleDocumentMouseOver = this._handleDocumentMouseOver.bind(this);
        document.addEventListener('click', this._handleDocumentClick, true);
        document.addEventListener('keydown', this._handleDocumentKeyDown);
        document.addEventListener('keyup', this._handleDocumentKeyUp);
        document.addEventListener('mouseover', this._handleDocumentMouseOver);
      }
      /**
       * @inheritdoc
       * @review
       */

    }, {
      key: "disposed",
      value: function disposed() {
        document.removeEventListener('click', this._handleDocumentClick, true);
        document.removeEventListener('keydown', this._handleDocumentKeyDown);
        document.removeEventListener('keyup', this._handleDocumentKeyUp);
        document.removeEventListener('mouseover', this._handleDocumentMouseOver);
        (0, _FragmentsEditorDialogUtils.stopListeningWidgetConfigurationChange)();
      }
      /**
       * @inheritdoc
       * @review
       */

    }, {
      key: "syncStore",
      value: function syncStore() {
        if (this.store) {
          (0, _FragmentsEditorDialogUtils.startListeningWidgetConfigurationChange)(this.store);
        }
      }
      /**
       * @param {MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleDocumentClick",
      value: function _handleDocumentClick(event) {
        this._updateActiveItem(event);
      }
      /**
       * @param {KeyboardEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleDocumentKeyDown",
      value: function _handleDocumentKeyDown(event) {
        this._shiftPressed = event.shiftKey;
      }
      /**
       * @param {KeyboardEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleDocumentKeyUp",
      value: function _handleDocumentKeyUp(event) {
        this._shiftPressed = event.shiftKey;

        if (event.key !== 'Shift') {
          this._updateActiveItem(event);
        }
      }
      /**
       * @param {MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleDocumentMouseOver",
      value: function _handleDocumentMouseOver(event) {
        if (this.store) {
          this._updateHoveredItem(event);
        }
      }
      /**
       * @param {KeyboardEvent|MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_updateActiveItem",
      value: function _updateActiveItem(event) {
        var _FragmentsEditor$_get = FragmentsEditor._getTargetItemData(event),
            targetItemId = _FragmentsEditor$_get.targetItemId,
            targetItemType = _FragmentsEditor$_get.targetItemType;

        if (targetItemId && targetItemType) {
          this.store.dispatch((0, _updateActiveItem2.updateActiveItemAction)(targetItemId, targetItemType, {
            appendItem: this._shiftPressed
          }));
        } else if ((_metalDom["default"].closest(event.target, WRAPPER_SELECTOR) || event.target === document.querySelector(WRAPPER_SELECTOR)) && !_metalDom["default"].closest(event.target, SIDEBAR_SELECTOR)) {
          this.store.dispatch({
            type: _actions.CLEAR_ACTIVE_ITEM
          });
        }
      }
      /**
       * Update hovered item
       * @param {MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_updateHoveredItem",
      value: function _updateHoveredItem(event) {
        var _FragmentsEditor$_get2 = FragmentsEditor._getTargetItemData(event),
            targetItemId = _FragmentsEditor$_get2.targetItemId,
            targetItemType = _FragmentsEditor$_get2.targetItemType;

        var hoveredItemId = targetItemId;
        var hoveredItemType = targetItemType;
        document.querySelectorAll(".".concat(HOVERED_ITEM_CLASS)).forEach(function (hoveredItem) {
          hoveredItem.classList.remove(HOVERED_ITEM_CLASS);
        });
        var targetItems = (0, _FragmentsEditorGetUtils.getElements)(targetItemId, targetItemType);

        if (targetItems.length === 0) {
          var targetItemIsEditable = targetItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.editable || targetItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.backgroundImageEditable;

          if (targetItemIsEditable && !targetItems[0].classList.contains('fragments-editor__editable--highlighted')) {
            var fragment = (0, _FragmentsEditorGetUtils.getElements)(targetItems[0].dataset.fragmentEntryLinkId, _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment)[0];
            hoveredItemId = fragment.dataset.fragmentsEditorItemId;
            hoveredItemType = _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment;
          }
        } else if (targetItems.length > 1) {
          targetItems.forEach(function (targetItem) {
            targetItem.classList.add(ITEM_CLASS);
            targetItem.classList.add(HOVERED_ITEM_CLASS);
          });
        }

        if (hoveredItemId && hoveredItemType) {
          this.store.dispatch({
            hoveredItemId: hoveredItemId,
            hoveredItemType: hoveredItemType,
            type: _actions.UPDATE_HOVERED_ITEM
          });
        } else {
          this.store.dispatch({
            type: _actions.CLEAR_HOVERED_ITEM
          });
        }
      }
    }], [{
      key: "_getTargetItemData",

      /**
       * @param {KeyboardEvent|MouseEvent} event
       * @return {{targetItem: HTMLElement, targetItemId: string|null, targetItemType: string|null}}
       * @private
       * @review
       */
      value: function _getTargetItemData(event) {
        var targetItem = event.target;

        var _ref = targetItem.dataset || {},
            _ref$targetItemId = _ref.targetItemId,
            targetItemId = _ref$targetItemId === void 0 ? null : _ref$targetItemId,
            _ref$targetItemType = _ref.targetItemType,
            targetItemType = _ref$targetItemType === void 0 ? null : _ref$targetItemType;

        if (!targetItemId || !targetItemType) {
          targetItem = _metalDom["default"].closest(event.target, '[data-fragments-editor-item-id]');

          if (targetItem) {
            targetItemId = targetItem.dataset.fragmentsEditorItemId;
            targetItemType = targetItem.dataset.fragmentsEditorItemType;
          }
        }

        return {
          targetItem: targetItem,
          targetItemId: targetItemId,
          targetItemType: targetItemType
        };
      }
    }]);

    return FragmentsEditor;
  }(_metalComponent["default"]);
  /**
   * State definition.
   * @review
   * @static
   * @type {object}
   */

  exports.FragmentsEditor = FragmentsEditor;
  FragmentsEditor.STATE = _objectSpread({
    /**
     * @default false
     * @instance
     * @memberOf FragmentsEditor
     * @private
     * @review
     * @type {boolean}
     */
    _shiftPressed: _metalState.Config.bool().internal().value(false),

    /**
     * Store instance
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {Store}
     */
    store: _metalState.Config.instanceOf(_store.Store)
  }, _state.INITIAL_STATE);

  _metalSoy["default"].register(FragmentsEditor, _FragmentsEditor["default"]);

  var _default = FragmentsEditor;
  exports["default"] = _default;
  //# sourceMappingURL=FragmentsEditor.es.js.map
});
//# sourceMappingURL=FragmentsEditor.es.js.map