/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.util.structure;

import com.liferay.layout.responsive.ViewportSize;
import com.liferay.layout.util.structure.CommonStylesUtil;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class StyledLayoutStructureItem
extends LayoutStructureItem {
    protected JSONObject stylesJSONObject = JSONFactoryUtil.createJSONObject();
    protected Map<String, JSONObject> viewportStyleJSONObjects = new HashMap<String, JSONObject>();
    private static final Log _log = LogFactoryUtil.getLog(StyledLayoutStructureItem.class);

    public StyledLayoutStructureItem(String parentItemId) {
        super(parentItemId);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StyledLayoutStructureItem)) {
            return false;
        }
        StyledLayoutStructureItem styledLayoutStructureItem = (StyledLayoutStructureItem)object;
        JSONObject stylesJSONObject = styledLayoutStructureItem.stylesJSONObject;
        for (String key : this.stylesJSONObject.keySet()) {
            if (Objects.deepEquals(GetterUtil.getString((Object)this.stylesJSONObject.get(key)), GetterUtil.getString((Object)stylesJSONObject.get(key)))) continue;
            return false;
        }
        return super.equals(object);
    }

    public String getAlign() {
        return GetterUtil.getString((Object)this._getStyleProperty("align"));
    }

    public String getBackgroundColor() {
        return this._getColor("backgroundColor");
    }

    public String getBackgroundColorCssClass() {
        return this._getColorCssClass("backgroundColor");
    }

    public JSONObject getBackgroundImageJSONObject() {
        return (JSONObject)this._getStyleProperty("backgroundImage");
    }

    public String getBorderColor() {
        return this._getColor("borderColor");
    }

    public String getBorderColorCssClass() {
        return this._getColorCssClass("borderColor");
    }

    public String getBorderRadius() {
        return GetterUtil.getString((Object)this._getStyleProperty("borderRadius"));
    }

    public int getBorderWidth() {
        return GetterUtil.getInteger((Object)this._getStyleProperty("borderWidth"));
    }

    public String getContentDisplay() {
        return GetterUtil.getString((Object)this._getStyleProperty("display"));
    }

    public String getFontFamily() {
        return GetterUtil.getString((Object)this._getStyleProperty("fontFamily"));
    }

    public String getFontSize() {
        return GetterUtil.getString((Object)this._getStyleProperty("fontSize"));
    }

    public String getFontWeight() {
        return GetterUtil.getString((Object)this._getStyleProperty("fontWeight"));
    }

    @Deprecated
    public String getFontWeightCssClass() {
        return "";
    }

    public String getHeight() {
        return GetterUtil.getString((Object)this._getStyleProperty("height"));
    }

    @Override
    public JSONObject getItemConfigJSONObject() {
        try {
            Map<String, Object> defaultValues = CommonStylesUtil.getDefaultStyleValues();
            for (Map.Entry<String, Object> entry : defaultValues.entrySet()) {
                if (this.stylesJSONObject.has(entry.getKey())) continue;
                this.stylesJSONObject.put(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get default style values", (Throwable)exception);
        }
        JSONObject jsonObject = JSONUtil.put((String)"styles", (Object)this.stylesJSONObject);
        for (ViewportSize viewportSize : ViewportSize.values()) {
            if (viewportSize.equals((Object)ViewportSize.DESKTOP)) continue;
            jsonObject.put(viewportSize.getViewportSizeId(), JSONUtil.put((String)"styles", (Object)this.viewportStyleJSONObjects.getOrDefault(viewportSize.getViewportSizeId(), JSONFactoryUtil.createJSONObject())));
        }
        return jsonObject;
    }

    public String getJustify() {
        return GetterUtil.getString((Object)this._getStyleProperty("justify"));
    }

    public int getMarginBottom() {
        return GetterUtil.getInteger((Object)this._getStyleProperty("marginBottom"));
    }

    public int getMarginLeft() {
        return GetterUtil.getInteger((Object)this._getStyleProperty("marginLeft"));
    }

    public int getMarginRight() {
        return GetterUtil.getInteger((Object)this._getStyleProperty("marginRight"));
    }

    public int getMarginTop() {
        return GetterUtil.getInteger((Object)this._getStyleProperty("marginTop"));
    }

    public String getMaxHeight() {
        return GetterUtil.getString((Object)this._getStyleProperty("maxHeight"));
    }

    public String getMaxWidth() {
        return GetterUtil.getString((Object)this._getStyleProperty("maxWidth"));
    }

    public String getMinHeight() {
        return GetterUtil.getString((Object)this._getStyleProperty("minHeight"));
    }

    public String getMinWidth() {
        return GetterUtil.getString((Object)this._getStyleProperty("minWidth"));
    }

    public int getOpacity() {
        return GetterUtil.getInteger((Object)this._getStyleProperty("opacity"));
    }

    public String getOverflow() {
        return GetterUtil.getString((Object)this._getStyleProperty("overflow"));
    }

    public int getPaddingBottom() {
        return GetterUtil.getInteger((Object)this._getStyleProperty("paddingBottom"));
    }

    public int getPaddingLeft() {
        return GetterUtil.getInteger((Object)this._getStyleProperty("paddingLeft"));
    }

    public int getPaddingRight() {
        return GetterUtil.getInteger((Object)this._getStyleProperty("paddingRight"));
    }

    public int getPaddingTop() {
        return GetterUtil.getInteger((Object)this._getStyleProperty("paddingTop"));
    }

    public String getShadow() {
        return GetterUtil.getString((Object)this._getStyleProperty("shadow"));
    }

    public String getTextAlignCssClass() {
        return GetterUtil.getString((Object)this._getStyleProperty("textAlign"));
    }

    public String getTextColor() {
        return this._getColor("textColor");
    }

    public String getTextColorCssClass() {
        return this._getColorCssClass("textColor");
    }

    public String getWidth() {
        return GetterUtil.getString((Object)this._getStyleProperty("width"));
    }

    @Override
    public int hashCode() {
        return HashUtil.hash((int)0, (Object)this.getItemId());
    }

    @Override
    public void updateItemConfig(JSONObject itemConfigJSONObject) {
        try {
            List<String> availableStyleNames = CommonStylesUtil.getAvailableStyleNames();
            for (String styleName : availableStyleNames) {
                if (!itemConfigJSONObject.has(styleName)) continue;
                this.stylesJSONObject.put(styleName, itemConfigJSONObject.get(styleName));
            }
            if (itemConfigJSONObject.has("styles")) {
                JSONObject newStylesJSONObject = itemConfigJSONObject.getJSONObject("styles");
                for (String styleName : availableStyleNames) {
                    if (!newStylesJSONObject.has(styleName)) continue;
                    this.stylesJSONObject.put(styleName, newStylesJSONObject.get(styleName));
                }
            }
            for (ViewportSize viewportSize : ViewportSize.values()) {
                if (viewportSize.equals((Object)ViewportSize.DESKTOP)) continue;
                JSONObject currentViewportStyleJSONObject = this.viewportStyleJSONObjects.getOrDefault(viewportSize.getViewportSizeId(), JSONFactoryUtil.createJSONObject());
                if (itemConfigJSONObject.has(viewportSize.getViewportSizeId())) {
                    JSONObject viewportItemConfigJSONObject = itemConfigJSONObject.getJSONObject(viewportSize.getViewportSizeId());
                    JSONObject newStylesJSONObject = viewportItemConfigJSONObject.getJSONObject("styles");
                    if (newStylesJSONObject == null) continue;
                    for (String styleName : availableStyleNames) {
                        if (!newStylesJSONObject.has(styleName)) continue;
                        currentViewportStyleJSONObject.put(styleName, newStylesJSONObject.get(styleName));
                    }
                }
                this.viewportStyleJSONObjects.put(viewportSize.getViewportSizeId(), currentViewportStyleJSONObject);
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get available style names", (Throwable)exception);
        }
    }

    private String _getColor(String property) {
        JSONObject configJSONObject = this.getItemConfigJSONObject();
        Object configColorObject = configJSONObject.get(property);
        Object styleColorObject = this.stylesJSONObject.get(property);
        if (styleColorObject == null && configColorObject != null) {
            if (configColorObject instanceof String) {
                return GetterUtil.getString((Object)configColorObject);
            }
            JSONObject configColorJSONObject = configJSONObject.getJSONObject(property);
            return configColorJSONObject.getString("rgbValue", "");
        }
        if (styleColorObject != null && styleColorObject instanceof String) {
            return GetterUtil.getString((Object)styleColorObject);
        }
        if (styleColorObject != null && styleColorObject instanceof JSONObject) {
            JSONObject styleColorJSONObject = this.stylesJSONObject.getJSONObject(property);
            return styleColorJSONObject.getString("rgbValue", "");
        }
        return "";
    }

    private String _getColorCssClass(String property) {
        JSONObject configJSONObject = this.getItemConfigJSONObject();
        JSONObject configColorJSONObject = configJSONObject.getJSONObject(property);
        JSONObject styleColorJSONObject = this.stylesJSONObject.getJSONObject(property);
        if (!(styleColorJSONObject != null && styleColorJSONObject.has("cssClass") || configColorJSONObject == null)) {
            return configColorJSONObject.getString("cssClass", configColorJSONObject.getString("color", ""));
        }
        if (styleColorJSONObject == null) {
            return "";
        }
        return styleColorJSONObject.getString("cssClass", styleColorJSONObject.getString("color", ""));
    }

    private Object _getStyleProperty(String propertyKey) {
        JSONObject configJSONObject = this.getItemConfigJSONObject();
        Object configValue = configJSONObject.get(propertyKey);
        Object styleValue = this.stylesJSONObject.get(propertyKey);
        if (configValue != null && styleValue == null) {
            return configValue;
        }
        if (styleValue != null) {
            return styleValue;
        }
        return CommonStylesUtil.getDefaultStyleValue(propertyKey);
    }
}

